/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;

public final class StatementGenericPermission
extends StatementPermission {
    private UUID _objectID;
    private String _objectType;
    private String _privilege;

    public StatementGenericPermission(UUID uUID, String string, String string2) {
        this._objectID = uUID;
        this._objectType = string;
        this._privilege = string2;
    }

    public UUID getObjectID() {
        return this._objectID;
    }

    public String getPrivilege() {
        return this._privilege;
    }

    @Override
    public String getObjectType() {
        return this._objectType;
    }

    @Override
    public void check(LanguageConnectionContext languageConnectionContext, boolean bl2, Activation activation) throws StandardException {
        this.genericCheck(languageConnectionContext, bl2, activation, this._privilege);
    }

    @Override
    public boolean isCorrectPermission(PermissionsDescriptor permissionsDescriptor) {
        if (permissionsDescriptor == null || !(permissionsDescriptor instanceof PermDescriptor)) {
            return false;
        }
        PermDescriptor permDescriptor = (PermDescriptor)permissionsDescriptor;
        return permDescriptor.getPermObjectId().equals(this._objectID) && permDescriptor.getObjectType().equals(this._objectType) && permDescriptor.getPermission().equals(this._privilege);
    }

    @Override
    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dataDictionary) throws StandardException {
        if ("TYPE".equals(this._objectType)) {
            return dataDictionary.getAliasDescriptor(this._objectID);
        }
        if ("DERBY AGGREGATE".equals(this._objectType)) {
            return dataDictionary.getAliasDescriptor(this._objectID);
        }
        if ("SEQUENCE".equals(this._objectType)) {
            return dataDictionary.getSequenceDescriptor(this._objectID);
        }
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        return dataDictionary.getGenericPermissions(this._objectID, this._objectType, this._privilege, string);
    }

    public String toString() {
        return "StatementGenericPermission( " + this._objectID + ", " + this._objectType + ", " + this._privilege + " )";
    }
}

