/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ForeignKeyConstraintDescriptor
extends KeyConstraintDescriptor {
    ReferencedKeyConstraintDescriptor referencedConstraintDescriptor;
    UUID referencedConstraintId;
    int raDeleteRule;
    int raUpdateRule;

    protected ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, boolean bl4, int n2, int n3) {
        super(dataDictionary, tableDescriptor, string, bl2, bl3, nArray, uUID, uUID2, schemaDescriptor, bl4);
        this.referencedConstraintDescriptor = referencedKeyConstraintDescriptor;
        this.raDeleteRule = n2;
        this.raUpdateRule = n3;
    }

    ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, UUID uUID3, boolean bl4, int n2, int n3) {
        super(dataDictionary, tableDescriptor, string, bl2, bl3, nArray, uUID, uUID2, schemaDescriptor, bl4);
        this.referencedConstraintId = uUID3;
        this.raDeleteRule = n2;
        this.raUpdateRule = n3;
    }

    public ReferencedKeyConstraintDescriptor getReferencedConstraint() throws StandardException {
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor;
        }
        if (this.referencedConstraintId == null) {
            this.getReferencedConstraintId();
        }
        TableDescriptor tableDescriptor = this.getDataDictionary().getConstraintTableDescriptor(this.referencedConstraintId);
        ConstraintDescriptorList constraintDescriptorList = this.getDataDictionary().getConstraintDescriptors(tableDescriptor);
        this.referencedConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptorList.getConstraintDescriptorById(this.referencedConstraintId);
        return this.referencedConstraintDescriptor;
    }

    public UUID getReferencedConstraintId() throws StandardException {
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor.getUUID();
        }
        SubKeyConstraintDescriptor subKeyConstraintDescriptor = this.getDataDictionary().getSubKeyConstraint(this.constraintId, 6);
        this.referencedConstraintId = subKeyConstraintDescriptor.getKeyConstraintId();
        return this.referencedConstraintId;
    }

    @Override
    public int getConstraintType() {
        return 6;
    }

    @Override
    public boolean needsToFire(int n2, int[] nArray) {
        if (!this.enforced()) {
            return false;
        }
        if (n2 == 4) {
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        return ForeignKeyConstraintDescriptor.doColumnsIntersect(nArray, this.getReferencedColumns());
    }

    public boolean isSelfReferencingFK() throws StandardException {
        ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = this.getReferencedConstraint();
        return referencedKeyConstraintDescriptor.getTableId().equals(this.getTableId());
    }

    public int getRaDeleteRule() {
        return this.raDeleteRule;
    }

    public int getRaUpdateRule() {
        return this.raUpdateRule;
    }
}

