/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Timestamp;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public class DataDescriptorGenerator {
    private UUIDFactory uuidf;
    protected final DataDictionary dataDictionary;

    public DataDescriptorGenerator(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public SchemaDescriptor newSchemaDescriptor(String string, String string2, UUID uUID) throws StandardException {
        return new SchemaDescriptor(this.dataDictionary, string, string2, uUID, this.dataDictionary.isSystemSchemaName(string));
    }

    public TableDescriptor newTableDescriptor(String string, SchemaDescriptor schemaDescriptor, int n2, char c2) {
        return new TableDescriptor(this.dataDictionary, string, schemaDescriptor, n2, c2);
    }

    public TableDescriptor newTableDescriptor(String string, SchemaDescriptor schemaDescriptor, int n2, boolean bl2, boolean bl3) {
        return new TableDescriptor(this.dataDictionary, string, schemaDescriptor, n2, bl2, bl3);
    }

    public ViewDescriptor newViewDescriptor(UUID uUID, String string, String string2, int n2, UUID uUID2) {
        return new ViewDescriptor(this.dataDictionary, uUID, string, string2, n2, uUID2);
    }

    public ReferencedKeyConstraintDescriptor newUniqueConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, boolean bl4, int n2) {
        return new ReferencedKeyConstraintDescriptor(3, this.dataDictionary, tableDescriptor, string, bl2, bl3, nArray, uUID, uUID2, schemaDescriptor, bl4, n2);
    }

    public ReferencedKeyConstraintDescriptor newPrimaryKeyConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, boolean bl4, int n2) {
        return new ReferencedKeyConstraintDescriptor(2, this.dataDictionary, tableDescriptor, string, bl2, bl3, nArray, uUID, uUID2, schemaDescriptor, bl4, n2);
    }

    public ForeignKeyConstraintDescriptor newForeignKeyConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, boolean bl4, int n2, int n3) {
        return new ForeignKeyConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl2, bl3, nArray, uUID, uUID2, schemaDescriptor, referencedKeyConstraintDescriptor, bl4, n2, n3);
    }

    public ForeignKeyConstraintDescriptor newForeignKeyConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, int[] nArray, UUID uUID, UUID uUID2, SchemaDescriptor schemaDescriptor, UUID uUID3, boolean bl4, int n2, int n3) {
        return new ForeignKeyConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl2, bl3, nArray, uUID, uUID2, schemaDescriptor, uUID3, bl4, n2, n3);
    }

    public CheckConstraintDescriptor newCheckConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, UUID uUID, String string2, ReferencedColumns referencedColumns, SchemaDescriptor schemaDescriptor, boolean bl4) {
        return new CheckConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl2, bl3, uUID, string2, referencedColumns, schemaDescriptor, bl4);
    }

    public CheckConstraintDescriptor newCheckConstraintDescriptor(TableDescriptor tableDescriptor, String string, boolean bl2, boolean bl3, UUID uUID, String string2, int[] nArray, SchemaDescriptor schemaDescriptor, boolean bl4) {
        ReferencedColumnsDescriptorImpl referencedColumnsDescriptorImpl = new ReferencedColumnsDescriptorImpl(nArray);
        return new CheckConstraintDescriptor(this.dataDictionary, tableDescriptor, string, bl2, bl3, uUID, string2, referencedColumnsDescriptorImpl, schemaDescriptor, bl4);
    }

    public ConglomerateDescriptor newConglomerateDescriptor(long l2, String string, boolean bl2, IndexRowGenerator indexRowGenerator, boolean bl3, UUID uUID, UUID uUID2, UUID uUID3) {
        return new ConglomerateDescriptor(this.dataDictionary, l2, string, bl2, indexRowGenerator, bl3, uUID, uUID2, uUID3);
    }

    public TriggerDescriptor newTriggerDescriptor(SchemaDescriptor schemaDescriptor, UUID uUID, String string, int n2, boolean bl2, boolean bl3, boolean bl4, TableDescriptor tableDescriptor, UUID uUID2, UUID uUID3, Timestamp timestamp, int[] nArray, int[] nArray2, String string2, boolean bl5, boolean bl6, String string3, String string4, String string5) throws StandardException {
        return new TriggerDescriptor(this.dataDictionary, schemaDescriptor, uUID, string, n2, bl2, bl3, bl4, tableDescriptor, uUID2, uUID3, timestamp, nArray, nArray2, string2, bl5, bl6, string3, string4, string5);
    }

    protected UUIDFactory getUUIDFactory() {
        if (this.uuidf == null) {
            this.uuidf = DataDescriptorGenerator.getMonitor().getUUIDFactory();
        }
        return this.uuidf;
    }

    public FileInfoDescriptor newFileInfoDescriptor(UUID uUID, SchemaDescriptor schemaDescriptor, String string, long l2) {
        return new FileInfoDescriptor(this.dataDictionary, uUID, schemaDescriptor, string, l2);
    }

    public UserDescriptor newUserDescriptor(String string, String string2, char[] cArray, Timestamp timestamp) {
        return new UserDescriptor(this.dataDictionary, string, string2, cArray, timestamp);
    }

    public TablePermsDescriptor newTablePermsDescriptor(TableDescriptor tableDescriptor, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws StandardException {
        if ("N".equals(string) && "N".equals(string2) && "N".equals(string3) && "N".equals(string4) && "N".equals(string5) && "N".equals(string6)) {
            return null;
        }
        return new TablePermsDescriptor(this.dataDictionary, null, string7, tableDescriptor.getUUID(), string, string2, string3, string4, string5, string6);
    }

    public ColPermsDescriptor newColPermsDescriptor(TableDescriptor tableDescriptor, String string, FormatableBitSet formatableBitSet, String string2) throws StandardException {
        return new ColPermsDescriptor(this.dataDictionary, null, string2, tableDescriptor.getUUID(), string, formatableBitSet);
    }

    public RoutinePermsDescriptor newRoutinePermsDescriptor(AliasDescriptor aliasDescriptor, String string) throws StandardException {
        return new RoutinePermsDescriptor(this.dataDictionary, null, string, aliasDescriptor.getUUID());
    }

    public RoleGrantDescriptor newRoleGrantDescriptor(UUID uUID, String string, String string2, String string3, boolean bl2, boolean bl3) throws StandardException {
        return new RoleGrantDescriptor(this.dataDictionary, uUID, string, string2, string3, bl2, bl3);
    }

    public SequenceDescriptor newSequenceDescriptor(SchemaDescriptor schemaDescriptor, UUID uUID, String string, DataTypeDescriptor dataTypeDescriptor, Long l2, long l3, long l4, long l5, long l6, boolean bl2) {
        return new SequenceDescriptor(this.dataDictionary, schemaDescriptor, uUID, string, dataTypeDescriptor, l2, l3, l4, l5, l6, bl2);
    }

    public PermDescriptor newPermDescriptor(UUID uUID, String string, UUID uUID2, String string2, String string3, String string4, boolean bl2) {
        return new PermDescriptor(this.dataDictionary, uUID, string, uUID2, string2, string3, string4, bl2);
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

