/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConsInfo;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class DDUtils {
    public static ReferencedKeyConstraintDescriptor locateReferencedConstraint(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, String[] stringArray, ConsInfo consInfo) throws StandardException {
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        if (tableDescriptor2 == null) {
            throw StandardException.newException("X0Y46.S", string, consInfo.getReferencedTableName());
        }
        String[] stringArray2 = consInfo.getReferencedColumnNames();
        if (stringArray2 == null || stringArray2.length == 0) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = tableDescriptor2.getPrimaryKey();
            if (referencedKeyConstraintDescriptor == null) {
                throw StandardException.newException("X0Y41.S", string, tableDescriptor2.getQualifiedName());
            }
            ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
            if (columnDescriptorList.size() != referencedKeyConstraintDescriptor.getColumnDescriptors().size()) {
                throw StandardException.newException("X0Y43.S", string, String.valueOf(columnDescriptorList.size()), String.valueOf(referencedKeyConstraintDescriptor.getColumnDescriptors().size()));
            }
            if (!referencedKeyConstraintDescriptor.areColumnsComparable(columnDescriptorList)) {
                throw StandardException.newException("X0Y42.S", string);
            }
            return referencedKeyConstraintDescriptor;
        }
        ColumnDescriptorList columnDescriptorList = DDUtils.getColumnDescriptors(dataDictionary, tableDescriptor, stringArray);
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n2 = constraintDescriptorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i2);
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) || !constraintDescriptor.areColumnsComparable(columnDescriptorList) || !DDUtils.columnNamesMatch(stringArray2, constraintDescriptor.getColumnDescriptors())) continue;
            if (constraintDescriptor.deferrable() && ((n3 = consInfo.getReferentialActionDeleteRule()) == 0 || n3 == 3)) {
                throw StandardException.newException("X0Y47.S", string, tableDescriptor2.getQualifiedName());
            }
            return (ReferencedKeyConstraintDescriptor)constraintDescriptor;
        }
        throw StandardException.newException("X0Y44.S", string, tableDescriptor2.getQualifiedName());
    }

    public static ColumnDescriptorList getColumnDescriptors(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String[] stringArray) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i2]);
            columnDescriptorList.add(tableDescriptor.getUUID(), columnDescriptor);
        }
        return columnDescriptorList;
    }

    public static boolean columnNamesMatch(String[] stringArray, ColumnDescriptorList columnDescriptorList) throws StandardException {
        if (stringArray.length != columnDescriptorList.size()) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = columnDescriptorList.elementAt(i2).getColumnName();
            if (string.equals(stringArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static void validateReferentialActions(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, ConsInfo consInfo, String[] stringArray) throws StandardException {
        int n2 = consInfo.getReferentialActionDeleteRule();
        if (n2 == 3) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i2]);
                if (!columnDescriptor.getType().isNullable()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw StandardException.newException("42834", string);
            }
        }
        TableDescriptor tableDescriptor2 = consInfo.getReferencedTableDescriptor(dataDictionary);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        boolean bl3 = tableDescriptor2.getUUID().equals(tableDescriptor.getUUID());
        String string2 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
        int n3 = DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor, -1, hashtable, false, true);
        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor2, n2, hashtable, new Hashtable<String, Integer>(hashtable), true, string, false, new StringBuffer(0), string2, bl3, n3);
        if (!bl3) {
            DDUtils.checkForAnyExistingDeleteConnectionViolations(dataDictionary, tableDescriptor, n2, hashtable, string);
        }
    }

    private static int getCurrentDeleteConnections(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n2, Hashtable<String, Integer> hashtable, boolean bl2, boolean bl3) throws StandardException {
        int n3 = -1;
        tableDescriptor.emptyConstraintDescriptorList();
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        int n4 = constraintDescriptorList.size();
        boolean bl4 = bl2;
        for (int i2 = 0; i2 < n4; ++i2) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i2);
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            String string = foreignKeyConstraintDescriptor.getConstraintName();
            int n5 = foreignKeyConstraintDescriptor.getRaDeleteRule();
            int n6 = foreignKeyConstraintDescriptor.getRaUpdateRule();
            if (bl3 && foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                n3 = n5;
                bl3 = false;
            }
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            TableDescriptor tableDescriptor2 = referencedKeyConstraintDescriptor.getTableDescriptor();
            int n7 = n2 == -1 ? n5 : n2;
            String string2 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
            Integer n8 = hashtable.get(string2);
            if (n8 != null) {
                bl2 = bl4;
                continue;
            }
            if (n5 != 0) {
                if (bl2) {
                    bl2 = bl4;
                    continue;
                }
                bl2 = true;
            }
            hashtable.put(string2, n7);
            if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, n7, hashtable, true, false);
            }
            bl2 = bl4;
        }
        return n3;
    }

    private static void validateDeleteConnection(DataDictionary dataDictionary, TableDescriptor tableDescriptor, TableDescriptor tableDescriptor2, int n2, Hashtable<String, Integer> hashtable, Hashtable<String, Integer> hashtable2, boolean bl2, String string, boolean bl3, StringBuffer stringBuffer, String string2, boolean bl4, int n3) throws StandardException {
        Integer n4;
        if (bl2) {
            String string3 = tableDescriptor2.getSchemaName() + "." + tableDescriptor2.getName();
            n4 = hashtable.get(string3);
            if (bl4) {
                if (n3 != -1) {
                    if (n3 != n2) {
                        if (n3 == 3) {
                            throw DDUtils.generateError("XCL33.S", string, string2);
                        }
                        throw DDUtils.generateError("XCL36.S", string, n3);
                    }
                    if (n3 == 3 && n2 == 3) {
                        throw DDUtils.generateError("XCL33.S", string, string2);
                    }
                }
                if (bl4 && hashtable.contains(0) && n2 != 0) {
                    throw DDUtils.generateError("XCL37.S", string, 0);
                }
                return;
            }
            if (n3 != -1 && n2 == 0 && n3 != 0) {
                throw DDUtils.generateError("XCL39.S", string);
            }
            if (n4 != null) {
                DDUtils.checkForMultiplePathInvalidCases(n4, n2, string, string2);
            }
            if (n2 != 0) {
                bl3 = true;
            }
            stringBuffer.append(n2);
        }
        boolean bl5 = bl3;
        boolean bl6 = true;
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor2);
        int n5 = constraintDescriptorList.size();
        for (int i2 = 0; i2 < n5; ++i2) {
            String string4;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i2);
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            String string5 = foreignKeyConstraintDescriptor.getConstraintName();
            int n6 = foreignKeyConstraintDescriptor.getRaDeleteRule();
            int n7 = foreignKeyConstraintDescriptor.getRaUpdateRule();
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            TableDescriptor tableDescriptor3 = referencedKeyConstraintDescriptor.getTableDescriptor();
            if (n6 != 0) {
                if (bl3) {
                    bl3 = bl5;
                    continue;
                }
                bl3 = true;
                bl6 = false;
            }
            boolean bl7 = foreignKeyConstraintDescriptor.isSelfReferencingFK();
            stringBuffer.append(n6);
            boolean bl8 = tableDescriptor3.getUUID().equals(tableDescriptor.getUUID());
            if (bl8) {
                for (int i3 = 0; i3 < stringBuffer.length(); ++i3) {
                    int n8 = Character.getNumericValue(stringBuffer.charAt(i3));
                    if (n8 == n2) continue;
                    if (n8 != 0) {
                        throw DDUtils.generateError("XCL40.S", string);
                    }
                    throw DDUtils.generateError("XCL34.S", string, string2);
                }
            }
            if ((n4 = hashtable2.get(string4 = tableDescriptor3.getSchemaName() + "." + tableDescriptor3.getName())) != null) {
                if (!bl7 && bl6) {
                    DDUtils.checkForMultiplePathInvalidCases(n4, n2, string, string2);
                }
            } else {
                n4 = hashtable.get(string4);
                if (n4 == null) {
                    if (bl6) {
                        hashtable.put(string4, n2);
                    }
                    if (!bl7) {
                        DDUtils.validateDeleteConnection(dataDictionary, tableDescriptor, tableDescriptor3, n2, hashtable, hashtable2, false, string, bl3, stringBuffer, string2, bl4, n3);
                    }
                }
            }
            bl3 = bl5;
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
    }

    private static void checkForMultiplePathInvalidCases(int n2, int n3, String string, String string2) throws StandardException {
        if (n2 != n3) {
            if (n2 == 3) {
                throw DDUtils.generateError("XCL35.S", string, string2);
            }
            throw DDUtils.generateError("XCL38.S", string, n2);
        }
        if (n2 == 3 && n3 == 3) {
            throw DDUtils.generateError("XCL35.S", string, string2);
        }
    }

    private static void checkForAnyExistingDeleteConnectionViolations(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n2, Hashtable<String, Integer> hashtable, String string) throws StandardException {
        if (n2 != 0) {
            return;
        }
        String string2 = tableDescriptor.getSchemaName() + "." + tableDescriptor.getName();
        for (ConstraintDescriptor constraintDescriptor : dataDictionary.getConstraintDescriptors(tableDescriptor)) {
            ConstraintDescriptorList constraintDescriptorList;
            int n3;
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) || (n3 = (constraintDescriptorList = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(3))).size()) == 0) continue;
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            for (int i2 = 0; i2 < n3; ++i2) {
                ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList.elementAt(i2);
                TableDescriptor tableDescriptor2 = foreignKeyConstraintDescriptor.getTableDescriptor();
                int n4 = foreignKeyConstraintDescriptor.getRaDeleteRule();
                if (!foreignKeyConstraintDescriptor.isSelfReferencingFK()) {
                    DDUtils.getCurrentDeleteConnections(dataDictionary, tableDescriptor2, -1, hashtable2, false, true);
                    Enumeration<String> enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        int n5;
                        String string3 = enumeration.nextElement();
                        if (string3.equals(string2) || !hashtable.containsKey(string3) || ((n5 = hashtable2.get(string3).intValue()) != 3 || n4 != 3) && n5 == n4) continue;
                        throw DDUtils.generateError("XCL41.S", string);
                    }
                }
                hashtable2.clear();
            }
        }
    }

    private static StandardException generateError(String string, String string2) {
        String string3 = MessageService.getTextMessage(string, new Object[0]);
        return StandardException.newException("42915", string2, string3);
    }

    private static StandardException generateError(String string, String string2, int n2) {
        String string3;
        switch (n2) {
            case 0: {
                string3 = "CASCADE";
                break;
            }
            case 1: {
                string3 = "RESTRICT";
                break;
            }
            case 3: {
                string3 = "SET NULL";
                break;
            }
            case 4: {
                string3 = "SET DEFAULT";
                break;
            }
            default: {
                string3 = "NO ACTION";
            }
        }
        String string4 = MessageService.getTextMessage(string3, new Object[0]);
        String string5 = MessageService.getTextMessage(string, string4);
        return StandardException.newException("42915", string2, string5);
    }

    private static StandardException generateError(String string, String string2, String string3) {
        String string4 = MessageService.getTextMessage(string, string3);
        return StandardException.newException("42915", string2, string4);
    }
}

