/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;

public class StatementUtil {
    private static final String[] TypeNames = new String[]{"", "INSERT", "INSERT", "UPDATE", "DELETE", "ENABLED", "DISABLED"};

    private StatementUtil() {
    }

    public static String typeName(int n2) {
        String string;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = TypeNames[n2];
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public static SchemaDescriptor getSchemaDescriptor(String string, boolean bl2, DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
        SchemaDescriptor schemaDescriptor = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string == null) {
            schemaDescriptor = compilerContext.getCompilationSchema();
            if (schemaDescriptor == null) {
                schemaDescriptor = languageConnectionContext.getDefaultSchema();
                bl3 = true;
                compilerContext.setCompilationSchema(schemaDescriptor);
            } else {
                bl4 = true;
            }
            string = schemaDescriptor.getSchemaName();
        }
        SchemaDescriptor schemaDescriptor2 = dataDictionary.getSchemaDescriptor(string, languageConnectionContext.getTransactionCompile(), bl2);
        if (bl3 || bl4) {
            if (schemaDescriptor2 != null && schemaDescriptor2.getUUID() != null) {
                if (!schemaDescriptor2.getUUID().equals(schemaDescriptor.getUUID())) {
                    if (bl3) {
                        languageConnectionContext.setDefaultSchema(schemaDescriptor2);
                    }
                    compilerContext.setCompilationSchema(schemaDescriptor2);
                }
            } else {
                schemaDescriptor.setUUID(null);
                schemaDescriptor2 = schemaDescriptor;
            }
        }
        return schemaDescriptor2;
    }
}

