/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.property;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

public class PropertyUtil {
    private static final String[] servicePropertyList = new String[]{"derby.engineType", "derby.database.noAutoBoot", "derby.storage.tempDirectory", "encryptionProvider", "encryptionAlgorithm", "restoreFrom", "logDevice", "derby.storage.logArchiveMode"};
    public static final int SET_IN_JVM = 0;
    public static final int SET_IN_DATABASE = 1;
    public static final int SET_IN_APPLICATION = 2;
    public static final int NOT_SET = -1;

    static int whereSet(String string, Dictionary dictionary) {
        boolean bl2 = PropertyUtil.isDBOnly(dictionary);
        if (!bl2 && PropertyUtil.getMonitor().getJVMProperty(string) != null) {
            return 0;
        }
        if (dictionary != null && dictionary.get(string) != null) {
            return 1;
        }
        if (!bl2 && PropertyUtil.getSystemProperty(string) != null) {
            return 2;
        }
        return -1;
    }

    public static boolean isDBOnly(Dictionary dictionary) {
        if (dictionary == null) {
            return false;
        }
        String string = (String)dictionary.get("derby.database.propertiesOnly");
        boolean bl2 = Boolean.valueOf(string != null ? string.trim() : null);
        return bl2;
    }

    public static boolean isDBOnly(Properties properties) {
        if (properties == null) {
            return false;
        }
        String string = properties.getProperty("derby.database.propertiesOnly");
        boolean bl2 = Boolean.valueOf(string != null ? string.trim() : string);
        return bl2;
    }

    public static String[] getServicePropertyList() {
        return ArrayUtil.copy(servicePropertyList);
    }

    public static String getSystemProperty(String string) {
        return PropertyUtil.getSystemProperty(string, null);
    }

    public static String getSystemProperty(String string, String string2) {
        Properties properties;
        ModuleFactory moduleFactory = PropertyUtil.getMonitorLite();
        String string3 = moduleFactory.getJVMProperty(string);
        if (string3 == null && (properties = moduleFactory.getApplicationProperties()) != null) {
            string3 = properties.getProperty(string);
        }
        return string3 == null ? string2 : string3;
    }

    public static String getPropertyFromSet(Properties properties, String string) {
        String string2;
        boolean bl2;
        boolean bl3 = bl2 = properties != null ? PropertyUtil.isDBOnly(properties) : false;
        if ("derby.authentication.provider".equals(string) && PropertyUtil.nativeAuthenticationEnabled(string2 = PropertyUtil.getPropertyFromSet(true, properties, string))) {
            return string2;
        }
        return PropertyUtil.getPropertyFromSet(bl2, properties, string);
    }

    public static Serializable getPropertyFromSet(Dictionary dictionary, String string) {
        boolean bl2 = dictionary != null ? PropertyUtil.isDBOnly(dictionary) : false;
        return PropertyUtil.getPropertyFromSet(bl2, dictionary, string);
    }

    public static Serializable getPropertyFromSet(boolean bl2, Dictionary dictionary, String string) {
        if (dictionary != null) {
            Object object;
            if (!bl2 && (object = PropertyUtil.getMonitor().getJVMProperty(string)) != null) {
                return object;
            }
            object = (Serializable)dictionary.get(string);
            if (object != null) {
                return object;
            }
            if (bl2) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(string);
    }

    public static String getPropertyFromSet(boolean bl2, Properties properties, String string) {
        if (properties != null) {
            String string2;
            if (!bl2 && (string2 = PropertyUtil.getMonitor().getJVMProperty(string)) != null) {
                return string2;
            }
            string2 = properties.getProperty(string);
            if (string2 != null) {
                return string2;
            }
            if (bl2) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(string);
    }

    public static String getDatabaseProperty(PersistentSet persistentSet, String string) throws StandardException {
        if (persistentSet == null) {
            return null;
        }
        Serializable serializable = persistentSet.getProperty(string);
        if (serializable == null) {
            return null;
        }
        return serializable.toString();
    }

    public static String getServiceProperty(PersistentSet persistentSet, String string, String string2) throws StandardException {
        String string3 = PropertyUtil.getDatabaseProperty(persistentSet, "derby.database.propertiesOnly");
        boolean bl2 = Boolean.valueOf(string3 != null ? string3.trim() : string3);
        if (!bl2 && (string3 = PropertyUtil.getMonitor().getJVMProperty(string)) != null) {
            return string3;
        }
        string3 = PropertyUtil.getDatabaseProperty(persistentSet, string);
        if (string3 != null) {
            return string3;
        }
        if (bl2) {
            return string2;
        }
        return PropertyUtil.getSystemProperty(string, string2);
    }

    public static String getServiceProperty(PersistentSet persistentSet, String string) throws StandardException {
        return PropertyUtil.getServiceProperty(persistentSet, string, null);
    }

    public static boolean getSystemBoolean(String string) {
        return PropertyUtil.getSystemBoolean(string, false);
    }

    public static boolean getSystemBoolean(String string, boolean bl2) {
        String string2 = PropertyUtil.getSystemProperty(string);
        if (string2 == null) {
            return bl2;
        }
        return Boolean.valueOf(string2.trim());
    }

    public static boolean getServiceBoolean(PersistentSet persistentSet, String string, boolean bl2) throws StandardException {
        String string2 = PropertyUtil.getServiceProperty(persistentSet, string);
        return PropertyUtil.booleanProperty(string, (Serializable)((Object)string2), bl2);
    }

    public static int getSystemInt(String string, int n2, int n3, int n4) {
        return PropertyUtil.handleInt(PropertyUtil.getSystemProperty(string), n2, n3, n4);
    }

    public static int getServiceInt(PersistentSet persistentSet, String string, int n2, int n3, int n4) throws StandardException {
        return PropertyUtil.handleInt(PropertyUtil.getServiceProperty(persistentSet, string), n2, n3, n4);
    }

    public static int getServiceInt(PersistentSet persistentSet, Properties properties, String string, int n2, int n3, int n4) throws StandardException {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = PropertyUtil.getServiceProperty(persistentSet, string);
        }
        return PropertyUtil.handleInt(string2, n2, n3, n4);
    }

    public static int getSystemInt(String string, int n2) {
        return PropertyUtil.getSystemInt(string, 0, Integer.MAX_VALUE, n2);
    }

    public static int handleInt(String string, int n2, int n3, int n4) {
        if (string == null) {
            return n4;
        }
        try {
            int n5 = Integer.parseInt(string);
            if (n5 >= n2 && n5 <= n3) {
                return n5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n4;
    }

    public static boolean booleanProperty(String string, Serializable serializable, boolean bl2) throws StandardException {
        if (serializable == null) {
            return bl2;
        }
        String string2 = ((String)((Object)serializable)).trim();
        if ("TRUE".equals(StringUtil.SQLToUpperCase(string2))) {
            return true;
        }
        if ("FALSE".equals(StringUtil.SQLToUpperCase(string2))) {
            return false;
        }
        throw StandardException.newException("XCY00.S", string, string2);
    }

    public static int intPropertyValue(String string, Serializable serializable, int n2, int n3, int n4) throws StandardException {
        if (serializable == null) {
            return n4;
        }
        String string2 = ((String)((Object)serializable)).trim();
        try {
            int n5 = Integer.parseInt(string2);
            if (n5 < n2 || n5 > n3) {
                throw StandardException.newException("XCY00.S", string, string2);
            }
            return n5;
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("XCY00.S", string, string2);
        }
    }

    public static boolean isServiceProperty(String string) {
        for (int i2 = 0; i2 < servicePropertyList.length; ++i2) {
            if (!string.equals(servicePropertyList[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean existsBuiltinUser(PersistentSet persistentSet, String string) throws StandardException {
        if (PropertyUtil.propertiesContainsBuiltinUser(persistentSet.getProperties(), string)) {
            return true;
        }
        boolean bl2 = false;
        bl2 = Boolean.valueOf(PropertyUtil.getDatabaseProperty(persistentSet, "derby.database.propertiesOnly"));
        return !bl2 && PropertyUtil.systemPropertiesExistsBuiltinUser(string);
    }

    public static boolean nativeAuthenticationEnabled(Properties properties) {
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return PropertyUtil.nativeAuthenticationEnabled(string);
    }

    private static boolean nativeAuthenticationEnabled(String string) {
        if (string == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(string).startsWith("NATIVE:");
    }

    public static boolean localNativeAuthenticationEnabled(Properties properties) {
        if (!PropertyUtil.nativeAuthenticationEnabled(properties)) {
            return false;
        }
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return StringUtil.SQLToUpperCase(string).endsWith(":LOCAL");
    }

    private static boolean systemPropertiesExistsBuiltinUser(String string) {
        Properties properties;
        ModuleFactory moduleFactory;
        block3: {
            moduleFactory = PropertyUtil.getMonitorLite();
            try {
                properties = System.getProperties();
                if (PropertyUtil.propertiesContainsBuiltinUser(properties, string)) {
                    return true;
                }
            }
            catch (SecurityException securityException) {
                String string2 = "derby.user." + IdUtil.SQLIdentifier2CanonicalPropertyUsername(string);
                if (moduleFactory.getJVMProperty(string2) == null) break block3;
                return true;
            }
        }
        properties = moduleFactory.getApplicationProperties();
        return PropertyUtil.propertiesContainsBuiltinUser(properties, string);
    }

    private static boolean propertiesContainsBuiltinUser(Properties properties, String string) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (!string3.startsWith("derby.user.") || !string.equals(string2 = StringUtil.normalizeSQLIdentifier(string3.substring("derby.user.".length())))) continue;
                return true;
            }
        }
        return false;
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static ModuleFactory getMonitorLite() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitorLite();
            }
        });
    }
}

