/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.monitor;

import java.util.ArrayList;
import org.apache.derby.iapi.services.monitor.DerbyObserver;

public class DerbyObservable {
    private boolean _hasChanged = false;
    private ArrayList<DerbyObserver> _observers = new ArrayList();

    public synchronized void addObserver(DerbyObserver derbyObserver) {
        if (derbyObserver == null) {
            throw new IllegalArgumentException("Null arguments not allowed.");
        }
        if (!this._observers.contains(derbyObserver)) {
            this._observers.add(derbyObserver);
        }
    }

    public synchronized int countObservers() {
        return this._observers.size();
    }

    public synchronized void deleteObserver(DerbyObserver derbyObserver) {
        this._observers.remove(derbyObserver);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object) {
        int n2;
        DerbyObserver[] derbyObserverArray;
        DerbyObservable derbyObservable = this;
        synchronized (derbyObservable) {
            if (!this._hasChanged) {
                return;
            }
            derbyObserverArray = new DerbyObserver[this._observers.size()];
            this._observers.toArray(derbyObserverArray);
            this._hasChanged = false;
        }
        for (int i2 = n2 = derbyObserverArray.length - 1; i2 >= 0; --i2) {
            derbyObserverArray[i2].update(this, object);
        }
    }

    protected synchronized void setChanged() {
        this._hasChanged = true;
    }
}

