/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;

public class ClassInspector {
    private static final String[] primTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] nonPrimTypeNames = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private static final String OBJECT_TYPE_NAME = "java.lang.Object";
    private static final String STRING_TYPE_NAME = "java.lang.String";
    private static final String BIGDECIMAL_TYPE_NAME = "java.math.BigDecimal";
    private final ClassFactory cf;

    public ClassInspector(ClassFactory classFactory) {
        this.cf = classFactory;
    }

    public boolean instanceOf(String string, Object object) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public boolean assignableTo(String string, String string2) {
        try {
            Class<?> clazz = this.getClass(string2);
            if (clazz == null) {
                return false;
            }
            Class<?> clazz2 = this.getClass(string);
            if (clazz2 == null) {
                return !clazz.isPrimitive() || clazz == Void.TYPE;
            }
            return clazz.isAssignableFrom(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean accessible(String string) throws ClassNotFoundException {
        Class<?> clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public String getType(Member member) {
        Class<Object> clazz = member instanceof Method ? ((Method)member).getReturnType() : (member instanceof Field ? ((Field)member).getType() : (member instanceof Constructor ? ((Constructor)member).getDeclaringClass() : Void.TYPE));
        return ClassInspector.readableClassName(clazz);
    }

    public Member findPublicMethod(String string, String string2, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl2, boolean bl3, boolean bl4) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class<?> clazz;
        block13: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isPrimitive()) {
                return null;
            }
            if (stringArray == null) {
                Method[] methodArray = clazz.getMethods();
                for (int i2 = 0; i2 < methodArray.length; ++i2) {
                    if (bl2 && !Modifier.isStatic(methodArray[i2].getModifiers()) || bl4 && !this.isVarArgsMethod(methodArray[i2]) || !string2.equals(methodArray[i2].getName())) continue;
                    return methodArray[i2];
                }
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            for (int i3 = 0; i3 < classArray2.length; ++i3) {
                classArray2[i3] = this.getClass(stringArray[i3]);
                if (stringArray2 == null) continue;
                classArray[i3] = stringArray2[i3].equals(stringArray[i3]) ? null : this.getClass(stringArray2[i3]);
            }
            if (classArray2.length == 0) {
                try {
                    Method method = clazz.getMethod(string2, classArray2);
                    if (bl2 && !Modifier.isStatic(method.getModifiers())) {
                        return null;
                    }
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (clazz.isInterface()) break block13;
                    return null;
                }
            }
        }
        Member[] memberArray = clazz.getMethods();
        if (clazz.isInterface()) {
            Method[] methodArray = Object.class.getMethods();
            if (memberArray.length == 0) {
                memberArray = methodArray;
            } else {
                Member[] memberArray2 = new Member[memberArray.length + methodArray.length];
                System.arraycopy(memberArray, 0, memberArray2, 0, memberArray.length);
                System.arraycopy(methodArray, 0, memberArray2, memberArray.length, methodArray.length);
                memberArray = memberArray2;
            }
        }
        return this.resolveMethod(clazz, string2, classArray2, classArray, blArray, bl2, bl3, memberArray, bl4);
    }

    public Member findPublicField(String string, String string2, boolean bl2) throws StandardException {
        Exception exception;
        block9: {
            exception = null;
            try {
                Class<?> clazz = this.getClass(string);
                if (clazz == null) {
                    return null;
                }
                if (clazz.isArray() || clazz.isPrimitive()) {
                    return null;
                }
                int n2 = bl2 ? 9 : 1;
                Field field = clazz.getField(string2);
                if ((field.getModifiers() & n2) != n2) break block9;
                if (clazz.isInterface() || field.getDeclaringClass().equals(clazz)) {
                    return field;
                }
                try {
                    Field field2 = clazz.getDeclaredField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return field;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exception = noSuchFieldException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
        }
        throw StandardException.newException(bl2 ? "42X72" : "42X68", exception, string2, string);
    }

    public Member findPublicConstructor(String string, String[] stringArray, String[] stringArray2, boolean[] blArray) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class<?> clazz;
        block8: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray() || clazz.isPrimitive() || clazz.isInterface()) {
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            boolean bl2 = false;
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                classArray2[i2] = this.getClass(stringArray[i2]);
                if (classArray2[i2] == null) {
                    bl2 = true;
                }
                if (stringArray2 == null) continue;
                classArray[i2] = stringArray2[i2].equals(stringArray[i2]) ? null : this.getClass(stringArray2[i2]);
            }
            try {
                if (!bl2 && stringArray2 == null) {
                    Constructor<?> constructor = clazz.getConstructor(classArray2);
                    return constructor;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (classArray2.length != 0) break block8;
                return null;
            }
        }
        return this.resolveMethod(clazz, "<init>", classArray2, classArray, blArray, false, false, clazz.getConstructors(), false);
    }

    public Class[][] getTypeBounds(Class clazz, Class clazz2) throws StandardException {
        Type[] typeArray;
        if (clazz2 == null) {
            return null;
        }
        for (Type type : typeArray = clazz2.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type type2;
            if (!(type instanceof ParameterizedType) || clazz != (type2 = (parameterizedType = (ParameterizedType)type).getRawType())) continue;
            return this.findTypeBounds(parameterizedType);
        }
        return this.getTypeBounds(clazz, clazz2.getSuperclass());
    }

    public boolean isVarArgsMethod(Member member) {
        if (member instanceof Method) {
            return ((Method)member).isVarArgs();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).isVarArgs();
        }
        return false;
    }

    public Class<?>[] getGenericParameterTypes(Class clazz, Class clazz2) throws StandardException {
        ArrayList<Class<?>> arrayList = this.getTypeChain(clazz, clazz2);
        HashMap<Type, Type> hashMap = this.getResolvedTypes(arrayList);
        ArrayList<Class<?>> arrayList2 = this.getParameterTypes(clazz, hashMap);
        if (arrayList2 == null) {
            return null;
        }
        return arrayList2.toArray(new Class[arrayList2.size()]);
    }

    public String[] getParameterTypes(Member member) {
        Class<?>[] classArray = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = ClassInspector.readableClassName(classArray[i2]);
        }
        return stringArray;
    }

    public static boolean primitiveType(String string) {
        for (int i2 = 0; i2 < primTypeNames.length; ++i2) {
            if (!string.equals(primTypeNames[i2])) continue;
            return true;
        }
        return false;
    }

    private Member resolveMethod(Class clazz, String string, Class[] classArray, Class[] classArray2, boolean[] blArray, boolean bl2, boolean bl3, Member[] memberArray, boolean bl4) throws StandardException {
        boolean bl5;
        boolean bl6;
        int n2 = -1;
        boolean bl7 = true;
        do {
            bl6 = false;
            bl5 = false;
            block1: for (int i2 = 0; i2 < memberArray.length; ++i2) {
                Class[] classArray3;
                Member member = memberArray[i2];
                if (member == null || i2 == n2) continue;
                Class[] classArray4 = classArray3 = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
                if (bl7) {
                    if (bl3) {
                        if (classArray3.length < classArray.length) {
                            memberArray[i2] = null;
                            continue;
                        }
                    } else if (classArray3.length != classArray.length) {
                        memberArray[i2] = null;
                        continue;
                    }
                    if (bl2 && !Modifier.isStatic(member.getModifiers())) {
                        memberArray[i2] = null;
                        continue;
                    }
                    if (bl4 && !this.isVarArgsMethod(member)) {
                        memberArray[i2] = null;
                        continue;
                    }
                    if (!string.startsWith("<") && !string.equals(member.getName())) {
                        memberArray[i2] = null;
                        continue;
                    }
                    if (bl3) {
                        for (int i3 = classArray.length - 1; i3 < classArray3.length; ++i3) {
                            if (classArray3[i3].equals(classArray[classArray.length - 1])) continue;
                            memberArray[i2] = null;
                            continue block1;
                        }
                    }
                }
                if (!this.signatureConvertableFromTo(classArray, classArray2, classArray3, blArray, true)) {
                    memberArray[i2] = null;
                    continue;
                }
                if (n2 == -1) {
                    n2 = i2;
                    continue;
                }
                bl6 = true;
            }
            bl7 = false;
        } while (bl6 && bl5);
        if (bl6) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i4 = 0; i4 < classArray.length; ++i4) {
                if (i4 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(classArray[i4] == null ? "null" : classArray[i4].getName());
                if (classArray2 == null || classArray2[i4] == null) continue;
                stringBuffer.append("(").append(classArray2[i4].getName()).append(")");
            }
            throw StandardException.newException("42X73", clazz.getName(), string, stringBuffer.toString());
        }
        if (n2 == -1) {
            return null;
        }
        return memberArray[n2];
    }

    public Class<?> getClass(String string) throws ClassNotFoundException {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 - 2;
        while (n4 >= 0 && string.substring(n4, n4 + 2).equals("[]")) {
            ++n2;
            n4 -= 2;
            n3 -= 2;
        }
        if (n3 <= 0) {
            return Class.forName(string);
        }
        if (n2 != 0) {
            string = string.substring(0, n3);
        }
        Class<Object> clazz = null;
        if (n3 >= 3 && n3 <= 7) {
            if ("int".equals(string)) {
                clazz = Integer.TYPE;
            } else if ("short".equals(string)) {
                clazz = Short.TYPE;
            } else if ("boolean".equals(string)) {
                clazz = Boolean.TYPE;
            } else if ("byte".equals(string)) {
                clazz = Byte.TYPE;
            } else if ("float".equals(string)) {
                clazz = Float.TYPE;
            } else if ("double".equals(string)) {
                clazz = Double.TYPE;
            } else if ("long".equals(string)) {
                clazz = Long.TYPE;
            } else if ("char".equals(string)) {
                clazz = Character.TYPE;
            } else if ("void".equals(string)) {
                clazz = Void.TYPE;
            }
        }
        if (clazz == null) {
            clazz = this.cf.loadApplicationClass(string);
        }
        if (n2 == 0) {
            return clazz;
        }
        if (n2 == 1) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return Array.newInstance(clazz, new int[n2]).getClass();
    }

    private boolean signatureConvertableFromTo(Class[] classArray, Class[] classArray2, Class[] classArray3, boolean[] blArray, boolean bl2) {
        int n2 = classArray.length;
        if (classArray3.length < n2) {
            n2 = classArray3.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz = classArray[i2];
            Class clazz2 = classArray3[i2];
            if (!(clazz == null ? clazz2.isPrimitive() && (classArray2 == null || blArray != null && !blArray[i2]) : !this.classConvertableFromTo(clazz, clazz2, bl2) && (classArray2 == null || classArray2[i2] == null || !this.classConvertableFromTo(classArray2[i2], clazz2, bl2)))) continue;
            return false;
        }
        return true;
    }

    protected boolean classConvertableFromTo(Class clazz, Class clazz2, boolean bl2) {
        if (clazz.getName().equals(clazz2.getName())) {
            return true;
        }
        if (clazz.isArray() && clazz2.isArray()) {
            return this.classConvertableFromTo(clazz.getComponentType(), clazz2.getComponentType(), bl2);
        }
        if (!(clazz2.isPrimitive() && clazz.isPrimitive() || bl2)) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        return clazz == Boolean.TYPE || string.equals(nonPrimTypeNames[0]) ? clazz2 == Boolean.TYPE || string2.equals(nonPrimTypeNames[0]) : (clazz == Byte.TYPE || string.equals(nonPrimTypeNames[1]) ? clazz2 == Byte.TYPE || string2.equals(nonPrimTypeNames[1]) || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Character.TYPE || string.equals(nonPrimTypeNames[2]) ? clazz2 == Character.TYPE || string2.equals(nonPrimTypeNames[2]) || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Short.TYPE || string.equals(nonPrimTypeNames[3]) ? clazz2 == Short.TYPE || string2.equals(nonPrimTypeNames[4]) : (clazz == Integer.TYPE || string.equals(nonPrimTypeNames[4]) ? clazz2 == Integer.TYPE || string2.equals(nonPrimTypeNames[4]) : (clazz == Long.TYPE || string.equals(nonPrimTypeNames[5]) ? clazz2 == Long.TYPE || string2.equals(nonPrimTypeNames[5]) : (clazz == Float.TYPE || string.equals(nonPrimTypeNames[6]) ? clazz2 == Float.TYPE || string2.equals(nonPrimTypeNames[6]) : !(clazz != Double.TYPE && !string.equals(nonPrimTypeNames[7]) || clazz2 != Double.TYPE && !string2.equals(nonPrimTypeNames[7]))))))));
    }

    public static String readableClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n2 = 0;
        do {
            ++n2;
        } while ((clazz = clazz.getComponentType()).isArray());
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public String getDeclaringClass(Member member) {
        return member.getDeclaringClass().getName();
    }

    private Class[][] findTypeBounds(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n2 = typeArray.length;
        Class[][] classArray = new Class[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = this.boundType(typeArray[i2]);
        }
        return classArray;
    }

    private Class[] boundType(Type type) {
        if (type instanceof Class) {
            return new Class[]{(Class)type};
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)type).getBounds();
            int n2 = typeArray.length;
            Class[] classArray = new Class[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                classArray[i2] = this.getRawType(typeArray[i2]);
            }
            return classArray;
        }
        return null;
    }

    private Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getRawType(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    private ArrayList<Class<?>> getTypeChain(Class<?> clazz, Class<?> clazz2) {
        ArrayList arrayList = null;
        if (clazz2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            return null;
        }
        if (clazz2 == clazz) {
            arrayList = new ArrayList();
        }
        if (arrayList == null && (arrayList = this.getTypeChain(clazz, clazz2.getSuperclass())) == null) {
            Class<?> clazz3;
            Class<?>[] classArray = clazz2.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2 && (arrayList = this.getTypeChain(clazz, clazz3 = classArray[i2])) == null; ++i2) {
            }
        }
        if (arrayList != null) {
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    private HashMap<Type, Type> getResolvedTypes(ArrayList<Class<?>> arrayList) {
        if (arrayList == null) {
            return null;
        }
        HashMap<Type, Type> hashMap = new HashMap<Type, Type>();
        for (Class<?> clazz : arrayList) {
            this.addResolvedTypes(hashMap, clazz.getGenericSuperclass());
            for (Type type : clazz.getGenericInterfaces()) {
                this.addResolvedTypes(hashMap, type);
            }
        }
        return hashMap;
    }

    private void addResolvedTypes(HashMap<Type, Type> hashMap, Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                hashMap.put(typeVariableArray[i2], typeArray[i2]);
            }
        }
    }

    private ArrayList<Class<?>> getParameterTypes(Class<?> clazz, HashMap<Type, Type> hashMap) {
        if (hashMap == null) {
            return null;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        ArrayList arrayList = new ArrayList();
        for (Type type : typeVariableArray) {
            while (hashMap.containsKey(type)) {
                type = hashMap.get(type);
            }
            arrayList.add(this.getRawType(type));
        }
        return arrayList;
    }
}

