/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamUtil {
    private static final int SKIP_FRAGMENT_SIZE = Integer.MAX_VALUE;

    public static int readUnsignedByte(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        do {
            if ((n4 = inputStream.read(byArray, n2, n3)) < 0) {
                throw new EOFException();
            }
            n2 += n4;
        } while ((n3 -= n4) != 0);
    }

    public static int readLoop(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n2;
        while ((n4 = inputStream.read(byArray, n2, n3)) > 0) {
            n2 += n4;
            if ((n3 -= n4) != 0) continue;
        }
        return n2 - n5;
    }

    public static long skipUntilEOF(InputStream inputStream) throws IOException {
        long l2;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        long l3 = 0L;
        do {
            l2 = InputStreamUtil.skipPersistent(inputStream, Integer.MAX_VALUE);
            l3 += l2;
        } while (l2 >= Integer.MAX_VALUE);
        return l3;
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (l2 <= 0L) {
            return;
        }
        long l3 = InputStreamUtil.skipPersistent(inputStream, l2);
        if (l3 < l2) {
            throw new EOFException();
        }
    }

    public static final long skipPersistent(InputStream inputStream, long l2) throws IOException {
        long l3;
        long l4;
        for (l3 = 0L; l3 < l2; l3 += l4) {
            l4 = inputStream.skip(l2 - l3);
            if (l4 != 0L) continue;
            if (inputStream.read() == -1) break;
            l4 = 1L;
        }
        return l3;
    }
}

