/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public final class ErrorMessages
extends VTITemplate
implements PrivilegedAction<InputStream>,
VTICosting {
    private Properties p;
    private Enumeration keys;
    private String k;
    private String SQLState;
    private String message;
    private int severity;
    private int msgFile;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SQL_STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MESSAGE", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("SEVERITY", 4, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public ErrorMessages() throws IOException {
        this.loadProperties();
    }

    @Override
    public boolean next() {
        boolean bl2 = true;
        if (!this.keys.hasMoreElements()) {
            this.close();
            bl2 = false;
            return bl2;
        }
        this.k = (String)this.keys.nextElement();
        if (this.notAnException()) {
            bl2 = this.next();
        }
        if (bl2) {
            this.SQLState = StandardException.getSQLStateFromIdentifier(this.k);
            this.message = MessageService.getTextMessage(this.k, new Object[0]);
            this.message = StringUtil.truncate(this.message, 32672);
        }
        return bl2;
    }

    @Override
    public void close() {
        this.p = null;
        this.k = null;
        this.keys = null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public String getString(int n2) throws SQLException {
        switch (n2) {
            case 1: {
                return this.SQLState;
            }
            case 2: {
                return this.message;
            }
        }
        return super.getString(n2);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        switch (n2) {
            case 3: {
                return this.severity;
            }
        }
        return super.getInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        this.p = new Properties();
        for (int i2 = 0; i2 < 50; ++i2) {
            this.msgFile = i2;
            InputStream inputStream = AccessController.doPrivileged(this);
            if (inputStream == null) continue;
            try {
                this.p.load(inputStream);
                continue;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.keys = this.p.keys();
    }

    private boolean notAnException() {
        if (this.k.length() < 5) {
            return true;
        }
        int n2 = StandardException.getSeverityFromIdentifier(this.k);
        if (n2 < 1) {
            return true;
        }
        this.severity = n2;
        return false;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) {
        return 1000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) {
        return 5000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) {
        return true;
    }

    @Override
    public final InputStream run() {
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/loc/m" + this.msgFile + "_en.properties");
        this.msgFile = 0;
        return inputStream;
    }
}

