/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.RowMultiSetImpl;
import org.apache.derby.iapi.services.io.Formatable;

public class TypeDescriptorImpl
implements TypeDescriptor,
Formatable {
    private BaseTypeIdImpl typeId;
    private int precision;
    private int scale;
    private boolean isNullable;
    private int maximumWidth;
    private int collationType = 0;

    public TypeDescriptorImpl() {
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, int n2, int n3, boolean bl2, int n4) {
        this.typeId = baseTypeIdImpl;
        this.precision = n2;
        this.scale = n3;
        this.isNullable = bl2;
        this.maximumWidth = n4;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, int n2, int n3, boolean bl2, int n4, int n5) {
        this.typeId = baseTypeIdImpl;
        this.precision = n2;
        this.scale = n3;
        this.isNullable = bl2;
        this.maximumWidth = n4;
        this.collationType = n5;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, boolean bl2, int n2) {
        this.typeId = baseTypeIdImpl;
        this.isNullable = bl2;
        this.maximumWidth = n2;
        this.scale = 0;
        this.precision = 0;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, int n2, int n3, boolean bl2, int n4) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = n2;
        this.scale = n3;
        this.isNullable = bl2;
        this.maximumWidth = n4;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, int n2, int n3, boolean bl2, int n4, int n5) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = n2;
        this.scale = n3;
        this.isNullable = bl2;
        this.maximumWidth = n4;
        this.collationType = n5;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, boolean bl2, int n2) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = typeDescriptorImpl.precision;
        this.scale = typeDescriptorImpl.scale;
        this.isNullable = bl2;
        this.maximumWidth = n2;
    }

    public static TypeDescriptor[] copyTypeDescriptors(TypeDescriptor[] typeDescriptorArray) {
        return typeDescriptorArray == null ? null : (TypeDescriptor[])typeDescriptorArray.clone();
    }

    @Override
    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    @Override
    public int getMaximumWidthInBytes() {
        switch (this.typeId.getJDBCTypeId()) {
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 2004: {
                return this.maximumWidth;
            }
            case -5: {
                return 40;
            }
            case 91: 
            case 92: {
                return 6;
            }
            case 93: {
                return 16;
            }
            case 2: 
            case 3: {
                return 2 * (this.precision + 2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (this.maximumWidth > 0 && 2 * this.maximumWidth < 0) {
                    return Integer.MAX_VALUE;
                }
                return 2 * this.maximumWidth;
            }
            case 16: {
                return 1;
            }
        }
        return -1;
    }

    public boolean isStringType() {
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getJDBCTypeId() {
        return this.typeId.getJDBCTypeId();
    }

    @Override
    public String getTypeName() {
        return this.typeId.getSQLTypeName();
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isRowMultiSet() {
        return this.typeId instanceof RowMultiSetImpl;
    }

    @Override
    public boolean isUserDefinedType() {
        return this.typeId.userType();
    }

    @Override
    public int getCollationType() {
        return this.collationType;
    }

    public void setCollationType(int n2) {
        this.collationType = n2;
    }

    @Override
    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public String toString() {
        String string = this.getSQLstring();
        if (!this.isNullable()) {
            return string + " NOT NULL";
        }
        return string;
    }

    public BaseTypeIdImpl getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object object) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)object;
        if (!this.getTypeName().equals(typeDescriptor.getTypeName()) || this.precision != typeDescriptor.getPrecision() || this.scale != typeDescriptor.getScale() || this.isNullable != typeDescriptor.isNullable() || this.maximumWidth != typeDescriptor.getMaximumWidth()) {
            return false;
        }
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return this.collationType == typeDescriptor.getCollationType();
            }
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.typeId = (BaseTypeIdImpl)objectInput.readObject();
        this.precision = objectInput.readInt();
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.scale = 0;
                this.collationType = objectInput.readInt();
                break;
            }
            default: {
                this.scale = objectInput.readInt();
                this.collationType = 0;
            }
        }
        this.isNullable = objectInput.readBoolean();
        this.maximumWidth = objectInput.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.typeId);
        objectOutput.writeInt(this.precision);
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                objectOutput.writeInt(this.collationType);
                break;
            }
            default: {
                objectOutput.writeInt(this.scale);
            }
        }
        objectOutput.writeBoolean(this.isNullable);
        objectOutput.writeInt(this.maximumWidth);
    }

    @Override
    public int getTypeFormatId() {
        return 14;
    }

    @Override
    public String[] getRowColumnNames() {
        if (!this.isRowMultiSet()) {
            return null;
        }
        return ((RowMultiSetImpl)this.typeId).getColumnNames();
    }

    @Override
    public TypeDescriptor[] getRowTypes() {
        if (!this.isRowMultiSet()) {
            return null;
        }
        return ((RowMultiSetImpl)this.typeId).getTypes();
    }
}

