/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Statistics;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;

public class StatisticsImpl
implements Statistics,
Formatable {
    private long numRows;
    private long numUnique;

    public StatisticsImpl(long l2, long l3) {
        this.numRows = l2;
        this.numUnique = l3;
    }

    public StatisticsImpl() {
    }

    @Override
    public long getRowEstimate() {
        return this.numRows;
    }

    @Override
    public double selectivity(Object[] objectArray) {
        if ((double)this.numRows == 0.0) {
            return 0.1;
        }
        return 1.0 / (double)this.numUnique;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.numRows = formatableHashtable.getLong("numRows");
        this.numUnique = formatableHashtable.getLong("numUnique");
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.putLong("numRows", this.numRows);
        formatableHashtable.putLong("numUnique", this.numUnique);
        objectOutput.writeObject(formatableHashtable);
    }

    @Override
    public int getTypeFormatId() {
        return 397;
    }

    public String toString() {
        return "numunique= " + this.numUnique + " numrows= " + this.numRows;
    }
}

