/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.iapi.services.io.ArrayUtil;

public class RowMultiSetImpl
extends BaseTypeIdImpl {
    private String[] _columnNames;
    private TypeDescriptor[] _types;

    public RowMultiSetImpl() {
    }

    public RowMultiSetImpl(String[] stringArray, TypeDescriptor[] typeDescriptorArray) {
        this._columnNames = ArrayUtil.copy(stringArray);
        this.setTypes(typeDescriptorArray);
        if (stringArray == null || typeDescriptorArray == null || stringArray.length != typeDescriptorArray.length) {
            throw new IllegalArgumentException("Bad args: columnNames = " + stringArray + ". types = " + typeDescriptorArray);
        }
    }

    public String[] getColumnNames() {
        return ArrayUtil.copy(this._columnNames);
    }

    public TypeDescriptor[] getTypes() {
        return TypeDescriptorImpl.copyTypeDescriptors(this._types);
    }

    public void setTypes(TypeDescriptor[] typeDescriptorArray) {
        this._types = TypeDescriptorImpl.copyTypeDescriptors(typeDescriptorArray);
    }

    @Override
    public String getSQLTypeName() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this._columnNames.length;
        stringBuffer.append("TABLE ( ");
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('\"');
            stringBuffer.append(this._columnNames[i2]);
            stringBuffer.append('\"');
            stringBuffer.append(' ');
            stringBuffer.append(this._types[i2].getSQLstring());
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    @Override
    public int getJDBCTypeId() {
        return 1111;
    }

    @Override
    public int getTypeFormatId() {
        return 469;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        int n3 = objectInput.readInt();
        this._columnNames = new String[n3];
        this._types = new TypeDescriptor[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this._columnNames[n2] = objectInput.readUTF();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this._types[n2] = (TypeDescriptor)objectInput.readObject();
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n2;
        int n3 = this._columnNames.length;
        objectOutput.writeInt(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            objectOutput.writeUTF(this._columnNames[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            objectOutput.writeObject(this._types[n2]);
        }
    }
}

