/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    private int[] referencedColumns;
    private int[] referencedColumnsInTriggerAction;

    public ReferencedColumnsDescriptorImpl(int[] nArray) {
        this.referencedColumns = ArrayUtil.copy(nArray);
    }

    public ReferencedColumnsDescriptorImpl(int[] nArray, int[] nArray2) {
        this.referencedColumns = ArrayUtil.copy(nArray);
        this.referencedColumnsInTriggerAction = ArrayUtil.copy(nArray2);
    }

    public ReferencedColumnsDescriptorImpl() {
    }

    @Override
    public int[] getReferencedColumnPositions() {
        return ArrayUtil.copy(this.referencedColumns);
    }

    @Override
    public int[] getTriggerActionReferencedColumnPositions() {
        return ArrayUtil.copy(this.referencedColumnsInTriggerAction);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n2;
        int n3;
        int n4 = objectInput.readInt();
        if (n4 < 0) {
            n3 = objectInput.readInt();
            if (n3 < 0) {
                n3 = 0;
            } else {
                this.referencedColumns = new int[n3];
            }
        } else {
            n3 = n4;
            this.referencedColumns = new int[n3];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.referencedColumns[n2] = objectInput.readInt();
        }
        if (n4 < 0) {
            n2 = objectInput.readInt();
            this.referencedColumnsInTriggerAction = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.referencedColumnsInTriggerAction[i2] = objectInput.readInt();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n2;
        int n3 = n2 = this.referencedColumnsInTriggerAction == null ? this.referencedColumns.length : -1;
        if (n2 < 0) {
            objectOutput.writeInt(n2);
            if (this.referencedColumns != null) {
                this.writeReferencedColumns(objectOutput);
            } else {
                objectOutput.writeInt(n2);
            }
            objectOutput.writeInt(this.referencedColumnsInTriggerAction.length);
            for (int i2 = 0; i2 < this.referencedColumnsInTriggerAction.length; ++i2) {
                objectOutput.writeInt(this.referencedColumnsInTriggerAction[i2]);
            }
        } else {
            this.writeReferencedColumns(objectOutput);
        }
    }

    private void writeReferencedColumns(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.referencedColumns.length);
        for (int i2 = 0; i2 < this.referencedColumns.length; ++i2) {
            objectOutput.writeInt(this.referencedColumns[i2]);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        if (this.referencedColumns == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.referencedColumns.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(String.valueOf(this.referencedColumns[i2]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

