/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;

public class IndexDescriptorImpl
implements IndexDescriptor,
Formatable {
    private boolean isUnique;
    private int[] baseColumnPositions;
    private boolean[] isAscending;
    private int numberOfOrderedColumns;
    private String indexType;
    private boolean isUniqueWithDuplicateNulls;
    private boolean isUniqueDeferrable;
    private boolean hasDeferrableChecking;

    public IndexDescriptorImpl(String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int[] nArray, boolean[] blArray, int n2) {
        this.indexType = string;
        this.isUnique = bl2;
        this.isUniqueWithDuplicateNulls = bl3;
        this.isUniqueDeferrable = bl4;
        this.hasDeferrableChecking = bl5;
        this.baseColumnPositions = ArrayUtil.copy(nArray);
        this.isAscending = ArrayUtil.copy(blArray);
        this.numberOfOrderedColumns = n2;
    }

    public IndexDescriptorImpl() {
    }

    @Override
    public boolean isUniqueWithDuplicateNulls() {
        return this.isUniqueWithDuplicateNulls;
    }

    @Override
    public boolean hasDeferrableChecking() {
        return this.hasDeferrableChecking;
    }

    @Override
    public boolean isUniqueDeferrable() {
        return this.isUniqueDeferrable;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public int[] baseColumnPositions() {
        return ArrayUtil.copy(this.baseColumnPositions);
    }

    @Override
    public int getKeyColumnPosition(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.baseColumnPositions.length; ++i2) {
            if (this.baseColumnPositions[i2] != n2) continue;
            n3 = i2 + 1;
            break;
        }
        return n3;
    }

    @Override
    public int numberOfOrderedColumns() {
        return this.numberOfOrderedColumns;
    }

    @Override
    public String indexType() {
        return this.indexType;
    }

    @Override
    public boolean isAscending(Integer n2) {
        int n3 = n2 - 1;
        if (n3 < 0 || n3 >= this.baseColumnPositions.length) {
            return false;
        }
        return this.isAscending[n3];
    }

    @Override
    public boolean isDescending(Integer n2) {
        int n3 = n2 - 1;
        if (n3 < 0 || n3 >= this.baseColumnPositions.length) {
            return false;
        }
        return !this.isAscending[n3];
    }

    @Override
    public boolean[] isAscending() {
        return ArrayUtil.copy(this.isAscending);
    }

    @Override
    public void setBaseColumnPositions(int[] nArray) {
        this.baseColumnPositions = ArrayUtil.copy(nArray);
    }

    @Override
    public void setIsAscending(boolean[] blArray) {
        this.isAscending = ArrayUtil.copy(blArray);
    }

    @Override
    public void setNumberOfOrderedColumns(int n2) {
        this.numberOfOrderedColumns = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        if (this.isUnique || this.isUniqueDeferrable) {
            stringBuilder.append("UNIQUE ");
        } else if (this.isUniqueWithDuplicateNulls) {
            stringBuilder.append("UNIQUE WITH DUPLICATE NULLS ");
        }
        if (this.hasDeferrableChecking) {
            stringBuilder.append(" DEFERRABLE CHECKING ");
        }
        stringBuilder.append(this.indexType);
        stringBuilder.append(" (");
        for (int i2 = 0; i2 < this.baseColumnPositions.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.baseColumnPositions[i2]);
            if (this.isAscending[i2]) continue;
            stringBuilder.append(" DESC");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.isUnique = formatableHashtable.getBoolean("isUnique");
        int n2 = formatableHashtable.getInt("keyLength");
        this.baseColumnPositions = new int[n2];
        this.isAscending = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.baseColumnPositions[i2] = formatableHashtable.getInt("bcp" + i2);
            this.isAscending[i2] = formatableHashtable.getBoolean("isAsc" + i2);
        }
        this.numberOfOrderedColumns = formatableHashtable.getInt("orderedColumns");
        this.indexType = (String)formatableHashtable.get("indexType");
        this.isUniqueWithDuplicateNulls = formatableHashtable.containsKey("isUniqueWithDuplicateNulls") ? formatableHashtable.getBoolean("isUniqueWithDuplicateNulls") : false;
        this.hasDeferrableChecking = formatableHashtable.containsKey("hasDeferrableChecking") ? formatableHashtable.getBoolean("hasDeferrableChecking") : false;
        this.isUniqueDeferrable = formatableHashtable.containsKey("isUniqueDeferrable") ? formatableHashtable.getBoolean("isUniqueDeferrable") : false;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.putBoolean("isUnique", this.isUnique);
        formatableHashtable.putInt("keyLength", this.baseColumnPositions.length);
        for (int i2 = 0; i2 < this.baseColumnPositions.length; ++i2) {
            formatableHashtable.putInt("bcp" + i2, this.baseColumnPositions[i2]);
            formatableHashtable.putBoolean("isAsc" + i2, this.isAscending[i2]);
        }
        formatableHashtable.putInt("orderedColumns", this.numberOfOrderedColumns);
        formatableHashtable.put("indexType", this.indexType);
        formatableHashtable.putBoolean("isUniqueWithDuplicateNulls", this.isUniqueWithDuplicateNulls);
        formatableHashtable.putBoolean("hasDeferrableChecking", this.hasDeferrableChecking);
        formatableHashtable.putBoolean("isUniqueDeferrable", this.isUniqueDeferrable);
        objectOutput.writeObject(formatableHashtable);
    }

    @Override
    public int getTypeFormatId() {
        return 387;
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object instanceof IndexDescriptorImpl) {
            IndexDescriptorImpl indexDescriptorImpl = (IndexDescriptorImpl)object;
            if (indexDescriptorImpl.isUnique == this.isUnique && indexDescriptorImpl.isUniqueWithDuplicateNulls == this.isUniqueWithDuplicateNulls && indexDescriptorImpl.baseColumnPositions.length == this.baseColumnPositions.length && indexDescriptorImpl.numberOfOrderedColumns == this.numberOfOrderedColumns && indexDescriptorImpl.indexType.equals(this.indexType)) {
                bl2 = true;
                for (int i2 = 0; i2 < this.baseColumnPositions.length; ++i2) {
                    if (indexDescriptorImpl.baseColumnPositions[i2] == this.baseColumnPositions[i2] && indexDescriptorImpl.isAscending[i2] == this.isAscending[i2]) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        return bl2;
    }

    public int hashCode() {
        int n2 = this.isUnique ? 1 : 2;
        n2 *= this.numberOfOrderedColumns;
        for (int i2 = 0; i2 < this.baseColumnPositions.length; ++i2) {
            n2 *= this.baseColumnPositions[i2];
        }
        return n2 *= this.indexType.hashCode();
    }
}

