/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.core._UnexpectedTypeErrorExplainerTemplateModel;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListModel
extends SimpleSequence
implements _UnexpectedTypeErrorExplainerTemplateModel,
TemplateHashModel {
    NodeModel contextNode;
    XPathSupport xpathSupport;
    private static ObjectWrapper nodeWrapper = new ObjectWrapper(){

        public TemplateModel wrap(Object obj) {
            if (obj instanceof NodeModel) {
                return (NodeModel)obj;
            }
            return NodeModel.wrap((Node)obj);
        }
    };
    static /* synthetic */ Class class$freemarker$template$TemplateScalarModel;
    static /* synthetic */ Class class$freemarker$template$TemplateDateModel;
    static /* synthetic */ Class class$freemarker$template$TemplateNumberModel;
    static /* synthetic */ Class class$freemarker$template$TemplateBooleanModel;
    static /* synthetic */ Class class$freemarker$template$TemplateNodeModel;

    NodeListModel(Node node) {
        this(NodeModel.wrap(node));
    }

    NodeListModel(NodeModel contextNode) {
        super(nodeWrapper);
        this.contextNode = contextNode;
    }

    NodeListModel(NodeList nodeList, NodeModel contextNode) {
        super(nodeWrapper);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            this.list.add(nodeList.item(i2));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(NamedNodeMap nodeList, NodeModel contextNode) {
        super(nodeWrapper);
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            this.list.add(nodeList.item(i2));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(List list, NodeModel contextNode) {
        super(list, nodeWrapper);
        this.contextNode = contextNode;
    }

    NodeListModel filterByName(String name) throws TemplateModelException {
        NodeListModel result = new NodeListModel(this.contextNode);
        int size = this.size();
        if (size == 0) {
            return result;
        }
        Environment env = Environment.getCurrentEnvironment();
        for (int i2 = 0; i2 < size; ++i2) {
            NodeModel nm = (NodeModel)this.get(i2);
            if (!(nm instanceof ElementModel) || !((ElementModel)nm).matchesName(name, env)) continue;
            result.add(nm);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (this.size() == 1) {
            NodeModel nm = (NodeModel)this.get(0);
            return nm.get(key);
        }
        if (key.startsWith("@@") && (key.equals("@@markup") || key.equals("@@nested_markup") || key.equals("@@text"))) {
            StringBuffer result = new StringBuffer();
            for (int i2 = 0; i2 < this.size(); ++i2) {
                NodeModel nm = (NodeModel)this.get(i2);
                TemplateScalarModel textModel = (TemplateScalarModel)nm.get(key);
                result.append(textModel.getAsString());
            }
            return new SimpleScalar(result.toString());
        }
        if (StringUtil.isXMLID(key) || key.startsWith("@") && StringUtil.isXMLID(key.substring(1)) || key.equals("*") || key.equals("**") || key.equals("@@") || key.equals("@*")) {
            NodeListModel result = new NodeListModel(this.contextNode);
            for (int i3 = 0; i3 < this.size(); ++i3) {
                TemplateSequenceModel tsm;
                NodeModel nm = (NodeModel)this.get(i3);
                if (!(nm instanceof ElementModel) || (tsm = (TemplateSequenceModel)((ElementModel)nm).get(key)) == null) continue;
                int size = tsm.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    result.add(tsm.get(j2));
                }
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
        XPathSupport xps = this.getXPathSupport();
        if (xps != null) {
            List context = this.size() == 0 ? null : this.rawNodeList();
            return xps.executeQuery(context, key);
        }
        throw new TemplateModelException("Key: '" + key + "' is not legal for a node sequence (" + this.getClass().getName() + "). This node sequence contains " + this.size() + " node(s). " + "Some keys are valid only for node sequences of size 1. " + "If you use Xalan (instead of Jaxen), XPath expression keys work only with " + "node lists of size 1.");
    }

    private List rawNodeList() throws TemplateModelException {
        int size = this.size();
        ArrayList<Node> al2 = new ArrayList<Node>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            al2.add(((NodeModel)this.get((int)i2)).node);
        }
        return al2;
    }

    XPathSupport getXPathSupport() throws TemplateModelException {
        if (this.xpathSupport == null) {
            if (this.contextNode != null) {
                this.xpathSupport = this.contextNode.getXPathSupport();
            } else if (this.size() > 0) {
                this.xpathSupport = ((NodeModel)this.get(0)).getXPathSupport();
            }
        }
        return this.xpathSupport;
    }

    public Object[] explainTypeError(Class[] expectedClasses) {
        for (int i2 = 0; i2 < expectedClasses.length; ++i2) {
            Class expectedClass;
            if ((class$freemarker$template$TemplateScalarModel == null ? NodeListModel.class$("freemarker.template.TemplateScalarModel") : class$freemarker$template$TemplateScalarModel).isAssignableFrom(expectedClass = expectedClasses[i2]) || (class$freemarker$template$TemplateDateModel == null ? NodeListModel.class$("freemarker.template.TemplateDateModel") : class$freemarker$template$TemplateDateModel).isAssignableFrom(expectedClass) || (class$freemarker$template$TemplateNumberModel == null ? NodeListModel.class$("freemarker.template.TemplateNumberModel") : class$freemarker$template$TemplateNumberModel).isAssignableFrom(expectedClass) || (class$freemarker$template$TemplateBooleanModel == null ? NodeListModel.class$("freemarker.template.TemplateBooleanModel") : class$freemarker$template$TemplateBooleanModel).isAssignableFrom(expectedClass)) {
                return this.newTypeErrorExplanation("string");
            }
            if (!(class$freemarker$template$TemplateNodeModel == null ? NodeListModel.class$("freemarker.template.TemplateNodeModel") : class$freemarker$template$TemplateNodeModel).isAssignableFrom(expectedClass)) continue;
            return this.newTypeErrorExplanation("node");
        }
        return null;
    }

    private Object[] newTypeErrorExplanation(String type) {
        return new Object[]{"This XML query result can't be used as ", type, " because for that it had to contain exactly 1 XML node, but it contains ", new Integer(this.size()), " nodes. That is, the constructing XML query has found ", this.isEmpty() ? "no matches." : "multiple matches."};
    }
}

