/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassIntrospector;
import freemarker.template.utility.ClassUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

class UnsafeMethods {
    private static final Set UNSAFE_METHODS = UnsafeMethods.createUnsafeMethodsSet();

    private UnsafeMethods() {
    }

    static boolean isUnsafeMethod(Method method) {
        return UNSAFE_METHODS.contains(method);
    }

    private static final Set createUnsafeMethodsSet() {
        Properties props = new Properties();
        InputStream in = BeansWrapper.class.getResourceAsStream("unsafeMethods.txt");
        if (in != null) {
            String methodSpec = null;
            try {
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
                HashSet<Method> set = new HashSet<Method>(props.size() * 4 / 3, 1.0f);
                Map primClasses = UnsafeMethods.createPrimitiveClassesMap();
                Iterator<Object> iterator = props.keySet().iterator();
                while (iterator.hasNext()) {
                    methodSpec = (String)iterator.next();
                    try {
                        set.add(UnsafeMethods.parseMethodSpec(methodSpec, primClasses));
                    }
                    catch (ClassNotFoundException e2) {
                        if (!ClassIntrospector.DEVELOPMENT_MODE) continue;
                        throw e2;
                    }
                    catch (NoSuchMethodException e3) {
                        if (!ClassIntrospector.DEVELOPMENT_MODE) continue;
                        throw e3;
                    }
                }
                return set;
            }
            catch (Exception e4) {
                throw new RuntimeException("Could not load unsafe method " + methodSpec + " " + e4.getClass().getName() + " " + e4.getMessage());
            }
        }
        return Collections.EMPTY_SET;
    }

    private static Method parseMethodSpec(String methodSpec, Map primClasses) throws ClassNotFoundException, NoSuchMethodException {
        int brace = methodSpec.indexOf(40);
        int dot = methodSpec.lastIndexOf(46, brace);
        Class clazz = ClassUtil.forName(methodSpec.substring(0, dot));
        String methodName = methodSpec.substring(dot + 1, brace);
        String argSpec = methodSpec.substring(brace + 1, methodSpec.length() - 1);
        StringTokenizer tok = new StringTokenizer(argSpec, ",");
        int argcount = tok.countTokens();
        Class[] argTypes = new Class[argcount];
        for (int i2 = 0; i2 < argcount; ++i2) {
            String argClassName = tok.nextToken();
            argTypes[i2] = (Class)primClasses.get(argClassName);
            if (argTypes[i2] != null) continue;
            argTypes[i2] = ClassUtil.forName(argClassName);
        }
        return clazz.getMethod(methodName, argTypes);
    }

    private static Map createPrimitiveClassesMap() {
        HashMap<String, Class<Comparable<Boolean>>> map = new HashMap<String, Class<Comparable<Boolean>>>();
        map.put("boolean", Boolean.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("char", Character.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        return map;
    }
}

