/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core._UnexpectedTypeErrorExplainerTemplateModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.SimpleMethod;
import freemarker.ext.beans._MethodUtil;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.ClassUtil;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public final class SimpleMethodModel
extends SimpleMethod
implements _UnexpectedTypeErrorExplainerTemplateModel,
TemplateMethodModelEx,
TemplateSequenceModel {
    private final Object object;
    private final BeansWrapper wrapper;

    SimpleMethodModel(Object object, Method method, Class[] argTypes, BeansWrapper wrapper) {
        super(method, argTypes);
        this.object = object;
        this.wrapper = wrapper;
    }

    public Object exec(List arguments) throws TemplateModelException {
        try {
            return this.wrapper.invokeMethod(this.object, (Method)this.getMember(), this.unwrapArguments(arguments, this.wrapper));
        }
        catch (TemplateModelException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw _MethodUtil.newInvocationTemplateModelException(this.object, this.getMember(), (Throwable)e3);
        }
    }

    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.exec(Collections.singletonList(new SimpleNumber(new Integer(index))));
    }

    public int size() throws TemplateModelException {
        throw new TemplateModelException("Getting the number of items or enumerating the items is not supported on this " + ClassUtil.getFTLTypeDescription(this) + " value.\n" + "(" + "Hint 1: Maybe you wanted to call this method first and then do something with its return value. " + "Hint 2: Getting items by intex possibly works, hence it's a \"+sequence\"." + ")");
    }

    public String toString() {
        return this.getMember().toString();
    }

    public Object[] explainTypeError(Class[] expectedClasses) {
        Member member = this.getMember();
        if (!(member instanceof Method)) {
            return null;
        }
        Method m2 = (Method)member;
        Class<?> returnType = m2.getReturnType();
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            return null;
        }
        String mName = m2.getName();
        if (mName.startsWith("get") && mName.length() > 3 && Character.isUpperCase(mName.charAt(3)) && m2.getParameterTypes().length == 0) {
            return new Object[]{"Maybe using obj.something instead of obj.getSomething will yield the desired value."};
        }
        if (mName.startsWith("is") && mName.length() > 2 && Character.isUpperCase(mName.charAt(2)) && m2.getParameterTypes().length == 0) {
            return new Object[]{"Maybe using obj.something instead of obj.isSomething will yield the desired value."};
        }
        return new Object[]{"Maybe using obj.something(", m2.getParameterTypes().length != 0 ? "params" : "", ") instead of obj.something will yield the desired value"};
    }
}

