/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ParseException;
import freemarker.core._ObjectBuilderSettingEvaluationException;
import freemarker.core._SettingEvaluationEnvironment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.SimpleObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.WriteProtectable;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class _ObjectBuilderSettingEvaluator {
    private static final String INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILDER_CLASS_POSTFIX = "Builder";
    private static Map SHORTHANDS;
    private final String src;
    private final Class expectedClass;
    private final _SettingEvaluationEnvironment env;
    private int pos;
    private boolean v2321Mode = false;

    private _ObjectBuilderSettingEvaluator(String src, int pos, Class expectedClass, _SettingEvaluationEnvironment env) {
        this.src = src;
        this.pos = pos;
        this.expectedClass = expectedClass;
        this.env = env;
    }

    public static Object eval(String src, Class expectedClass, _SettingEvaluationEnvironment env) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new _ObjectBuilderSettingEvaluator(src, 0, expectedClass, env).eval();
    }

    public static int configureBean(String argumentListSrc, int posAfterOpenParen, Object bean, _SettingEvaluationEnvironment env) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new _ObjectBuilderSettingEvaluator(argumentListSrc, posAfterOpenParen, bean.getClass(), env).configureBean(bean);
    }

    private Object eval() throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.execute(this.parse());
    }

    private int configureBean(Object bean) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        PropertyAssignmentsExpression propAssignments = new PropertyAssignmentsExpression(bean);
        this.fetchParameterListInto(propAssignments);
        this.skipWS();
        propAssignments.eval();
        return this.pos;
    }

    private BuilderExpression parse() throws _ObjectBuilderSettingEvaluationException {
        this.skipWS();
        BuilderExpression exp = this.fetchBuilderCall(true, false);
        this.skipWS();
        if (this.pos != this.src.length()) {
            throw new _ObjectBuilderSettingEvaluationException("end-of-expression", this.src, this.pos);
        }
        return exp;
    }

    private Object execute(BuilderExpression exp) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!this.v2321Mode) {
            return ClassUtil.forName(exp.className).newInstance();
        }
        return exp.eval();
    }

    private Object eval(Object value) throws _ObjectBuilderSettingEvaluationException {
        return value instanceof SettingExpression ? ((SettingExpression)value).eval() : value;
    }

    private BuilderExpression fetchBuilderCall(boolean topLevel, boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        BuilderExpression exp = new BuilderExpression();
        String fetchedClassName = this.fetchClassName(optional);
        if (fetchedClassName == null) {
            return null;
        }
        exp.className = _ObjectBuilderSettingEvaluator.shorthandToFullQualified(fetchedClassName);
        if (!fetchedClassName.equals(exp.className)) {
            this.v2321Mode = true;
        }
        this.skipWS();
        char openParen = this.fetchOptionalChar("(");
        if (openParen == '\u0000' && !topLevel) {
            if (!optional) {
                throw new _ObjectBuilderSettingEvaluationException("(", this.src, this.pos);
            }
            this.pos = startPos;
            return null;
        }
        if (openParen != '\u0000') {
            this.fetchParameterListInto(exp);
        }
        return exp;
    }

    private void fetchParameterListInto(ExpressionWithParameters exp) throws _ObjectBuilderSettingEvaluationException {
        this.v2321Mode = true;
        this.skipWS();
        if (this.fetchOptionalChar(")") != ')') {
            do {
                this.skipWS();
                Object paramNameOrValue = this.fetchValueOrName(false);
                if (paramNameOrValue == null) continue;
                this.skipWS();
                if (paramNameOrValue instanceof ParameterName) {
                    exp.namedParamNames.add(((ParameterName)paramNameOrValue).name);
                    this.skipWS();
                    this.fetchRequiredChar("=");
                    this.skipWS();
                    int paramValPos = this.pos;
                    Object paramValue = this.fetchValueOrName(false);
                    if (paramValue instanceof ParameterName) {
                        throw new _ObjectBuilderSettingEvaluationException("concrete value", this.src, paramValPos);
                    }
                    exp.namedParamValues.add(this.eval(paramValue));
                } else {
                    if (!exp.namedParamNames.isEmpty()) {
                        throw new _ObjectBuilderSettingEvaluationException("Positional parameters must precede named parameters");
                    }
                    if (!exp.getAllowPositionalParameters()) {
                        throw new _ObjectBuilderSettingEvaluationException("Positional parameters not supported here");
                    }
                    exp.positionalParamValues.add(this.eval(paramNameOrValue));
                }
                this.skipWS();
            } while (this.fetchRequiredChar(",)") == ',');
        }
    }

    private Object fetchValueOrName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        if (this.pos < this.src.length()) {
            Object val = this.fetchNumberLike(true);
            if (val != null) {
                return val;
            }
            val = this.fetchStringLiteral(true);
            if (val != null) {
                return val;
            }
            val = this.fetchBuilderCall(false, true);
            if (val != null) {
                return val;
            }
            String name = this.fetchSimpleName(true);
            if (name != null) {
                if (name.equals("true")) {
                    return Boolean.TRUE;
                }
                if (name.equals("false")) {
                    return Boolean.FALSE;
                }
                if (name.equals("null")) {
                    return NullExpression.INSTANCE;
                }
                return new ParameterName(name);
            }
        }
        if (optional) {
            return null;
        }
        throw new _ObjectBuilderSettingEvaluationException("value or name", this.src, this.pos);
    }

    private String fetchSimpleName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        char c2;
        char c3 = c2 = this.pos < this.src.length() ? this.src.charAt(this.pos) : (char)'\u0000';
        if (!this.isIdentifierStart(c2)) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("class name", this.src, this.pos);
        }
        int startPos = this.pos++;
        while (this.pos != this.src.length() && this.isIdentifierMiddle(c2 = this.src.charAt(this.pos))) {
            ++this.pos;
        }
        return this.src.substring(startPos, this.pos);
    }

    private String fetchClassName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        StringBuffer sb = new StringBuffer();
        while (true) {
            String name;
            if ((name = this.fetchSimpleName(true)) == null) {
                if (!optional) {
                    throw new _ObjectBuilderSettingEvaluationException("name", this.src, this.pos);
                }
                this.pos = startPos;
                return null;
            }
            sb.append(name);
            this.skipWS();
            if (this.pos >= this.src.length() || this.src.charAt(this.pos) != '.') break;
            sb.append('.');
            ++this.pos;
            this.skipWS();
        }
        return sb.toString();
    }

    private Object fetchNumberLike(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        boolean isVersion = false;
        boolean hasDot = false;
        while (this.pos != this.src.length()) {
            char c2 = this.src.charAt(this.pos);
            if (c2 == '.') {
                if (hasDot) {
                    isVersion = true;
                } else {
                    hasDot = true;
                }
            } else if (!this.isASCIIDigit(c2) && c2 != '-') break;
            ++this.pos;
        }
        if (startPos == this.pos) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("number-like", this.src, this.pos);
        }
        String tk = this.src.substring(startPos, this.pos);
        if (isVersion) {
            try {
                return new Version(tk);
            }
            catch (IllegalArgumentException e2) {
                throw new _ObjectBuilderSettingEvaluationException("Malformed version number: " + tk, e2);
            }
        }
        try {
            if (tk.endsWith(".")) {
                throw new NumberFormatException("A number can't end with a dot");
            }
            if (tk.startsWith(".") || tk.startsWith("-.") || tk.startsWith("+.")) {
                throw new NumberFormatException("A number can't start with a dot");
            }
            return new BigDecimal(tk);
        }
        catch (NumberFormatException e3) {
            throw new _ObjectBuilderSettingEvaluationException("Malformed number: " + tk, e3);
        }
    }

    private Object fetchStringLiteral(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        int q2 = 0;
        boolean afterEscape = false;
        boolean raw = false;
        while (true) {
            if (this.pos == this.src.length()) {
                if (q2 == 0) break;
                throw new _ObjectBuilderSettingEvaluationException(String.valueOf((char)q2), this.src, this.pos);
            }
            int c2 = this.src.charAt(this.pos);
            if (q2 == 0) {
                if (c2 == 114 && this.pos + 1 < this.src.length()) {
                    raw = true;
                    c2 = this.src.charAt(this.pos + 1);
                }
                if (c2 == 39) {
                    q2 = 39;
                } else {
                    if (c2 != 34) break;
                    q2 = 34;
                }
                if (raw) {
                    ++this.pos;
                }
            } else if (!afterEscape) {
                if (c2 == 92 && !raw) {
                    afterEscape = true;
                } else {
                    char prevC;
                    if (c2 == q2) break;
                    if (c2 == 123 && ((prevC = this.src.charAt(this.pos - 1)) == '$' || prevC == '#')) {
                        throw new _ObjectBuilderSettingEvaluationException("${...} and #{...} aren't allowed here.");
                    }
                }
            } else {
                afterEscape = false;
            }
            ++this.pos;
        }
        if (startPos == this.pos) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("string literal", this.src, this.pos);
        }
        String sInside = this.src.substring(startPos + (raw ? 2 : 1), this.pos);
        try {
            ++this.pos;
            return raw ? sInside : StringUtil.FTLStringLiteralDec(sInside);
        }
        catch (ParseException e2) {
            throw new _ObjectBuilderSettingEvaluationException("Malformed string literal: " + sInside, e2);
        }
    }

    private void skipWS() {
        while (this.pos != this.src.length()) {
            char c2 = this.src.charAt(this.pos);
            if (!Character.isWhitespace(c2)) {
                return;
            }
            ++this.pos;
        }
        return;
    }

    private char fetchOptionalChar(String expectedChars) throws _ObjectBuilderSettingEvaluationException {
        return this.fetchChar(expectedChars, true);
    }

    private char fetchRequiredChar(String expectedChars) throws _ObjectBuilderSettingEvaluationException {
        return this.fetchChar(expectedChars, false);
    }

    private char fetchChar(String expectedChars, boolean optional) throws _ObjectBuilderSettingEvaluationException {
        char c2;
        char c3 = c2 = this.pos < this.src.length() ? this.src.charAt(this.pos) : (char)'\u0000';
        if (expectedChars.indexOf(c2) != -1) {
            ++this.pos;
            return c2;
        }
        if (optional) {
            return '\u0000';
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < expectedChars.length(); ++i2) {
            if (i2 != 0) {
                sb.append(" or ");
            }
            sb.append(StringUtil.jQuote(expectedChars.substring(i2, i2 + 1)));
        }
        if (optional) {
            sb.append(" or end-of-string");
        }
        throw new _ObjectBuilderSettingEvaluationException(sb.toString(), this.src, this.pos);
    }

    private boolean isASCIIDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private boolean isIdentifierStart(char c2) {
        return Character.isLetter(c2) || c2 == '_' || c2 == '$';
    }

    private boolean isIdentifierMiddle(char c2) {
        return this.isIdentifierStart(c2) || this.isASCIIDigit(c2);
    }

    private static synchronized String shorthandToFullQualified(String className) {
        String fullClassName;
        if (SHORTHANDS == null) {
            SHORTHANDS = new HashMap();
            SHORTHANDS.put("DefaultObjectWrapper", DefaultObjectWrapper.class.getName());
            SHORTHANDS.put("BeansWrapper", BeansWrapper.class.getName());
            SHORTHANDS.put("SimpleObjectWrapper", SimpleObjectWrapper.class.getName());
        }
        return (fullClassName = (String)SHORTHANDS.get(className)) == null ? className : fullClassName;
    }

    private void setJavaBeanProperties(Object bean, List namedParamNames, List namedParamValues) throws _ObjectBuilderSettingEvaluationException {
        int i2;
        HashMap<String, Method> beanPropSetters;
        if (namedParamNames.isEmpty()) {
            return;
        }
        Class<?> cl = bean.getClass();
        try {
            PropertyDescriptor[] propDescs = Introspector.getBeanInfo(cl).getPropertyDescriptors();
            beanPropSetters = new HashMap<String, Method>(propDescs.length * 4 / 3, 1.0f);
            for (i2 = 0; i2 < propDescs.length; ++i2) {
                PropertyDescriptor propDesc = propDescs[i2];
                Method writeMethod = propDesc.getWriteMethod();
                if (writeMethod == null) continue;
                beanPropSetters.put(propDesc.getName(), writeMethod);
            }
        }
        catch (Exception e2) {
            throw new _ObjectBuilderSettingEvaluationException("Failed to inspect " + cl.getName() + " class", e2);
        }
        TemplateHashModel beanTM = null;
        for (i2 = 0; i2 < namedParamNames.size(); ++i2) {
            String name = (String)namedParamNames.get(i2);
            if (!beanPropSetters.containsKey(name)) {
                throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " class has no writeable JavaBeans property called " + StringUtil.jQuote(name) + ".");
            }
            Method beanPropSetter = beanPropSetters.put(name, null);
            if (beanPropSetter == null) {
                throw new _ObjectBuilderSettingEvaluationException("JavaBeans property " + StringUtil.jQuote(name) + " is set twice.");
            }
            try {
                TemplateModel m2;
                if (beanTM == null) {
                    TemplateModel wrappedObj = this.env.getObjectWrapper().wrap(bean);
                    if (!(wrappedObj instanceof TemplateHashModel)) {
                        throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " class is not a wrapped as TemplateHashModel.");
                    }
                    beanTM = (TemplateHashModel)wrappedObj;
                }
                if ((m2 = beanTM.get(beanPropSetter.getName())) == null) {
                    throw new _ObjectBuilderSettingEvaluationException("Can't find " + beanPropSetter + " as FreeMarker method.");
                }
                if (!(m2 instanceof TemplateMethodModelEx)) {
                    throw new _ObjectBuilderSettingEvaluationException(StringUtil.jQuote(beanPropSetter.getName()) + " wasn't a TemplateMethodModelEx.");
                }
                ArrayList<TemplateModel> args = new ArrayList<TemplateModel>();
                args.add(this.env.getObjectWrapper().wrap(namedParamValues.get(i2)));
                ((TemplateMethodModelEx)m2).exec(args);
                continue;
            }
            catch (Exception e3) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to set " + StringUtil.jQuote(name), e3);
            }
        }
    }

    private static class NullExpression
    extends SettingExpression {
        static final NullExpression INSTANCE = new NullExpression();

        private NullExpression() {
        }

        Object eval() throws _ObjectBuilderSettingEvaluationException {
            return null;
        }
    }

    private class PropertyAssignmentsExpression
    extends ExpressionWithParameters {
        private final Object bean;

        public PropertyAssignmentsExpression(Object bean) {
            this.bean = bean;
        }

        Object eval() throws _ObjectBuilderSettingEvaluationException {
            _ObjectBuilderSettingEvaluator.this.setJavaBeanProperties(this.bean, this.namedParamNames, this.namedParamValues);
            return this.bean;
        }

        protected boolean getAllowPositionalParameters() {
            return false;
        }
    }

    private class BuilderExpression
    extends ExpressionWithParameters {
        private String className;

        private BuilderExpression() {
        }

        Object eval() throws _ObjectBuilderSettingEvaluationException {
            Object result;
            boolean clIsBuilderClass;
            Class cl;
            try {
                cl = ClassUtil.forName(this.className);
            }
            catch (Exception e2) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get class " + StringUtil.jQuote(this.className) + ".", e2);
            }
            try {
                cl = ClassUtil.forName(cl.getName() + _ObjectBuilderSettingEvaluator.BUILDER_CLASS_POSTFIX);
                clIsBuilderClass = true;
            }
            catch (ClassNotFoundException e3) {
                clIsBuilderClass = false;
            }
            if (!clIsBuilderClass && this.hasNoParameters()) {
                try {
                    Field f2 = cl.getField(_ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME);
                    if ((f2.getModifiers() & 9) == 9) {
                        return f2.get(null);
                    }
                }
                catch (NoSuchFieldException e4) {
                }
                catch (Exception e5) {
                    throw new _ObjectBuilderSettingEvaluationException("Error when trying to access " + StringUtil.jQuote(this.className) + "." + _ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME, e5);
                }
            }
            Object constructorResult = this.callConstructor(cl);
            _ObjectBuilderSettingEvaluator.this.setJavaBeanProperties(constructorResult, this.namedParamNames, this.namedParamValues);
            if (clIsBuilderClass) {
                result = this.callBuild(constructorResult);
            } else {
                if (constructorResult instanceof WriteProtectable) {
                    ((WriteProtectable)constructorResult).writeProtect();
                }
                result = constructorResult;
            }
            if (!_ObjectBuilderSettingEvaluator.this.expectedClass.isInstance(result)) {
                throw new _ObjectBuilderSettingEvaluationException("The resulting object (of class " + result.getClass() + ") is not a(n) " + _ObjectBuilderSettingEvaluator.this.expectedClass.getName() + ".");
            }
            return result;
        }

        private Object callConstructor(Class cl) throws _ObjectBuilderSettingEvaluationException {
            if (this.hasNoParameters()) {
                try {
                    return cl.newInstance();
                }
                catch (Exception e2) {
                    throw new _ObjectBuilderSettingEvaluationException("Failed to call " + cl.getName() + " 0-argument constructor", e2);
                }
            }
            BeansWrapper ow = _ObjectBuilderSettingEvaluator.this.env.getObjectWrapper();
            ArrayList<TemplateModel> tmArgs = new ArrayList<TemplateModel>(this.positionalParamValues.size());
            for (int i2 = 0; i2 < this.positionalParamValues.size(); ++i2) {
                try {
                    tmArgs.add(ow.wrap(this.positionalParamValues.get(i2)));
                    continue;
                }
                catch (TemplateModelException e3) {
                    throw new _ObjectBuilderSettingEvaluationException("Failed to wrap arg #" + (i2 + 1), e3);
                }
            }
            try {
                return ow.newInstance(cl, tmArgs);
            }
            catch (Exception e4) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to call " + cl.getName() + " constructor", e4);
            }
        }

        private Object callBuild(Object constructorResult) throws _ObjectBuilderSettingEvaluationException {
            Method buildMethod;
            Class<?> cl = constructorResult.getClass();
            try {
                buildMethod = constructorResult.getClass().getMethod(_ObjectBuilderSettingEvaluator.BUILD_METHOD_NAME, null);
            }
            catch (NoSuchMethodException e2) {
                throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " builder class must have a public " + _ObjectBuilderSettingEvaluator.BUILD_METHOD_NAME + "() method", e2);
            }
            catch (Exception e3) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get the build() method of the " + cl.getName() + " builder class", e3);
            }
            try {
                return buildMethod.invoke(constructorResult, (Object[])null);
            }
            catch (Exception e4) {
                Throwable cause = e4 instanceof InvocationTargetException ? ((InvocationTargetException)e4).getTargetException() : e4;
                throw new _ObjectBuilderSettingEvaluationException("Failed to call build() method on " + cl.getName() + " instance", cause);
            }
        }

        private boolean hasNoParameters() {
            return this.positionalParamValues.isEmpty() && this.namedParamValues.isEmpty();
        }

        protected boolean getAllowPositionalParameters() {
            return true;
        }
    }

    private abstract class ExpressionWithParameters
    extends SettingExpression {
        protected List positionalParamValues;
        protected List namedParamNames;
        protected List namedParamValues;

        private ExpressionWithParameters() {
            this.positionalParamValues = new ArrayList();
            this.namedParamNames = new ArrayList();
            this.namedParamValues = new ArrayList();
        }

        protected abstract boolean getAllowPositionalParameters();
    }

    private static abstract class SettingExpression {
        private SettingExpression() {
        }

        abstract Object eval() throws _ObjectBuilderSettingEvaluationException;
    }

    private static class ParameterName {
        private final String name;

        public ParameterName(String name) {
            this.name = name;
        }
    }
}

