/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.NestedContentNotSupportedException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplatePostProcessorException;
import freemarker.core.ThreadInterruptionSupportTemplatePostProcessor;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class _CoreAPI {
    public static final String ERROR_MESSAGE_HR = "----";
    public static final Set BUILT_IN_DIRECTIVE_NAMES;

    private _CoreAPI() {
    }

    public static Set getSupportedBuiltInNames() {
        return Collections.unmodifiableSet(BuiltIn.builtins.keySet());
    }

    public static void appendInstructionStackItem(TemplateElement stackEl, StringBuffer sb) {
        Environment.appendInstructionStackItem(stackEl, sb);
    }

    public static TemplateElement[] getInstructionStackSnapshot(Environment env) {
        return env.getInstructionStackSnapshot();
    }

    public static void outputInstructionStack(TemplateElement[] instructionStackSnapshot, boolean terseMode, Writer pw) {
        Environment.outputInstructionStack(instructionStackSnapshot, terseMode, pw);
    }

    public static Set getConfigurableSettingNames(Configurable cfgable, boolean camelCase) {
        return cfgable.getSettingNames(camelCase);
    }

    public static final void addThreadInterruptedChecks(Template template) {
        try {
            new ThreadInterruptionSupportTemplatePostProcessor().postProcess(template);
        }
        catch (TemplatePostProcessorException e2) {
            throw new RuntimeException("Template post-processing failed", e2);
        }
    }

    public static final void checkHasNoNestedContent(TemplateDirectiveBody body) throws NestedContentNotSupportedException {
        NestedContentNotSupportedException.check(body);
    }

    static {
        TreeSet<String> names = new TreeSet<String>();
        names.add("assign");
        names.add("attempt");
        names.add("break");
        names.add("call");
        names.add("case");
        names.add("comment");
        names.add("compress");
        names.add("default");
        names.add("else");
        names.add("elseif");
        names.add("elseIf");
        names.add("escape");
        names.add("fallback");
        names.add("flush");
        names.add("foreach");
        names.add("forEach");
        names.add("ftl");
        names.add("function");
        names.add("global");
        names.add("if");
        names.add("import");
        names.add("include");
        names.add("items");
        names.add("list");
        names.add("local");
        names.add("lt");
        names.add("macro");
        names.add("nested");
        names.add("noescape");
        names.add("noEscape");
        names.add("noparse");
        names.add("noParse");
        names.add("nt");
        names.add("recover");
        names.add("recurse");
        names.add("return");
        names.add("rt");
        names.add("sep");
        names.add("setting");
        names.add("stop");
        names.add("switch");
        names.add("t");
        names.add("transform");
        names.add("visit");
        BUILT_IN_DIRECTIVE_NAMES = Collections.unmodifiableSet(names);
    }
}

