/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BugException;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.UndeclaredThrowableException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class _ConcurrentMapFactory {
    private static final Class concurrentMapClass;
    private static final Class bestHashMapClass;
    private static final Constructor bestHashMapClassConstructor;
    private static final int bestHashMapClassConstructorParamCnt;

    public static Map newMaybeConcurrentHashMap() {
        try {
            return (Map)bestHashMapClass.newInstance();
        }
        catch (Exception e2) {
            throw new UndeclaredThrowableException(e2);
        }
    }

    public static Map newMaybeConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        try {
            if (bestHashMapClassConstructorParamCnt == 3) {
                return (Map)bestHashMapClassConstructor.newInstance(new Integer(initialCapacity), new Float(loadFactor), new Integer(concurrencyLevel));
            }
            if (bestHashMapClassConstructorParamCnt == 2) {
                return (Map)bestHashMapClassConstructor.newInstance(new Integer(initialCapacity), new Float(loadFactor));
            }
            throw new BugException();
        }
        catch (Exception e2) {
            throw new UndeclaredThrowableException(e2);
        }
    }

    public static Map newThreadSafeMap() {
        Map map = _ConcurrentMapFactory.newMaybeConcurrentHashMap();
        return _ConcurrentMapFactory.isConcurrent(map) ? map : Collections.synchronizedMap(map);
    }

    public static boolean concurrentMapsAvailable() {
        return concurrentMapClass != null;
    }

    public static boolean isConcurrent(Map map) {
        return concurrentMapClass != null && concurrentMapClass.isInstance(map);
    }

    static {
        int constrParamCnt;
        Constructor constr;
        Class c2;
        try {
            c2 = ClassUtil.forName("java.util.concurrent.ConcurrentMap");
        }
        catch (ClassNotFoundException e2) {
            c2 = null;
        }
        concurrentMapClass = c2;
        try {
            c2 = ClassUtil.forName("java.util.concurrent.ConcurrentHashMap");
            try {
                constr = c2.getConstructor(Integer.TYPE, Float.TYPE, Integer.TYPE);
                constrParamCnt = 3;
            }
            catch (Exception e3) {
                throw new RuntimeException("Failed to get ConcurrentHashMap constructor", e3);
            }
        }
        catch (ClassNotFoundException e4) {
            c2 = HashMap.class;
            try {
                constr = c2.getConstructor(Integer.TYPE, Float.TYPE);
                constrParamCnt = 2;
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to get HashMap constructor", e2);
            }
        }
        bestHashMapClass = c2;
        bestHashMapClassConstructor = constr;
        bestHashMapClassConstructorParamCnt = constrParamCnt;
    }
}

