/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BugException;
import freemarker.core.Environment;
import freemarker.core.MixedContent;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplatePostProcessor;
import freemarker.core.TemplatePostProcessorException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

class ThreadInterruptionSupportTemplatePostProcessor
extends TemplatePostProcessor {
    ThreadInterruptionSupportTemplatePostProcessor() {
    }

    public void postProcess(Template t2) throws TemplatePostProcessorException {
        TemplateElement te = t2.getRootTreeNode();
        this.addInterruptionChecks(te);
    }

    private void addInterruptionChecks(TemplateElement te) throws TemplatePostProcessorException {
        if (te == null) {
            return;
        }
        TemplateElement nestedBlock = te.getNestedBlock();
        if (nestedBlock != null) {
            this.addInterruptionChecks(nestedBlock);
        }
        int regulatedChildrenCount = te.getRegulatedChildCount();
        for (int i2 = 0; i2 < regulatedChildrenCount; ++i2) {
            this.addInterruptionChecks(te.getRegulatedChild(i2));
        }
        if (te.isNestedBlockRepeater()) {
            if (regulatedChildrenCount != 0) {
                throw new BugException();
            }
            try {
                ThreadInterruptionCheck interruptedChk = new ThreadInterruptionCheck(te);
                if (nestedBlock == null) {
                    te.setNestedBlock(interruptedChk);
                } else {
                    MixedContent nestedMixedC;
                    if (nestedBlock instanceof MixedContent) {
                        nestedMixedC = (MixedContent)nestedBlock;
                    } else {
                        nestedMixedC = new MixedContent();
                        nestedMixedC.setLocation(te.getTemplate(), 0, 0, 0, 0);
                        nestedMixedC.addElement(nestedBlock);
                        te.setNestedBlock(nestedMixedC);
                    }
                    nestedMixedC.addElement(0, interruptedChk);
                }
            }
            catch (ParseException e2) {
                throw new TemplatePostProcessorException("Unexpected error; see cause", e2);
            }
        }
    }

    static class TemplateProcessingThreadInterruptedException
    extends RuntimeException {
        TemplateProcessingThreadInterruptedException() {
            super("Template processing thread \"interrupted\" flag was set.");
        }
    }

    static class ThreadInterruptionCheck
    extends TemplateElement {
        private ThreadInterruptionCheck(TemplateElement te) throws ParseException {
            this.setLocation(te.getTemplate(), te.beginColumn, te.beginLine, te.beginColumn, te.beginLine);
        }

        void accept(Environment env) throws TemplateException, IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new TemplateProcessingThreadInterruptedException();
            }
        }

        protected String dump(boolean canonical) {
            return canonical ? "" : "<#--" + this.getNodeTypeSymbol() + "--#>";
        }

        String getNodeTypeSymbol() {
            return "##threadInterruptionCheck";
        }

        int getParameterCount() {
            return 0;
        }

        Object getParameterValue(int idx) {
            throw new IndexOutOfBoundsException();
        }

        ParameterRole getParameterRole(int idx) {
            throw new IndexOutOfBoundsException();
        }

        boolean isNestedBlockRepeater() {
            return false;
        }
    }
}

