/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BlockAssignment;
import freemarker.core.Environment;
import freemarker.core.Macro;
import freemarker.core.MixedContent;
import freemarker.core.ParseException;
import freemarker.core.TemplateObject;
import freemarker.core._ArrayEnumeration;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public abstract class TemplateElement
extends TemplateObject
implements TreeNode {
    private static final int INITIAL_REGULATED_CHILD_BUFFER_CAPACITY = 6;
    private TemplateElement parent;
    private TemplateElement nestedBlock;
    private TemplateElement[] regulatedChildBuffer;
    private int regulatedChildCount;
    private int index;

    abstract void accept(Environment var1) throws TemplateException, IOException;

    public final String getDescription() {
        return this.dump(false);
    }

    public final String getCanonicalForm() {
        return this.dump(true);
    }

    boolean isShownInStackTrace() {
        return true;
    }

    abstract boolean isNestedBlockRepeater();

    protected abstract String dump(boolean var1);

    public TemplateNodeModel getParentNode() {
        return null;
    }

    public String getNodeNamespace() {
        return null;
    }

    public String getNodeType() {
        return "element";
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.regulatedChildBuffer != null) {
            SimpleSequence seq = new SimpleSequence(this.regulatedChildCount);
            for (int i2 = 0; i2 < this.regulatedChildCount; ++i2) {
                seq.add(this.regulatedChildBuffer[i2]);
            }
            return seq;
        }
        SimpleSequence result = new SimpleSequence(1);
        if (this.nestedBlock != null) {
            result.add(this.nestedBlock);
        }
        return result;
    }

    public String getNodeName() {
        String classname = this.getClass().getName();
        int shortNameOffset = classname.lastIndexOf(46) + 1;
        return classname.substring(shortNameOffset);
    }

    public boolean isLeaf() {
        return this.nestedBlock == null && this.regulatedChildCount == 0;
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public int getIndex(TreeNode node) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getIndex(node);
        }
        if (this.nestedBlock != null) {
            if (node == this.nestedBlock) {
                return 0;
            }
        } else {
            for (int i2 = 0; i2 < this.regulatedChildCount; ++i2) {
                if (!this.regulatedChildBuffer[i2].equals(node)) continue;
                return i2;
            }
        }
        return -1;
    }

    public int getChildCount() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildCount();
        }
        if (this.nestedBlock != null) {
            return 1;
        }
        return this.regulatedChildCount;
    }

    public Enumeration children() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.children();
        }
        if (this.nestedBlock != null) {
            return Collections.enumeration(Collections.singletonList(this.nestedBlock));
        }
        if (this.regulatedChildBuffer != null) {
            return new _ArrayEnumeration(this.regulatedChildBuffer, this.regulatedChildCount);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public TreeNode getChildAt(int index) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildAt(index);
        }
        if (this.nestedBlock != null) {
            if (index == 0) {
                return this.nestedBlock;
            }
            throw new ArrayIndexOutOfBoundsException("invalid index");
        }
        if (this.regulatedChildCount != 0) {
            try {
                return this.regulatedChildBuffer[index];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.regulatedChildCount);
            }
        }
        throw new ArrayIndexOutOfBoundsException("Template element has no children");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChildAt(int index, TemplateElement element) {
        if (this.nestedBlock instanceof MixedContent) {
            this.nestedBlock.setChildAt(index, element);
            return;
        } else if (this.nestedBlock != null) {
            if (index != 0) throw new IndexOutOfBoundsException("invalid index");
            this.nestedBlock = element;
            element.index = 0;
            element.parent = this;
            return;
        } else {
            if (this.regulatedChildBuffer == null) throw new IndexOutOfBoundsException("element has no children");
            this.regulatedChildBuffer[index] = element;
            element.index = index;
            element.parent = this;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    final void setRegulatedChildBufferCapacity(int capacity) {
        int ln = this.regulatedChildCount;
        TemplateElement[] newRegulatedChildBuffer = new TemplateElement[capacity];
        for (int i2 = 0; i2 < ln; ++i2) {
            newRegulatedChildBuffer[i2] = this.regulatedChildBuffer[i2];
        }
        this.regulatedChildBuffer = newRegulatedChildBuffer;
    }

    final void addRegulatedChild(TemplateElement nestedElement) {
        this.addRegulatedChild(this.regulatedChildCount, nestedElement);
    }

    final void addRegulatedChild(int index, TemplateElement nestedElement) {
        int lRegulatedChildCount = this.regulatedChildCount;
        TemplateElement[] lRegulatedChildBuffer = this.regulatedChildBuffer;
        if (lRegulatedChildBuffer == null) {
            this.regulatedChildBuffer = lRegulatedChildBuffer = new TemplateElement[6];
        } else if (lRegulatedChildCount == lRegulatedChildBuffer.length) {
            this.setRegulatedChildBufferCapacity(lRegulatedChildCount != 0 ? lRegulatedChildCount * 2 : 1);
            lRegulatedChildBuffer = this.regulatedChildBuffer;
        }
        for (int i2 = lRegulatedChildCount; i2 > index; --i2) {
            TemplateElement movedElement = lRegulatedChildBuffer[i2 - 1];
            movedElement.index = i2;
            lRegulatedChildBuffer[i2] = movedElement;
        }
        nestedElement.index = index;
        nestedElement.parent = this;
        lRegulatedChildBuffer[index] = nestedElement;
        this.regulatedChildCount = lRegulatedChildCount + 1;
    }

    final int getRegulatedChildCount() {
        return this.regulatedChildCount;
    }

    final TemplateElement getRegulatedChild(int index) {
        return this.regulatedChildBuffer[index];
    }

    final int getIndex() {
        return this.index;
    }

    final TemplateElement getParentElement() {
        return this.parent;
    }

    final TemplateElement getNestedBlock() {
        return this.nestedBlock;
    }

    final void setNestedBlock(TemplateElement nestedBlock) {
        if (nestedBlock != null) {
            nestedBlock.parent = this;
            nestedBlock.index = 0;
        }
        this.nestedBlock = nestedBlock;
    }

    final void setFieldsForRootElement() {
        this.index = 0;
        this.parent = null;
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        int regulatedChildCount = this.regulatedChildCount;
        if (regulatedChildCount != 0) {
            TemplateElement te;
            int i2 = 0;
            while (i2 < regulatedChildCount) {
                te = this.regulatedChildBuffer[i2];
                this.regulatedChildBuffer[i2] = te = te.postParseCleanup(stripWhitespace);
                te.parent = this;
                te.index = i2++;
            }
            if (stripWhitespace) {
                for (i2 = 0; i2 < regulatedChildCount; ++i2) {
                    te = this.regulatedChildBuffer[i2];
                    if (!te.isIgnorable()) continue;
                    --regulatedChildCount;
                    int j2 = i2;
                    while (j2 < regulatedChildCount) {
                        TemplateElement te2;
                        this.regulatedChildBuffer[j2] = te2 = this.regulatedChildBuffer[j2 + 1];
                        te2.index = j2++;
                    }
                    this.regulatedChildBuffer[regulatedChildCount] = null;
                    this.regulatedChildCount = regulatedChildCount;
                    --i2;
                }
            }
            if (regulatedChildCount < this.regulatedChildBuffer.length && regulatedChildCount <= this.regulatedChildBuffer.length * 3 / 4) {
                TemplateElement[] trimmedregulatedChildBuffer = new TemplateElement[regulatedChildCount];
                for (int i3 = 0; i3 < regulatedChildCount; ++i3) {
                    trimmedregulatedChildBuffer[i3] = this.regulatedChildBuffer[i3];
                }
                this.regulatedChildBuffer = trimmedregulatedChildBuffer;
            }
        } else if (this.nestedBlock != null) {
            this.nestedBlock = this.nestedBlock.postParseCleanup(stripWhitespace);
            if (this.nestedBlock.isIgnorable()) {
                this.nestedBlock = null;
            } else {
                this.nestedBlock.parent = this;
            }
        }
        return this;
    }

    boolean isIgnorable() {
        return false;
    }

    TemplateElement prevTerminalNode() {
        TemplateElement prev = this.previousSibling();
        if (prev != null) {
            return prev.getLastLeaf();
        }
        if (this.parent != null) {
            return this.parent.prevTerminalNode();
        }
        return null;
    }

    TemplateElement nextTerminalNode() {
        TemplateElement next = this.nextSibling();
        if (next != null) {
            return next.getFirstLeaf();
        }
        if (this.parent != null) {
            return this.parent.nextTerminalNode();
        }
        return null;
    }

    TemplateElement previousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.index > 0 ? this.parent.regulatedChildBuffer[this.index - 1] : null;
    }

    TemplateElement nextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.index + 1 < this.parent.regulatedChildCount ? this.parent.regulatedChildBuffer[this.index + 1] : null;
    }

    private TemplateElement getFirstChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.regulatedChildCount == 0) {
            return null;
        }
        return this.regulatedChildBuffer[0];
    }

    private TemplateElement getLastChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        int regulatedChildCount = this.regulatedChildCount;
        if (regulatedChildCount == 0) {
            return null;
        }
        return this.regulatedChildBuffer[regulatedChildCount - 1];
    }

    private TemplateElement getFirstLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getFirstChild();
        }
        return te;
    }

    private TemplateElement getLastLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getLastChild();
        }
        return te;
    }

    boolean isOutputCacheable() {
        return false;
    }

    boolean heedsOpeningWhitespace() {
        return false;
    }

    boolean heedsTrailingWhitespace() {
        return false;
    }
}

