/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.DollarVariable;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.Interpolation;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.core.TemplateElement;
import freemarker.core._MiscTemplateException;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;

final class StringLiteral
extends Expression
implements TemplateScalarModel {
    private final String value;
    private TemplateElement dynamicValue;

    StringLiteral(String value) {
        this.value = value;
    }

    void parseValue(FMParserTokenManager parentTokenSource) throws ParseException {
        if (this.value.length() > 3 && (this.value.indexOf("${") >= 0 || this.value.indexOf("#{") >= 0)) {
            SimpleCharStream scs = new SimpleCharStream(new StringReader(this.value), this.beginLine, this.beginColumn + 1, this.value.length());
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            token_source.onlyTextOutput = true;
            token_source.initialNamingConvention = parentTokenSource.initialNamingConvention;
            token_source.namingConvention = parentTokenSource.namingConvention;
            token_source.namingConventionEstabilisher = parentTokenSource.namingConventionEstabilisher;
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            try {
                this.dynamicValue = parser.FreeMarkerText();
            }
            catch (ParseException e2) {
                e2.setTemplateName(this.getTemplate().getSourceName());
                throw e2;
            }
            this.constantValue = null;
            parentTokenSource.namingConvention = token_source.namingConvention;
            parentTokenSource.namingConventionEstabilisher = token_source.namingConventionEstabilisher;
        }
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        return new SimpleScalar(this.evalAndCoerceToString(env));
    }

    public String getAsString() {
        return this.value;
    }

    boolean isSingleInterpolationLiteral() {
        return this.dynamicValue != null && this.dynamicValue.getChildCount() == 1 && this.dynamicValue.getChildAt(0) instanceof DollarVariable;
    }

    String evalAndCoerceToString(Environment env) throws TemplateException {
        if (this.dynamicValue == null) {
            return this.value;
        }
        TemplateExceptionHandler teh = env.getTemplateExceptionHandler();
        env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            String string = env.renderElementToString(this.dynamicValue);
            return string;
        }
        catch (IOException ioe) {
            throw new _MiscTemplateException((Throwable)ioe, env);
        }
        finally {
            env.setTemplateExceptionHandler(teh);
        }
    }

    public String getCanonicalForm() {
        if (this.dynamicValue == null) {
            return StringUtil.ftlQuote(this.value);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        Enumeration childrenEnum = this.dynamicValue.children();
        while (childrenEnum.hasMoreElements()) {
            TemplateElement child = (TemplateElement)childrenEnum.nextElement();
            if (child instanceof Interpolation) {
                sb.append(((Interpolation)child).getCanonicalFormInStringLiteral());
                continue;
            }
            sb.append(StringUtil.FTLStringLiteralEnc(child.getCanonicalForm(), '\"'));
        }
        sb.append('\"');
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return this.dynamicValue == null ? this.getCanonicalForm() : "dynamic \"...\"";
    }

    boolean isLiteral() {
        return this.dynamicValue == null;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        StringLiteral cloned = new StringLiteral(this.value);
        cloned.dynamicValue = this.dynamicValue;
        return cloned;
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.dynamicValue;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.EMBEDDED_TEMPLATE;
    }
}

