/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BreakInstruction;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ListElseContainer;
import freemarker.core.LocalContext;
import freemarker.core.NonSequenceOrCollectionException;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core._CoreStringUtils;
import freemarker.core._MiscTemplateException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

final class IteratorBlock
extends TemplateElement {
    private final Expression listExp;
    private final String loopVarName;
    private final boolean isForEach;

    IteratorBlock(Expression listExp, String loopVarName, TemplateElement nestedBlock, boolean isForEach) {
        this.listExp = listExp;
        this.loopVarName = loopVarName;
        this.setNestedBlock(nestedBlock);
        this.isForEach = isForEach;
    }

    void accept(Environment env) throws TemplateException, IOException {
        this.acceptWithResult(env);
    }

    boolean acceptWithResult(Environment env) throws TemplateException, IOException {
        TemplateModel listValue = this.listExp.eval(env);
        if (listValue == null) {
            if (env.isClassicCompatible()) {
                listValue = Constants.EMPTY_SEQUENCE;
            } else {
                this.listExp.assertNonNull(null, env);
            }
        }
        return env.visitIteratorBlock(new IterationContext(listValue, this.loopVarName));
    }

    static IterationContext findEnclosingIterationContext(Environment env, String loopVariableName) throws _MiscTemplateException {
        ArrayList ctxStack = env.getLocalContextStack();
        if (ctxStack != null) {
            for (int i2 = ctxStack.size() - 1; i2 >= 0; --i2) {
                Object ctx = ctxStack.get(i2);
                if (!(ctx instanceof IterationContext) || loopVariableName != null && !loopVariableName.equals(((IterationContext)ctx).getLoopVariableName())) continue;
                return (IterationContext)ctx;
            }
        }
        return null;
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        if (this.isForEach) {
            buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVarName));
            buf.append(" in ");
            buf.append(this.listExp.getCanonicalForm());
        } else {
            buf.append(this.listExp.getCanonicalForm());
            if (this.loopVarName != null) {
                buf.append(" as ");
                buf.append(_CoreStringUtils.toFTLTopLevelIdentifierReference(this.loopVarName));
            }
        }
        if (canonical) {
            buf.append(">");
            if (this.getNestedBlock() != null) {
                buf.append(this.getNestedBlock().getCanonicalForm());
            }
            if (!(this.getParentElement() instanceof ListElseContainer)) {
                buf.append("</");
                buf.append(this.getNodeTypeSymbol());
                buf.append('>');
            }
        }
        return buf.toString();
    }

    int getParameterCount() {
        return this.loopVarName != null ? 2 : 1;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.listExp;
            }
            case 1: {
                if (this.loopVarName == null) {
                    throw new IndexOutOfBoundsException();
                }
                return this.loopVarName;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LIST_SOURCE;
            }
            case 1: {
                if (this.loopVarName == null) {
                    throw new IndexOutOfBoundsException();
                }
                return ParameterRole.TARGET_LOOP_VARIABLE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    String getNodeTypeSymbol() {
        return this.isForEach ? "#foreach" : "#list";
    }

    boolean isNestedBlockRepeater() {
        return this.loopVarName != null;
    }

    class IterationContext
    implements LocalContext {
        private static final String LOOP_STATE_HAS_NEXT = "_has_next";
        private static final String LOOP_STATE_INDEX = "_index";
        private TemplateModelIterator openedIteratorModel;
        private boolean hasNext;
        private TemplateModel loopVar;
        private int index;
        private boolean alreadyEntered;
        private Collection localVarNames = null;
        private String loopVarName;
        private final TemplateModel listValue;

        public IterationContext(TemplateModel listValue, String loopVariableName) {
            this.listValue = listValue;
            this.loopVarName = loopVariableName;
        }

        boolean accept(Environment env) throws TemplateException, IOException {
            return this.executeNestedBlock(env, IteratorBlock.this.getNestedBlock());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loopForItemsElement(Environment env, TemplateElement nestedBlock, String loopVarName) throws NonSequenceOrCollectionException, TemplateModelException, InvalidReferenceException, TemplateException, IOException {
            try {
                if (this.alreadyEntered) {
                    throw new _MiscTemplateException(env, "The #items directive was already entered earlier for this listing.");
                }
                this.alreadyEntered = true;
                this.loopVarName = loopVarName;
                this.executeNestedBlock(env, nestedBlock);
            }
            finally {
                this.loopVarName = null;
            }
        }

        private boolean executeNestedBlock(Environment env, TemplateElement nestedBlock) throws TemplateModelException, TemplateException, IOException, NonSequenceOrCollectionException, InvalidReferenceException {
            return this.executeNestedBlockInner(env, nestedBlock);
        }

        private boolean executeNestedBlockInner(Environment env, TemplateElement nestedBlock) throws TemplateModelException, TemplateException, IOException, NonSequenceOrCollectionException, InvalidReferenceException {
            boolean listNotEmpty;
            if (this.listValue instanceof TemplateCollectionModel) {
                TemplateCollectionModel collModel = (TemplateCollectionModel)this.listValue;
                TemplateModelIterator iterModel = this.openedIteratorModel == null ? collModel.iterator() : this.openedIteratorModel;
                this.hasNext = iterModel.hasNext();
                listNotEmpty = this.hasNext;
                if (listNotEmpty) {
                    if (this.loopVarName != null) {
                        try {
                            while (this.hasNext) {
                                this.loopVar = iterModel.next();
                                this.hasNext = iterModel.hasNext();
                                if (nestedBlock != null) {
                                    env.visitByHiddingParent(nestedBlock);
                                }
                                ++this.index;
                            }
                        }
                        catch (BreakInstruction.Break br2) {
                            // empty catch block
                        }
                        this.openedIteratorModel = null;
                    } else {
                        this.openedIteratorModel = iterModel;
                        if (nestedBlock != null) {
                            env.visitByHiddingParent(nestedBlock);
                        }
                    }
                }
            } else if (this.listValue instanceof TemplateSequenceModel) {
                TemplateSequenceModel seqModel = (TemplateSequenceModel)this.listValue;
                int size = seqModel.size();
                boolean bl2 = listNotEmpty = size != 0;
                if (listNotEmpty) {
                    if (this.loopVarName != null) {
                        try {
                            this.index = 0;
                            while (this.index < size) {
                                this.loopVar = seqModel.get(this.index);
                                boolean bl3 = this.hasNext = size > this.index + 1;
                                if (nestedBlock != null) {
                                    env.visitByHiddingParent(nestedBlock);
                                }
                                ++this.index;
                            }
                        }
                        catch (BreakInstruction.Break br3) {}
                    } else if (nestedBlock != null) {
                        env.visitByHiddingParent(nestedBlock);
                    }
                }
            } else if (env.isClassicCompatible()) {
                listNotEmpty = true;
                if (this.loopVarName != null) {
                    this.loopVar = this.listValue;
                    this.hasNext = false;
                }
                try {
                    if (nestedBlock != null) {
                        env.visitByHiddingParent(nestedBlock);
                    }
                }
                catch (BreakInstruction.Break br4) {}
            } else {
                throw new NonSequenceOrCollectionException(IteratorBlock.this.listExp, this.listValue, env);
            }
            return listNotEmpty;
        }

        String getLoopVariableName() {
            return this.loopVarName;
        }

        public TemplateModel getLocalVariable(String name) {
            String loopVariableName = this.loopVarName;
            if (loopVariableName != null && name.startsWith(loopVariableName)) {
                switch (name.length() - loopVariableName.length()) {
                    case 0: {
                        return this.loopVar;
                    }
                    case 6: {
                        if (!name.endsWith(LOOP_STATE_INDEX)) break;
                        return new SimpleNumber(this.index);
                    }
                    case 9: {
                        if (!name.endsWith(LOOP_STATE_HAS_NEXT)) break;
                        return this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                    }
                }
            }
            return null;
        }

        public Collection getLocalVariableNames() {
            String loopVariableName = this.loopVarName;
            if (loopVariableName != null) {
                if (this.localVarNames == null) {
                    this.localVarNames = new ArrayList(3);
                    this.localVarNames.add(loopVariableName);
                    this.localVarNames.add(loopVariableName + LOOP_STATE_INDEX);
                    this.localVarNames.add(loopVariableName + LOOP_STATE_HAS_NEXT);
                }
                return this.localVarNames;
            }
            return Collections.EMPTY_LIST;
        }

        boolean hasNext() {
            return this.hasNext;
        }

        int getIndex() {
            return this.index;
        }
    }
}

