/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ConditionalBlock;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.template.TemplateException;
import java.io.IOException;

final class IfBlock
extends TemplateElement {
    IfBlock(ConditionalBlock block) {
        this.setRegulatedChildBufferCapacity(1);
        this.addBlock(block);
    }

    void addBlock(ConditionalBlock block) {
        this.addRegulatedChild(block);
    }

    void accept(Environment env) throws TemplateException, IOException {
        int ln = this.getRegulatedChildCount();
        for (int i2 = 0; i2 < ln; ++i2) {
            ConditionalBlock cblock = (ConditionalBlock)this.getRegulatedChild(i2);
            Expression condition = cblock.condition;
            env.replaceElementStackTop(cblock);
            if (condition != null && !condition.evalToBoolean(env)) continue;
            if (cblock.getNestedBlock() != null) {
                env.visitByHiddingParent(cblock.getNestedBlock());
            }
            return;
        }
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        if (this.getRegulatedChildCount() == 1) {
            ConditionalBlock cblock = (ConditionalBlock)this.getRegulatedChild(0);
            cblock.isLonelyIf = true;
            cblock.setLocation(this.getTemplate(), (TemplateObject)cblock, (TemplateObject)this);
            return cblock.postParseCleanup(stripWhitespace);
        }
        return super.postParseCleanup(stripWhitespace);
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer buf = new StringBuffer();
            int ln = this.getRegulatedChildCount();
            for (int i2 = 0; i2 < ln; ++i2) {
                ConditionalBlock cblock = (ConditionalBlock)this.getRegulatedChild(i2);
                buf.append(cblock.dump(canonical));
            }
            buf.append("</#if>");
            return buf.toString();
        }
        return this.getNodeTypeSymbol();
    }

    String getNodeTypeSymbol() {
        return "#if-#elseif-#else-container";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isShownInStackTrace() {
        return false;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

