/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AddConcatExpression;
import freemarker.core.AndExpression;
import freemarker.core.ArithmeticExpression;
import freemarker.core.Assignment;
import freemarker.core.AssignmentInstruction;
import freemarker.core.AttemptBlock;
import freemarker.core.BlockAssignment;
import freemarker.core.BodyInstruction;
import freemarker.core.BooleanLiteral;
import freemarker.core.BreakInstruction;
import freemarker.core.BuiltIn;
import freemarker.core.BuiltInForLoopVariable;
import freemarker.core.BuiltInWithParseTimeParameters;
import freemarker.core.BuiltinVariable;
import freemarker.core.Case;
import freemarker.core.Comment;
import freemarker.core.ComparisonExpression;
import freemarker.core.CompressedBlock;
import freemarker.core.ConditionalBlock;
import freemarker.core.DefaultToExpression;
import freemarker.core.DollarVariable;
import freemarker.core.Dot;
import freemarker.core.DynamicKeyName;
import freemarker.core.ElseOfList;
import freemarker.core.EscapeBlock;
import freemarker.core.ExistsExpression;
import freemarker.core.Expression;
import freemarker.core.FMParserConstants;
import freemarker.core.FMParserTokenManager;
import freemarker.core.FallbackInstruction;
import freemarker.core.FlushInstruction;
import freemarker.core.HashLiteral;
import freemarker.core.Identifier;
import freemarker.core.IfBlock;
import freemarker.core.Include;
import freemarker.core.Items;
import freemarker.core.IteratorBlock;
import freemarker.core.LibraryLoad;
import freemarker.core.ListElseContainer;
import freemarker.core.ListLiteral;
import freemarker.core.Macro;
import freemarker.core.MethodCall;
import freemarker.core.MixedContent;
import freemarker.core.NoEscapeBlock;
import freemarker.core.NotExpression;
import freemarker.core.NumberLiteral;
import freemarker.core.NumericalOutput;
import freemarker.core.OrExpression;
import freemarker.core.ParentheticalExpression;
import freemarker.core.ParseException;
import freemarker.core.PropertySetting;
import freemarker.core.Range;
import freemarker.core.RecoveryBlock;
import freemarker.core.RecurseNode;
import freemarker.core.ReturnInstruction;
import freemarker.core.Sep;
import freemarker.core.SimpleCharStream;
import freemarker.core.SpecialBuiltIn;
import freemarker.core.StopInstruction;
import freemarker.core.StringLiteral;
import freemarker.core.SwitchBlock;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.core.TextBlock;
import freemarker.core.Token;
import freemarker.core.TransformBlock;
import freemarker.core.TrimInstruction;
import freemarker.core.UnaryPlusMinusExpression;
import freemarker.core.UnifiedCall;
import freemarker.core.VisitNode;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template._TemplateAPI;
import freemarker.template.utility.DeepUnwrap;
import freemarker.template.utility.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class FMParser
implements FMParserConstants {
    private static final int ITERATOR_BLOCK_KIND_LIST = 0;
    private static final int ITERATOR_BLOCK_KIND_FOREACH = 1;
    private static final int ITERATOR_BLOCK_KIND_ITEMS = 2;
    private static final int ITERATOR_BLOCK_KIND_USER_DIRECTIVE = 3;
    private Template template;
    private boolean stripWhitespace;
    private boolean stripText;
    private List iteratorBlockContexts;
    private int breakableDirectiveNesting;
    private int parentListAndForeachFlags;
    private boolean inMacro;
    private boolean inFunction;
    private LinkedList escapes = new LinkedList();
    private int mixedContentNesting;
    private int incompatibleImprovements;
    public FMParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[95];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[16];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static FMParser createExpressionParser(String s2) {
        SimpleCharStream scs = new SimpleCharStream(new StringReader(s2), 1, 1, s2.length());
        FMParserTokenManager token_source = new FMParserTokenManager(scs);
        token_source.SwitchTo(2);
        FMParser parser = new FMParser(token_source);
        token_source.setParser(parser);
        return parser;
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace) {
        this(reader);
        this.setTemplate(template);
        this.token_source.setParser(this);
        this.token_source.strictEscapeSyntax = strictEscapeSyntax;
        this.stripWhitespace = stripWhitespace;
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace, int tagSyntax) {
        this(template, reader, strictEscapeSyntax, stripWhitespace, tagSyntax, Configuration.PARSED_DEFAULT_INCOMPATIBLE_ENHANCEMENTS);
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace, int tagSyntax, int incompatibleImprovements) {
        this(template, reader, strictEscapeSyntax, stripWhitespace, tagSyntax, 10, incompatibleImprovements);
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace, int tagSyntax, int namingConvention, int incompatibleImprovements) {
        this(template, reader, strictEscapeSyntax, stripWhitespace);
        switch (tagSyntax) {
            case 0: {
                this.token_source.autodetectTagSyntax = true;
                break;
            }
            case 1: {
                this.token_source.squBracTagSyntax = false;
                break;
            }
            case 2: {
                this.token_source.squBracTagSyntax = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument for tagSyntax");
            }
        }
        switch (namingConvention) {
            case 10: 
            case 11: 
            case 12: {
                this.token_source.initialNamingConvention = namingConvention;
                this.token_source.namingConvention = namingConvention;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument for namingConvention");
            }
        }
        this.token_source.incompatibleImprovements = incompatibleImprovements;
        this.incompatibleImprovements = incompatibleImprovements;
    }

    public FMParser(String template) {
        this(null, new StringReader(template), true, true);
    }

    void setTemplate(Template template) {
        this.template = template;
    }

    Template getTemplate() {
        return this.template;
    }

    public int _getLastTagSyntax() {
        return this.token_source.squBracTagSyntax ? 2 : 1;
    }

    public int _getLastNamingConvention() {
        return this.token_source.namingConvention;
    }

    private void notStringLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof StringLiteral) {
            throw new ParseException("Found string literal: " + exp + ". Expecting: " + expected, exp);
        }
    }

    private void notNumberLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof NumberLiteral) {
            throw new ParseException("Found number literal: " + exp.getCanonicalForm() + ". Expecting " + expected, exp);
        }
    }

    private void notBooleanLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof BooleanLiteral) {
            throw new ParseException("Found: " + exp.getCanonicalForm() + ". Expecting " + expected, exp);
        }
    }

    private void notHashLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof HashLiteral) {
            throw new ParseException("Found hash literal: " + exp.getCanonicalForm() + ". Expecting " + expected, exp);
        }
    }

    private void notListLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof ListLiteral) {
            throw new ParseException("Found list literal: " + exp.getCanonicalForm() + ". Expecting " + expected, exp);
        }
    }

    private void numberLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void stringLiteralOnly(Expression exp) throws ParseException {
        this.notNumberLiteral(exp, "string");
        this.notListLiteral(exp, "string");
        this.notHashLiteral(exp, "string");
        this.notBooleanLiteral(exp, "string");
    }

    private void booleanLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "boolean (true/false)");
        this.notListLiteral(exp, "boolean (true/false)");
        this.notHashLiteral(exp, "boolean (true/false)");
        this.notNumberLiteral(exp, "boolean (true/false)");
    }

    private Expression escapedExpression(Expression exp) {
        if (!this.escapes.isEmpty()) {
            return ((EscapeBlock)this.escapes.getFirst()).doEscape(exp);
        }
        return exp;
    }

    private boolean getBoolean(Expression exp) throws ParseException {
        TemplateModel tm = null;
        try {
            tm = exp.eval(null);
        }
        catch (Exception e2) {
            throw new ParseException(e2.getMessage() + "\nCould not evaluate expression: " + exp.getCanonicalForm(), exp, e2);
        }
        if (tm instanceof TemplateBooleanModel) {
            try {
                return ((TemplateBooleanModel)tm).getAsBoolean();
            }
            catch (TemplateModelException tme) {
                // empty catch block
            }
        }
        if (tm instanceof TemplateScalarModel) {
            try {
                return StringUtil.getYesNo(((TemplateScalarModel)tm).getAsString());
            }
            catch (Exception e3) {
                throw new ParseException(e3.getMessage() + "\nExpecting boolean (true/false), found: " + exp.getCanonicalForm(), exp);
            }
        }
        throw new ParseException("Expecting boolean (true/false) parameter", exp);
    }

    private ParserIteratorBlockContext pushIteratorBlockContext() {
        if (this.iteratorBlockContexts == null) {
            this.iteratorBlockContexts = new ArrayList(4);
        }
        ParserIteratorBlockContext newCtx = new ParserIteratorBlockContext();
        this.iteratorBlockContexts.add(newCtx);
        return newCtx;
    }

    private void popIteratorBlockContext() {
        this.iteratorBlockContexts.remove(this.iteratorBlockContexts.size() - 1);
    }

    private ParserIteratorBlockContext peekIteratorBlockContext() {
        int size = this.iteratorBlockContexts != null ? this.iteratorBlockContexts.size() : 0;
        return size != 0 ? (ParserIteratorBlockContext)this.iteratorBlockContexts.get(size - 1) : null;
    }

    private void checkLoopVariableBuiltInLHO(String loopVarName, Expression lhoExp, Token biName) throws ParseException {
        int size = this.iteratorBlockContexts != null ? this.iteratorBlockContexts.size() : 0;
        for (int i2 = size - 1; i2 >= 0; --i2) {
            ParserIteratorBlockContext ctx = (ParserIteratorBlockContext)this.iteratorBlockContexts.get(i2);
            if (!loopVarName.equals(ctx.loopVarName)) continue;
            if (ctx.kind == 3) {
                throw new ParseException("The left hand operand of ?" + biName.image + " can't be the loop variable of an user defined directive: " + loopVarName, lhoExp);
            }
            return;
        }
        throw new ParseException("The left hand operand of ?" + biName.image + " must be a loop variable, " + "but there's no loop variable in scope with this name: " + loopVarName, lhoExp);
    }

    private String forEachDirectiveSymbol() {
        return this.token_source.namingConvention == 12 ? "#forEach" : "#foreach";
    }

    public final Expression Expression() throws ParseException {
        Expression exp = this.OrExpression();
        return exp;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: 
            case 90: {
                exp = this.NumberLiteral();
                break;
            }
            case 128: {
                exp = this.HashLiteral();
                break;
            }
            case 85: 
            case 86: {
                exp = this.StringLiteral(true);
                break;
            }
            case 87: 
            case 88: {
                exp = this.BooleanLiteral();
                break;
            }
            case 124: {
                exp = this.ListLiteral();
                break;
            }
            case 133: {
                exp = this.Identifier();
                break;
            }
            case 126: {
                exp = this.Parenthesis();
                break;
            }
            case 91: {
                exp = this.BuiltinVariable();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            exp = this.AddSubExpression(exp);
        }
        return exp;
    }

    public final Expression Parenthesis() throws ParseException {
        Token start = this.jj_consume_token(126);
        Expression exp = this.Expression();
        Token end = this.jj_consume_token(127);
        ParentheticalExpression result = new ParentheticalExpression(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression result;
        boolean haveNot = false;
        Object t2 = null;
        Object start = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: 
            case 112: {
                result = this.UnaryPlusMinusExpression();
                break;
            }
            case 120: {
                result = this.NotExpression();
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 124: 
            case 126: 
            case 128: 
            case 133: {
                result = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Expression NotExpression() throws ParseException {
        NotExpression result = null;
        ArrayList<Token> nots = new ArrayList<Token>();
        block3: while (true) {
            Token t2 = this.jj_consume_token(120);
            nots.add(t2);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        Expression exp = this.PrimaryExpression();
        for (int i2 = 0; i2 < nots.size(); ++i2) {
            result = new NotExpression(exp);
            Token tok = (Token)nots.get(nots.size() - i2 - 1);
            result.setLocation(this.template, tok, (TemplateObject)exp);
            exp = result;
        }
        return result;
    }

    public final Expression UnaryPlusMinusExpression() throws ParseException {
        Token t2;
        boolean isMinus = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: {
                t2 = this.jj_consume_token(111);
                break;
            }
            case 112: {
                t2 = this.jj_consume_token(112);
                isMinus = true;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression exp = this.PrimaryExpression();
        UnaryPlusMinusExpression result = new UnaryPlusMinusExpression(exp, isMinus);
        result.setLocation(this.template, t2, (TemplateObject)exp);
        return result;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.MultiplicativeExpression();
        while (this.jj_2_2(Integer.MAX_VALUE)) {
            boolean plus;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 111: {
                    this.jj_consume_token(111);
                    plus = true;
                    break;
                }
                case 112: {
                    this.jj_consume_token(112);
                    plus = false;
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.MultiplicativeExpression();
            if (plus) {
                result = new AddConcatExpression(lhs, rhs);
            } else {
                this.numberLiteralOnly(lhs);
                this.numberLiteralOnly(rhs);
                result = new ArithmeticExpression(lhs, rhs, 0);
            }
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression lhs;
        int operation = 1;
        Expression result = lhs = this.UnaryExpression();
        while (this.jj_2_3(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 113: {
                    this.jj_consume_token(113);
                    operation = 1;
                    break;
                }
                case 116: {
                    this.jj_consume_token(116);
                    operation = 2;
                    break;
                }
                case 117: {
                    this.jj_consume_token(117);
                    operation = 3;
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.UnaryExpression();
            this.numberLiteralOnly(lhs);
            this.numberLiteralOnly(rhs);
            result = new ArithmeticExpression(lhs, rhs, operation);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression EqualityExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.RelationalExpression();
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            Token t2;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: {
                    t2 = this.jj_consume_token(99);
                    break;
                }
                case 97: {
                    t2 = this.jj_consume_token(97);
                    break;
                }
                case 98: {
                    t2 = this.jj_consume_token(98);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.RelationalExpression();
            this.notHashLiteral(lhs, "scalar");
            this.notHashLiteral(rhs, "scalar");
            this.notListLiteral(lhs, "scalar");
            this.notListLiteral(rhs, "scalar");
            result = new ComparisonExpression(lhs, rhs, t2.image);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression RelationalExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.RangeExpression();
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            Token t2;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 142: {
                    t2 = this.jj_consume_token(142);
                    break;
                }
                case 110: {
                    t2 = this.jj_consume_token(110);
                    break;
                }
                case 141: {
                    t2 = this.jj_consume_token(141);
                    break;
                }
                case 109: {
                    t2 = this.jj_consume_token(109);
                    break;
                }
                case 108: {
                    t2 = this.jj_consume_token(108);
                    break;
                }
                case 107: {
                    t2 = this.jj_consume_token(107);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.RangeExpression();
            this.notHashLiteral(lhs, "scalar");
            this.notHashLiteral(rhs, "scalar");
            this.notListLiteral(lhs, "scalar");
            this.notListLiteral(rhs, "scalar");
            this.notStringLiteral(lhs, "number");
            this.notStringLiteral(rhs, "number");
            result = new ComparisonExpression(lhs, rhs, t2.image);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression RangeExpression() throws ParseException {
        Expression lhs;
        Expression rhs = null;
        Token dotDot = null;
        Expression result = lhs = this.AdditiveExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: 
            case 93: 
            case 94: {
                int endType;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 93: 
                    case 94: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 93: {
                                this.jj_consume_token(93);
                                endType = 1;
                                break;
                            }
                            case 94: {
                                this.jj_consume_token(94);
                                endType = 3;
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        rhs = this.AdditiveExpression();
                        break;
                    }
                    case 92: {
                        dotDot = this.jj_consume_token(92);
                        endType = 2;
                        if (!this.jj_2_6(Integer.MAX_VALUE)) break;
                        rhs = this.AdditiveExpression();
                        endType = 0;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.numberLiteralOnly(lhs);
                if (rhs != null) {
                    this.numberLiteralOnly(rhs);
                }
                Range range = new Range(lhs, rhs, endType);
                if (rhs != null) {
                    range.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
                } else {
                    range.setLocation(this.template, (TemplateObject)lhs, dotDot);
                }
                result = range;
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        return result;
    }

    public final Expression AndExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.EqualityExpression();
        while (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(118);
            Expression rhs = this.EqualityExpression();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new AndExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression OrExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.AndExpression();
        while (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(119);
            Expression rhs = this.AndExpression();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new OrExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final ListLiteral ListLiteral() throws ParseException {
        ArrayList values = new ArrayList();
        Token begin = this.jj_consume_token(124);
        values = this.PositionalArgs();
        Token end = this.jj_consume_token(125);
        ListLiteral result = new ListLiteral(values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final Expression NumberLiteral() throws ParseException {
        Token t2;
        Token op = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: {
                t2 = this.jj_consume_token(89);
                break;
            }
            case 90: {
                t2 = this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s2 = t2.image;
        NumberLiteral result = new NumberLiteral(this.template.getArithmeticEngine().toNumber(s2));
        Token startToken = op != null ? op : t2;
        result.setLocation(this.template, startToken, t2);
        return result;
    }

    public final Identifier Identifier() throws ParseException {
        Token t2 = this.jj_consume_token(133);
        Identifier id = new Identifier(t2.image);
        id.setLocation(this.template, t2, t2);
        return id;
    }

    public final Expression IdentifierOrStringLiteral() throws ParseException {
        Expression exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 133: {
                exp = this.Identifier();
                break;
            }
            case 85: 
            case 86: {
                exp = this.StringLiteral(false);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final BuiltinVariable BuiltinVariable() throws ParseException {
        Token dot = this.jj_consume_token(91);
        Token name = this.jj_consume_token(133);
        BuiltinVariable result = null;
        this.token_source.checkNamingConvention(name);
        result = new BuiltinVariable(name, this.token_source);
        result.setLocation(this.template, dot, name);
        return result;
    }

    public final Expression AddSubExpression(Expression exp) throws ParseException {
        Expression result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                result = this.DotVariable(exp);
                break;
            }
            case 124: {
                result = this.DynamicKey(exp);
                break;
            }
            case 126: {
                result = this.MethodArgs(exp);
                break;
            }
            case 95: {
                result = this.BuiltIn(exp);
                break;
            }
            case 120: 
            case 144: {
                result = this.DefaultTo(exp);
                break;
            }
            case 96: {
                result = this.Exists(exp);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Expression DefaultTo(Expression exp) throws ParseException {
        Token t2;
        Expression rhs = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: {
                t2 = this.jj_consume_token(144);
                break;
            }
            case 120: {
                t2 = this.jj_consume_token(120);
                if (!this.jj_2_9(Integer.MAX_VALUE)) break;
                rhs = this.Expression();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DefaultToExpression result = new DefaultToExpression(exp, rhs);
        if (rhs == null) {
            result.setLocation(this.template, (TemplateObject)exp, t2);
        } else {
            result.setLocation(this.template, (TemplateObject)exp, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression Exists(Expression exp) throws ParseException {
        Token t2 = this.jj_consume_token(96);
        ExistsExpression result = new ExistsExpression(exp);
        result.setLocation(this.template, (TemplateObject)exp, t2);
        return result;
    }

    public final Expression BuiltIn(Expression lhoExp) throws ParseException {
        Token t2 = null;
        ArrayList args = null;
        this.jj_consume_token(95);
        t2 = this.jj_consume_token(133);
        this.token_source.checkNamingConvention(t2);
        BuiltIn result = BuiltIn.newBuiltIn(this.incompatibleImprovements, lhoExp, t2, this.token_source);
        result.setLocation(this.template, (TemplateObject)lhoExp, t2);
        if (!(result instanceof SpecialBuiltIn)) {
            return result;
        }
        if (result instanceof BuiltInForLoopVariable) {
            if (!(lhoExp instanceof Identifier)) {
                throw new ParseException("Expression used as the left hand operand of ?" + t2.image + " must be a simple loop variable name.", lhoExp);
            }
            String loopVarName = ((Identifier)lhoExp).getName();
            this.checkLoopVariableBuiltInLHO(loopVarName, lhoExp, t2);
            ((BuiltInForLoopVariable)result).bindToLoopVariable(loopVarName);
            return result;
        }
        if (result instanceof BuiltInWithParseTimeParameters) {
            Token openParen = this.jj_consume_token(126);
            args = this.PositionalArgs();
            Token closeParen = this.jj_consume_token(127);
            result.setLocation(this.template, (TemplateObject)lhoExp, closeParen);
            ((BuiltInWithParseTimeParameters)result).bindToParameters(args, openParen, closeParen);
            return result;
        }
        throw new AssertionError((Object)("Unhandled " + SpecialBuiltIn.class.getName() + " subclass: " + result.getClass()));
    }

    public final Expression DotVariable(Expression exp) throws ParseException {
        Token t2;
        this.jj_consume_token(91);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 133: {
                t2 = this.jj_consume_token(133);
                break;
            }
            case 113: {
                t2 = this.jj_consume_token(113);
                break;
            }
            case 114: {
                t2 = this.jj_consume_token(114);
                break;
            }
            case 87: 
            case 88: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 130: 
            case 131: 
            case 132: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 107: {
                        t2 = this.jj_consume_token(107);
                        break;
                    }
                    case 108: {
                        t2 = this.jj_consume_token(108);
                        break;
                    }
                    case 109: {
                        t2 = this.jj_consume_token(109);
                        break;
                    }
                    case 110: {
                        t2 = this.jj_consume_token(110);
                        break;
                    }
                    case 87: {
                        t2 = this.jj_consume_token(87);
                        break;
                    }
                    case 88: {
                        t2 = this.jj_consume_token(88);
                        break;
                    }
                    case 130: {
                        t2 = this.jj_consume_token(130);
                        break;
                    }
                    case 131: {
                        t2 = this.jj_consume_token(131);
                        break;
                    }
                    case 132: {
                        t2 = this.jj_consume_token(132);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (Character.isLetter(t2.image.charAt(0))) break;
                throw new ParseException(t2.image + " is not a valid identifier.", this.template, t2);
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.notListLiteral(exp, "hash");
        this.notStringLiteral(exp, "hash");
        this.notBooleanLiteral(exp, "hash");
        Dot dot = new Dot(exp, t2.image);
        dot.setLocation(this.template, (TemplateObject)exp, t2);
        return dot;
    }

    public final Expression DynamicKey(Expression exp) throws ParseException {
        this.jj_consume_token(124);
        Expression arg = this.Expression();
        Token t2 = this.jj_consume_token(125);
        this.notBooleanLiteral(exp, "list or hash");
        this.notNumberLiteral(exp, "list or hash");
        DynamicKeyName dkn = new DynamicKeyName(exp, arg);
        dkn.setLocation(this.template, (TemplateObject)exp, t2);
        return dkn;
    }

    public final MethodCall MethodArgs(Expression exp) throws ParseException {
        ArrayList args = new ArrayList();
        this.jj_consume_token(126);
        args = this.PositionalArgs();
        Token end = this.jj_consume_token(127);
        args.trimToSize();
        MethodCall result = new MethodCall(exp, args);
        result.setLocation(this.template, (TemplateObject)exp, end);
        return result;
    }

    public final StringLiteral StringLiteral(boolean interpolate) throws ParseException {
        Token t2;
        boolean raw = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                t2 = this.jj_consume_token(85);
                break;
            }
            case 86: {
                t2 = this.jj_consume_token(86);
                raw = true;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s2 = t2.image;
        s2 = s2.substring(1, s2.length() - 1);
        if (raw) {
            s2 = s2.substring(1);
        } else {
            try {
                s2 = StringUtil.FTLStringLiteralDec(s2);
            }
            catch (ParseException pe) {
                pe.lineNumber = t2.beginLine;
                pe.columnNumber = t2.beginColumn;
                pe.endLineNumber = t2.endLine;
                pe.endColumnNumber = t2.endColumn;
                throw pe;
            }
        }
        StringLiteral result = new StringLiteral(s2);
        result.setLocation(this.template, t2, t2);
        if (interpolate && !raw && (t2.image.indexOf("${") >= 0 || t2.image.indexOf("#{") >= 0)) {
            result.parseValue(this.token_source);
        }
        return result;
    }

    public final Expression BooleanLiteral() throws ParseException {
        BooleanLiteral result;
        Token t2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                t2 = this.jj_consume_token(87);
                result = new BooleanLiteral(false);
                break;
            }
            case 88: {
                t2 = this.jj_consume_token(88);
                result = new BooleanLiteral(true);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.setLocation(this.template, t2, t2);
        return result;
    }

    public final HashLiteral HashLiteral() throws ParseException {
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        Token begin = this.jj_consume_token(128);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 111: 
            case 112: 
            case 120: 
            case 124: 
            case 126: 
            case 128: 
            case 133: {
                Expression key = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 121: {
                        this.jj_consume_token(121);
                        break;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression value = this.Expression();
                this.stringLiteralOnly(key);
                keys.add(key);
                values.add(value);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 121: {
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(121);
                    key = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 121: {
                            this.jj_consume_token(121);
                            break;
                        }
                        case 123: {
                            this.jj_consume_token(123);
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    value = this.Expression();
                    this.stringLiteralOnly(key);
                    keys.add(key);
                    values.add(value);
                }
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(129);
        HashLiteral result = new HashLiteral(keys, values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final DollarVariable StringOutput() throws ParseException {
        Token begin = this.jj_consume_token(75);
        Expression exp = this.Expression();
        this.notHashLiteral(exp, "string or something automatically convertible to string (number, date or boolean)");
        this.notListLiteral(exp, "string or something automatically convertible to string (number, date or boolean)");
        Token end = this.jj_consume_token(129);
        DollarVariable result = new DollarVariable(exp, this.escapedExpression(exp));
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final NumericalOutput NumericalOutput() throws ParseException {
        NumericalOutput result;
        Token fmt = null;
        Token begin = this.jj_consume_token(76);
        Expression exp = this.Expression();
        this.numberLiteralOnly(exp);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                fmt = this.jj_consume_token(133);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(129);
        if (fmt != null) {
            int minFrac = -1;
            int maxFrac = -1;
            StringTokenizer st = new StringTokenizer(fmt.image, "mM", true);
            int type = 45;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    if (type != 45) {
                        switch (type) {
                            case 109: {
                                if (minFrac != -1) {
                                    throw new ParseException("Invalid formatting string", this.template, fmt);
                                }
                                minFrac = Integer.parseInt(token);
                                break;
                            }
                            case 77: {
                                if (maxFrac != -1) {
                                    throw new ParseException("Invalid formatting string", this.template, fmt);
                                }
                                maxFrac = Integer.parseInt(token);
                                break;
                            }
                            default: {
                                throw new ParseException("Invalid formatting string", this.template, fmt);
                            }
                        }
                        type = 45;
                        continue;
                    }
                    if (token.equals("m")) {
                        type = 109;
                        continue;
                    }
                    if (token.equals("M")) {
                        type = 77;
                        continue;
                    }
                    throw new ParseException();
                }
                catch (ParseException e2) {
                    throw new ParseException("Invalid format specifier " + fmt.image, this.template, fmt);
                }
                catch (NumberFormatException e3) {
                    throw new ParseException("Invalid number in the format specifier " + fmt.image, this.template, fmt);
                }
            }
            if (maxFrac == -1) {
                if (minFrac == -1) {
                    throw new ParseException("Invalid format specification, at least one of m and M must be specified!", this.template, fmt);
                }
                maxFrac = minFrac;
            } else if (minFrac == -1) {
                minFrac = 0;
            }
            if (minFrac > maxFrac) {
                throw new ParseException("Invalid format specification, min cannot be greater than max!", this.template, fmt);
            }
            if (minFrac > 50 || maxFrac > 50) {
                throw new ParseException("Cannot specify more than 50 fraction digits", this.template, fmt);
            }
            result = new NumericalOutput(exp, minFrac, maxFrac);
        } else {
            result = new NumericalOutput(exp);
        }
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final TemplateElement If() throws ParseException {
        Token t2;
        Token start = this.jj_consume_token(8);
        Expression condition = this.Expression();
        this.jj_consume_token(139);
        TemplateElement block = this.OptionalBlock();
        ConditionalBlock cblock = new ConditionalBlock(condition, block, 0);
        cblock.setLocation(this.template, start, (TemplateObject)block);
        IfBlock ifBlock = new IfBlock(cblock);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block6;
                }
            }
            t2 = this.jj_consume_token(9);
            condition = this.Expression();
            this.LooseDirectiveEnd();
            block = this.OptionalBlock();
            cblock = new ConditionalBlock(condition, block, 2);
            cblock.setLocation(this.template, t2, (TemplateObject)block);
            ifBlock.addBlock(cblock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                t2 = this.jj_consume_token(48);
                block = this.OptionalBlock();
                cblock = new ConditionalBlock(null, block, 1);
                cblock.setLocation(this.template, t2, (TemplateObject)block);
                ifBlock.addBlock(cblock);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(33);
        ifBlock.setLocation(this.template, start, end);
        return ifBlock;
    }

    public final AttemptBlock Attempt() throws ParseException {
        Token end;
        Token start = this.jj_consume_token(6);
        TemplateElement block = this.OptionalBlock();
        RecoveryBlock recoveryBlock = this.Recover();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                end = this.jj_consume_token(37);
                break;
            }
            case 38: {
                end = this.jj_consume_token(38);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AttemptBlock result = new AttemptBlock(block, recoveryBlock);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final RecoveryBlock Recover() throws ParseException {
        Token start = this.jj_consume_token(7);
        TemplateElement block = this.OptionalBlock();
        RecoveryBlock result = new RecoveryBlock(block);
        result.setLocation(this.template, start, (TemplateObject)block);
        return result;
    }

    public final TemplateElement List() throws ParseException {
        TemplateElement result;
        Token loopVar = null;
        ElseOfList elseOfList = null;
        Token start = this.jj_consume_token(10);
        Expression exp = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 131: {
                this.jj_consume_token(131);
                loopVar = this.jj_consume_token(133);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        ParserIteratorBlockContext iterCtx = this.pushIteratorBlockContext();
        if (loopVar != null) {
            iterCtx.loopVarName = loopVar.image;
            ++this.breakableDirectiveNesting;
        }
        TemplateElement mainBlock = this.OptionalBlock();
        if (loopVar != null) {
            --this.breakableDirectiveNesting;
        } else if (iterCtx.kind != 2) {
            throw new ParseException("#list must have either \"as loopVar\" parameter or nested #items that belongs to it.", this.template, start);
        }
        this.popIteratorBlockContext();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                elseOfList = this.ElseOfList();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(34);
        IteratorBlock list = new IteratorBlock(exp, loopVar != null ? loopVar.image : null, mainBlock, false);
        list.setLocation(this.template, start, end);
        if (elseOfList == null) {
            result = list;
        } else {
            result = new ListElseContainer(list, elseOfList);
            result.setLocation(this.template, start, end);
        }
        return result;
    }

    public final ElseOfList ElseOfList() throws ParseException {
        Token start = this.jj_consume_token(48);
        TemplateElement block = this.OptionalBlock();
        ElseOfList result = new ElseOfList(block);
        result.setLocation(this.template, start, (TemplateObject)block);
        return result;
    }

    public final IteratorBlock ForEach() throws ParseException {
        Token start = this.jj_consume_token(13);
        Token loopVar = this.jj_consume_token(133);
        this.jj_consume_token(130);
        Expression exp = this.Expression();
        this.jj_consume_token(139);
        ParserIteratorBlockContext iterCtx = this.pushIteratorBlockContext();
        iterCtx.loopVarName = loopVar.image;
        iterCtx.kind = 1;
        ++this.breakableDirectiveNesting;
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(39);
        --this.breakableDirectiveNesting;
        this.popIteratorBlockContext();
        IteratorBlock result = new IteratorBlock(exp, loopVar.image, block, true);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Items Items() throws ParseException {
        Token start = this.jj_consume_token(11);
        Token loopVar = this.jj_consume_token(133);
        this.jj_consume_token(139);
        ParserIteratorBlockContext iterCtx = this.peekIteratorBlockContext();
        if (iterCtx == null) {
            throw new ParseException("#items must be inside a #list block.", this.template, start);
        }
        if (iterCtx.loopVarName != null) {
            String msg = iterCtx.kind == 1 ? this.forEachDirectiveSymbol() + " doesn't support nested #items." : (iterCtx.kind == 2 ? "Can't nest #items into each other that belong to the same #list." : "The parent #list of the #items must not have \"as loopVar\" parameter.");
            throw new ParseException(msg, this.template, start);
        }
        iterCtx.kind = 2;
        iterCtx.loopVarName = loopVar.image;
        ++this.breakableDirectiveNesting;
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(35);
        --this.breakableDirectiveNesting;
        iterCtx.loopVarName = null;
        Items result = new Items(loopVar.image, block);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Sep Sep() throws ParseException {
        Token end = null;
        Token start = this.jj_consume_token(12);
        if (this.peekIteratorBlockContext() == null) {
            throw new ParseException("#sep must be inside a #list (or " + this.forEachDirectiveSymbol() + ") block.", this.template, start);
        }
        TemplateElement block = this.OptionalBlock();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                end = this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        Sep result = new Sep(block);
        if (end != null) {
            result.setLocation(this.template, start, end);
        } else {
            result.setLocation(this.template, start, (TemplateObject)block);
        }
        return result;
    }

    public final VisitNode Visit() throws ParseException {
        Expression namespaces = null;
        Token start = this.jj_consume_token(24);
        Expression targetNode = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 132: {
                this.jj_consume_token(132);
                namespaces = this.Expression();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        Token end = this.LooseDirectiveEnd();
        VisitNode result = new VisitNode(targetNode, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final RecurseNode Recurse() throws ParseException {
        Token start;
        Token end = null;
        Expression node = null;
        Expression namespaces = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                start = this.jj_consume_token(60);
                break;
            }
            case 61: {
                start = this.jj_consume_token(61);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 111: 
                    case 112: 
                    case 120: 
                    case 124: 
                    case 126: 
                    case 128: 
                    case 133: {
                        node = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 132: {
                        this.jj_consume_token(132);
                        namespaces = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (end == null) {
            end = start;
        }
        RecurseNode result = new RecurseNode(node, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final FallbackInstruction FallBack() throws ParseException {
        Token tok = this.jj_consume_token(62);
        if (!this.inMacro) {
            throw new ParseException("Cannot fall back outside a macro.", this.template, tok);
        }
        FallbackInstruction result = new FallbackInstruction();
        result.setLocation(this.template, tok, tok);
        return result;
    }

    public final BreakInstruction Break() throws ParseException {
        Token start = this.jj_consume_token(49);
        if (this.breakableDirectiveNesting < 1) {
            throw new ParseException(start.image + " must be nested inside a directive that supports it: " + " #list with \"as\", #items, #switch (or the deprecated " + this.forEachDirectiveSymbol() + ")", this.template, start);
        }
        BreakInstruction result = new BreakInstruction();
        result.setLocation(this.template, start, start);
        return result;
    }

    public final ReturnInstruction Return() throws ParseException {
        Token start;
        Token end = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                end = start = this.jj_consume_token(50);
                break;
            }
            case 26: {
                start = this.jj_consume_token(26);
                exp = this.Expression();
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro) {
            if (exp != null) {
                throw new ParseException("A macro cannot return a value", this.template, start);
            }
        } else if (this.inFunction) {
            if (exp == null) {
                throw new ParseException("A function must return a value", this.template, start);
            }
        } else if (exp == null) {
            throw new ParseException("A return instruction can only occur inside a macro or function", this.template, start);
        }
        ReturnInstruction result = new ReturnInstruction(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final StopInstruction Stop() throws ParseException {
        Token start = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                start = this.jj_consume_token(51);
                break;
            }
            case 25: {
                start = this.jj_consume_token(25);
                exp = this.Expression();
                this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        StopInstruction result = new StopInstruction(exp);
        result.setLocation(this.template, start, start);
        return result;
    }

    public final TemplateElement Nested() throws ParseException {
        Token t2;
        BodyInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                t2 = this.jj_consume_token(58);
                result = new BodyInstruction(null);
                result.setLocation(this.template, t2, t2);
                break;
            }
            case 59: {
                t2 = this.jj_consume_token(59);
                ArrayList bodyParameters = this.PositionalArgs();
                Token end = this.LooseDirectiveEnd();
                result = new BodyInstruction(bodyParameters);
                result.setLocation(this.template, t2, end);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.inMacro) {
            throw new ParseException("Cannot use a " + t2.image + " instruction outside a macro.", this.template, t2);
        }
        return result;
    }

    public final TemplateElement Flush() throws ParseException {
        Token t2 = this.jj_consume_token(52);
        FlushInstruction result = new FlushInstruction();
        result.setLocation(this.template, t2, t2);
        return result;
    }

    public final TemplateElement Trim() throws ParseException {
        Token t2;
        TrimInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                t2 = this.jj_consume_token(53);
                result = new TrimInstruction(true, true);
                break;
            }
            case 54: {
                t2 = this.jj_consume_token(54);
                result = new TrimInstruction(true, false);
                break;
            }
            case 55: {
                t2 = this.jj_consume_token(55);
                result = new TrimInstruction(false, true);
                break;
            }
            case 56: {
                t2 = this.jj_consume_token(56);
                result = new TrimInstruction(false, false);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.setLocation(this.template, t2, t2);
        return result;
    }

    public final TemplateElement Assign() throws ParseException {
        int scope;
        Token start;
        Token id = null;
        Expression nsExp = null;
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                start = this.jj_consume_token(16);
                scope = 1;
                break;
            }
            case 17: {
                start = this.jj_consume_token(17);
                scope = 3;
                break;
            }
            case 18: {
                start = this.jj_consume_token(18);
                scope = 2;
                scope = 2;
                if (this.inMacro || this.inFunction) break;
                throw new ParseException("Local variable assigned outside a macro.", this.template, start);
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression nameExp = this.IdentifierOrStringLiteral();
        String varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : ((Identifier)nameExp).getName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                Expression exp;
                Token equalsOp;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 97: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 97: {
                                this.jj_consume_token(97);
                                break;
                            }
                            case 100: {
                                this.jj_consume_token(100);
                                break;
                            }
                            case 101: {
                                this.jj_consume_token(101);
                                break;
                            }
                            case 102: {
                                this.jj_consume_token(102);
                                break;
                            }
                            case 103: {
                                this.jj_consume_token(103);
                                break;
                            }
                            case 104: {
                                this.jj_consume_token(104);
                                break;
                            }
                            default: {
                                this.jj_la1[39] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        equalsOp = this.token;
                        exp = this.Expression();
                        break;
                    }
                    case 105: 
                    case 106: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 105: {
                                this.jj_consume_token(105);
                                break;
                            }
                            case 106: {
                                this.jj_consume_token(106);
                                break;
                            }
                            default: {
                                this.jj_la1[40] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        equalsOp = this.token;
                        exp = null;
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Assignment ass = new Assignment(varName, equalsOp.kind, exp, scope);
                if (exp != null) {
                    ass.setLocation(this.template, (TemplateObject)nameExp, (TemplateObject)exp);
                } else {
                    ass.setLocation(this.template, (TemplateObject)nameExp, equalsOp);
                }
                assignments.add(ass);
                while (this.jj_2_10(Integer.MAX_VALUE)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 121: {
                            this.jj_consume_token(121);
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                        }
                    }
                    nameExp = this.IdentifierOrStringLiteral();
                    varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : ((Identifier)nameExp).getName();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 97: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 97: {
                                    this.jj_consume_token(97);
                                    break;
                                }
                                case 100: {
                                    this.jj_consume_token(100);
                                    break;
                                }
                                case 101: {
                                    this.jj_consume_token(101);
                                    break;
                                }
                                case 102: {
                                    this.jj_consume_token(102);
                                    break;
                                }
                                case 103: {
                                    this.jj_consume_token(103);
                                    break;
                                }
                                case 104: {
                                    this.jj_consume_token(104);
                                    break;
                                }
                                default: {
                                    this.jj_la1[43] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            equalsOp = this.token;
                            exp = this.Expression();
                            break;
                        }
                        case 105: 
                        case 106: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 105: {
                                    this.jj_consume_token(105);
                                    break;
                                }
                                case 106: {
                                    this.jj_consume_token(106);
                                    break;
                                }
                                default: {
                                    this.jj_la1[44] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            equalsOp = this.token;
                            exp = null;
                            break;
                        }
                        default: {
                            this.jj_la1[45] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    ass = new Assignment(varName, equalsOp.kind, exp, scope);
                    if (exp != null) {
                        ass.setLocation(this.template, (TemplateObject)nameExp, (TemplateObject)exp);
                    } else {
                        ass.setLocation(this.template, (TemplateObject)nameExp, equalsOp);
                    }
                    assignments.add(ass);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 130: {
                        id = this.jj_consume_token(130);
                        nsExp = this.Expression();
                        if (scope == 1) break;
                        throw new ParseException("Cannot assign to namespace here.", this.template, id);
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                Token end = this.LooseDirectiveEnd();
                if (assignments.size() == 1) {
                    Assignment a10 = (Assignment)assignments.get(0);
                    a10.setNamespaceExp(nsExp);
                    a10.setLocation(this.template, start, end);
                    return a10;
                }
                AssignmentInstruction ai2 = new AssignmentInstruction(scope);
                for (int i2 = 0; i2 < assignments.size(); ++i2) {
                    ai2.addAssignment((Assignment)assignments.get(i2));
                }
                ai2.setNamespaceExp(nsExp);
                ai2.setLocation(this.template, start, end);
                return ai2;
            }
            case 130: 
            case 139: {
                Token end;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 130: {
                        id = this.jj_consume_token(130);
                        nsExp = this.Expression();
                        if (scope == 1) break;
                        throw new ParseException("Cannot assign to namespace here.", this.template, id);
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                    }
                }
                this.jj_consume_token(139);
                TemplateElement block = this.OptionalBlock();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        end = this.jj_consume_token(40);
                        if (scope == 2) break;
                        throw new ParseException("Mismatched assignment tags.", this.template, end);
                    }
                    case 42: {
                        end = this.jj_consume_token(42);
                        if (scope == 1) break;
                        throw new ParseException("Mismatched assignment tags.", this.template, end);
                    }
                    case 41: {
                        end = this.jj_consume_token(41);
                        if (scope == 3) break;
                        throw new ParseException("Mismatched assignment tags", this.template, end);
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BlockAssignment ba2 = new BlockAssignment(block, varName, scope, nsExp);
                ba2.setLocation(this.template, start, end);
                return ba2;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Include Include() throws ParseException {
        Expression nameExp;
        Token start;
        Expression ignoreMissingExp;
        Expression encodingExp;
        Expression parseExp;
        block9: {
            String attString;
            Token att;
            parseExp = null;
            encodingExp = null;
            ignoreMissingExp = null;
            start = this.jj_consume_token(19);
            nameExp = this.Expression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 122: {
                    this.jj_consume_token(122);
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 133: {
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                        break block9;
                    }
                }
                att = this.jj_consume_token(133);
                this.jj_consume_token(97);
                Expression exp = this.Expression();
                attString = att.image;
                if (attString.equalsIgnoreCase("parse")) {
                    parseExp = exp;
                    continue;
                }
                if (attString.equalsIgnoreCase("encoding")) {
                    encodingExp = exp;
                    continue;
                }
                if (!attString.equalsIgnoreCase("ignore_missing") && !attString.equals("ignoreMissing")) break;
                this.token_source.checkNamingConvention(att);
                ignoreMissingExp = exp;
            }
            String correctedName = attString.equals("ignoreMissing") ? "ignore_missing" : null;
            throw new ParseException("Unsupported named #include parameter: \"" + attString + "\". Supported parameters are: " + "\"parse\", \"encoding\", \"ignore_missing\"." + (correctedName == null ? "" : " Supporting camelCase parameter names is planned for FreeMarker 2.4.0; check if an update is available, and if it indeed supports camel case."), this.template, att);
        }
        Token end = this.LooseDirectiveEnd();
        Include result = new Include(this.template, nameExp, encodingExp, parseExp, ignoreMissingExp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final LibraryLoad Import() throws ParseException {
        Token start = this.jj_consume_token(20);
        Expression nameExp = this.Expression();
        this.jj_consume_token(131);
        Token ns = this.jj_consume_token(133);
        Token end = this.LooseDirectiveEnd();
        LibraryLoad result = new LibraryLoad(this.template, nameExp, ns.image);
        result.setLocation(this.template, start, end);
        this.template.addImport(result);
        return result;
    }

    public final Macro Macro() throws ParseException {
        Token end;
        int lastBreakableDirectiveNesting;
        Token start;
        ArrayList<String> argNames = new ArrayList<String>();
        HashMap<String, Expression> args = new HashMap<String, Expression>();
        ArrayList<String> defNames = new ArrayList<String>();
        Expression defValue = null;
        boolean isFunction = false;
        boolean hasDefaults = false;
        boolean isCatchAll = false;
        String catchAll = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                start = this.jj_consume_token(22);
                break;
            }
            case 21: {
                start = this.jj_consume_token(21);
                isFunction = true;
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro || this.inFunction) {
            throw new ParseException("Macros cannot be nested.", this.template, start);
        }
        if (isFunction) {
            this.inFunction = true;
        } else {
            this.inMacro = true;
        }
        Expression nameExp = this.IdentifierOrStringLiteral();
        String name = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : ((Identifier)nameExp).getName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 133: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block26;
                }
            }
            Token arg = this.jj_consume_token(133);
            defValue = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 115: {
                    this.jj_consume_token(115);
                    isCatchAll = true;
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 97: {
                    this.jj_consume_token(97);
                    defValue = this.Expression();
                    defNames.add(arg.image);
                    hasDefaults = true;
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 121: {
                    this.jj_consume_token(121);
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                }
            }
            if (catchAll != null) {
                throw new ParseException("There may only be one \"catch-all\" parameter in a macro declaration, and it must be the last parameter.", this.template, arg);
            }
            if (isCatchAll) {
                if (defValue != null) {
                    throw new ParseException("\"Catch-all\" macro parameter may not have a default value.", this.template, arg);
                }
                catchAll = arg.image;
                continue;
            }
            argNames.add(arg.image);
            if (hasDefaults && defValue == null) {
                throw new ParseException("In a macro declaration, parameters without a default value must all occur before the parameters with default values.", this.template, arg);
            }
            args.put(arg.image, defValue);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 127: {
                this.jj_consume_token(127);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        List lastIteratorBlockContexts = this.iteratorBlockContexts;
        this.iteratorBlockContexts = null;
        if (this.incompatibleImprovements >= _TemplateAPI.VERSION_INT_2_3_23) {
            lastBreakableDirectiveNesting = this.breakableDirectiveNesting;
            this.breakableDirectiveNesting = 0;
        } else {
            lastBreakableDirectiveNesting = 0;
        }
        TemplateElement block = this.OptionalBlock();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                end = this.jj_consume_token(44);
                if (!isFunction) break;
                throw new ParseException("Expected function end tag here.", this.template, start);
            }
            case 43: {
                end = this.jj_consume_token(43);
                if (isFunction) break;
                throw new ParseException("Expected macro end tag here.", this.template, start);
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.iteratorBlockContexts = lastIteratorBlockContexts;
        if (this.incompatibleImprovements >= _TemplateAPI.VERSION_INT_2_3_23) {
            this.breakableDirectiveNesting = lastBreakableDirectiveNesting;
        }
        this.inFunction = false;
        this.inMacro = false;
        Macro result = new Macro(name, argNames, args, catchAll, isFunction, block);
        result.setLocation(this.template, start, end);
        this.template.addMacro(result);
        return result;
    }

    public final CompressedBlock Compress() throws ParseException {
        Token start = this.jj_consume_token(29);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(45);
        CompressedBlock cb = new CompressedBlock(block);
        cb.setLocation(this.template, start, end);
        return cb;
    }

    public final TemplateElement UnifiedMacroTransform() throws ParseException {
        Token end;
        Token start = null;
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        ArrayList<String> bodyParameters = null;
        TemplateElement nestedBlock = null;
        int pushedCtxCount = 0;
        start = this.jj_consume_token(67);
        Expression exp = this.Expression();
        Expression startTagNameExp = exp instanceof Identifier || exp instanceof Dot && ((Dot)exp).onlyHasIdentifiers() ? exp : null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        if (this.jj_2_11(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            positionalArgs = this.PositionalArgs();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                bodyParameters = new ArrayList<String>(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 133: 
                    case 143: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 143: {
                                this.jj_consume_token(143);
                                break;
                            }
                            default: {
                                this.jj_la1[61] = this.jj_gen;
                            }
                        }
                        Token t2 = this.jj_consume_token(133);
                        bodyParameters.add(t2.image);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 121: 
                                case 143: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[62] = this.jj_gen;
                                    break block3;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 143: {
                                    this.jj_consume_token(143);
                                    break;
                                }
                                default: {
                                    this.jj_la1[63] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(121);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 143: {
                                    this.jj_consume_token(143);
                                    break;
                                }
                                default: {
                                    this.jj_la1[64] = this.jj_gen;
                                }
                            }
                            t2 = this.jj_consume_token(133);
                            bodyParameters.add(t2.image);
                        }
                    }
                }
                this.jj_la1[65] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 140: {
                end = this.jj_consume_token(140);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                if (bodyParameters != null && this.iteratorBlockContexts != null && !this.iteratorBlockContexts.isEmpty()) {
                    int ctxsLen = this.iteratorBlockContexts.size();
                    int bodyParsLen = bodyParameters.size();
                    block26: for (int bodyParIdx = 0; bodyParIdx < bodyParsLen; ++bodyParIdx) {
                        String bodyParName = (String)bodyParameters.get(bodyParIdx);
                        for (int ctxIdx = ctxsLen - 1; ctxIdx >= 0; --ctxIdx) {
                            ParserIteratorBlockContext ctx = (ParserIteratorBlockContext)this.iteratorBlockContexts.get(ctxIdx);
                            if (ctx.loopVarName == null || !ctx.loopVarName.equals(bodyParName)) continue;
                            if (ctx.kind == 3) continue block26;
                            ParserIteratorBlockContext shadowingCtx = this.pushIteratorBlockContext();
                            shadowingCtx.loopVarName = bodyParName;
                            shadowingCtx.kind = 3;
                            ++pushedCtxCount;
                            continue block26;
                        }
                    }
                }
                nestedBlock = this.OptionalBlock();
                end = this.jj_consume_token(68);
                for (int i2 = 0; i2 < pushedCtxCount; ++i2) {
                    this.popIteratorBlockContext();
                }
                String endTagName = end.image.substring(3, end.image.length() - 1).trim();
                if (endTagName.length() <= 0) break;
                if (startTagNameExp == null) {
                    throw new ParseException("Expecting </@>", this.template, end);
                }
                String startTagName = startTagNameExp.getCanonicalForm();
                if (endTagName.equals(startTagName)) break;
                throw new ParseException("Expecting </@> or </@" + startTagName + ">", this.template, end);
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        UnifiedCall result = positionalArgs != null ? new UnifiedCall(exp, positionalArgs, nestedBlock, bodyParameters) : new UnifiedCall(exp, namedArgs, nestedBlock, bodyParameters);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TemplateElement Call() throws ParseException {
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        String macroName = null;
        Token start = this.jj_consume_token(27);
        Token id = this.jj_consume_token(133);
        macroName = id.image;
        if (this.jj_2_13(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            if (this.jj_2_12(Integer.MAX_VALUE)) {
                this.jj_consume_token(126);
            }
            positionalArgs = this.PositionalArgs();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 127: {
                    this.jj_consume_token(127);
                    break;
                }
                default: {
                    this.jj_la1[68] = this.jj_gen;
                }
            }
        }
        Token end = this.LooseDirectiveEnd();
        UnifiedCall result = null;
        result = positionalArgs != null ? new UnifiedCall((Expression)new Identifier(macroName), positionalArgs, null, null) : new UnifiedCall((Expression)new Identifier(macroName), namedArgs, null, null);
        result.legacySyntax = true;
        result.setLocation(this.template, start, end);
        return result;
    }

    public final HashMap NamedArgs() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block3: while (true) {
            Token t2 = this.jj_consume_token(133);
            this.jj_consume_token(97);
            this.token_source.SwitchTo(4);
            this.token_source.inInvocation = true;
            Expression exp = this.Expression();
            result.put(t2.image, exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 133: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[69] = this.jj_gen;
        this.token_source.inInvocation = false;
        return result;
    }

    public final ArrayList PositionalArgs() throws ParseException {
        ArrayList<Expression> result = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 111: 
            case 112: 
            case 120: 
            case 124: 
            case 126: 
            case 128: 
            case 133: {
                Expression arg = this.Expression();
                result.add(arg);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 111: 
                        case 112: 
                        case 120: 
                        case 121: 
                        case 124: 
                        case 126: 
                        case 128: 
                        case 133: {
                            break;
                        }
                        default: {
                            this.jj_la1[70] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 121: {
                            this.jj_consume_token(121);
                            break;
                        }
                        default: {
                            this.jj_la1[71] = this.jj_gen;
                        }
                    }
                    arg = this.Expression();
                    result.add(arg);
                }
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
            }
        }
        return result;
    }

    public final Comment Comment() throws ParseException {
        Token start;
        StringBuffer buf = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                start = this.jj_consume_token(30);
                break;
            }
            case 31: {
                start = this.jj_consume_token(31);
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token end = this.UnparsedContent(start, buf);
        Comment result = new Comment(buf.toString());
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TextBlock NoParse() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token start = this.jj_consume_token(32);
        Token end = this.UnparsedContent(start, buf);
        TextBlock result = new TextBlock(buf.toString(), true);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TransformBlock Transform() throws ParseException {
        Token end;
        TemplateElement content = null;
        HashMap<String, Expression> args = null;
        Token start = this.jj_consume_token(23);
        Expression exp = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 133: {
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    break block10;
                }
            }
            Token argName = this.jj_consume_token(133);
            this.jj_consume_token(97);
            Expression argExp = this.Expression();
            if (args == null) {
                args = new HashMap<String, Expression>();
            }
            args.put(argName.image, argExp);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 140: {
                end = this.jj_consume_token(140);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                content = this.OptionalBlock();
                end = this.jj_consume_token(46);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TransformBlock result = new TransformBlock(exp, args, content);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final SwitchBlock Switch() throws ParseException {
        boolean defaultFound = false;
        Token start = this.jj_consume_token(14);
        Expression switchExp = this.Expression();
        this.jj_consume_token(139);
        ++this.breakableDirectiveNesting;
        SwitchBlock switchBlock = new SwitchBlock(switchExp);
        while (this.jj_2_14(2)) {
            Case caseIns = this.Case();
            if (caseIns.condition == null) {
                if (defaultFound) {
                    throw new ParseException("You can only have one default case in a switch statement", this.template, start);
                }
                defaultFound = true;
            }
            switchBlock.addCase(caseIns);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(47);
        --this.breakableDirectiveNesting;
        switchBlock.setLocation(this.template, start, end);
        return switchBlock;
    }

    public final Case Case() throws ParseException {
        Expression exp;
        Token start;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                start = this.jj_consume_token(15);
                exp = this.Expression();
                this.jj_consume_token(139);
                break;
            }
            case 57: {
                start = this.jj_consume_token(57);
                exp = null;
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TemplateElement block = this.OptionalBlock();
        Case result = new Case(exp, block);
        result.setLocation(this.template, start, (TemplateObject)block);
        return result;
    }

    public final EscapeBlock Escape() throws ParseException {
        Token start = this.jj_consume_token(63);
        Token variable = this.jj_consume_token(133);
        this.jj_consume_token(131);
        Expression escapeExpr = this.Expression();
        this.jj_consume_token(139);
        EscapeBlock result = new EscapeBlock(variable.image, escapeExpr, this.escapedExpression(escapeExpr));
        this.escapes.addFirst(result);
        TemplateElement content = this.OptionalBlock();
        result.setContent(content);
        this.escapes.removeFirst();
        Token end = this.jj_consume_token(64);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final NoEscapeBlock NoEscape() throws ParseException {
        Token start = this.jj_consume_token(65);
        if (this.escapes.isEmpty()) {
            throw new ParseException("#noescape with no matching #escape encountered.", this.template, start);
        }
        Object escape = this.escapes.removeFirst();
        TemplateElement content = this.OptionalBlock();
        Token end = this.jj_consume_token(66);
        this.escapes.addFirst(escape);
        NoEscapeBlock result = new NoEscapeBlock(content);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Token LooseDirectiveEnd() throws ParseException {
        Token t2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 139: {
                t2 = this.jj_consume_token(139);
                break;
            }
            case 140: {
                t2 = this.jj_consume_token(140);
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t2;
    }

    public final PropertySetting Setting() throws ParseException {
        Token start = this.jj_consume_token(28);
        Token key = this.jj_consume_token(133);
        this.jj_consume_token(97);
        Expression value = this.Expression();
        Token end = this.LooseDirectiveEnd();
        this.token_source.checkNamingConvention(key);
        PropertySetting result = new PropertySetting(key, this.token_source, value, this.template.getConfiguration());
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TemplateElement FreemarkerDirective() throws ParseException {
        TemplateElement tp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                tp = this.If();
                break;
            }
            case 10: {
                tp = this.List();
                break;
            }
            case 13: {
                tp = this.ForEach();
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                tp = this.Assign();
                break;
            }
            case 19: {
                tp = this.Include();
                break;
            }
            case 20: {
                tp = this.Import();
                break;
            }
            case 21: 
            case 22: {
                tp = this.Macro();
                break;
            }
            case 29: {
                tp = this.Compress();
                break;
            }
            case 67: {
                tp = this.UnifiedMacroTransform();
                break;
            }
            case 11: {
                tp = this.Items();
                break;
            }
            case 12: {
                tp = this.Sep();
                break;
            }
            case 27: {
                tp = this.Call();
                break;
            }
            case 30: 
            case 31: {
                tp = this.Comment();
                break;
            }
            case 32: {
                tp = this.NoParse();
                break;
            }
            case 23: {
                tp = this.Transform();
                break;
            }
            case 14: {
                tp = this.Switch();
                break;
            }
            case 28: {
                tp = this.Setting();
                break;
            }
            case 49: {
                tp = this.Break();
                break;
            }
            case 26: 
            case 50: {
                tp = this.Return();
                break;
            }
            case 25: 
            case 51: {
                tp = this.Stop();
                break;
            }
            case 52: {
                tp = this.Flush();
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                tp = this.Trim();
                break;
            }
            case 58: 
            case 59: {
                tp = this.Nested();
                break;
            }
            case 63: {
                tp = this.Escape();
                break;
            }
            case 65: {
                tp = this.NoEscape();
                break;
            }
            case 24: {
                tp = this.Visit();
                break;
            }
            case 60: 
            case 61: {
                tp = this.Recurse();
                break;
            }
            case 62: {
                tp = this.FallBack();
                break;
            }
            case 6: {
                tp = this.Attempt();
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tp;
    }

    public final TextBlock PCData() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token t2 = null;
        Token start = null;
        Token prevToken = null;
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    prevToken = t2;
                    t2 = this.jj_consume_token(72);
                    break;
                }
                case 73: {
                    t2 = this.jj_consume_token(73);
                    break;
                }
                case 74: {
                    t2 = this.jj_consume_token(74);
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(t2.image);
            if (start == null) {
                start = t2;
            }
            if (prevToken == null) continue;
            prevToken.next = null;
        } while (this.jj_2_15(Integer.MAX_VALUE));
        if (this.stripText && this.mixedContentNesting == 1) {
            return TextBlock.EMPTY_BLOCK;
        }
        TextBlock result = new TextBlock(buf.toString(), false);
        result.setLocation(this.template, start, t2);
        return result;
    }

    public final Token UnparsedContent(Token start, StringBuffer buf) throws ParseException {
        Token t2;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 147: {
                    t2 = this.jj_consume_token(147);
                    break;
                }
                case 146: {
                    t2 = this.jj_consume_token(146);
                    break;
                }
                case 145: {
                    t2 = this.jj_consume_token(145);
                    break;
                }
                case 148: {
                    t2 = this.jj_consume_token(148);
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(t2.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 145: 
                case 146: 
                case 147: 
                case 148: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[84] = this.jj_gen;
        buf.setLength(buf.length() - t2.image.length());
        if (!t2.image.endsWith(";") && _TemplateAPI.getTemplateLanguageVersionAsInt(this.template) >= _TemplateAPI.VERSION_INT_2_3_21) {
            throw new ParseException("Unclosed \"" + start.image + "\"", this.template, start);
        }
        return t2;
    }

    public final MixedContent MixedContent() throws ParseException {
        TemplateElement elem;
        MixedContent mixedContent = new MixedContent();
        TemplateElement begin = null;
        ++this.mixedContentNesting;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: 
                case 73: 
                case 74: {
                    elem = this.PCData();
                    break;
                }
                case 75: {
                    elem = this.StringOutput();
                    break;
                }
                case 76: {
                    elem = this.NumericalOutput();
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 67: {
                    elem = this.FreemarkerDirective();
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = elem;
            }
            mixedContent.addElement(elem);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 67: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[86] = this.jj_gen;
        --this.mixedContentNesting;
        mixedContent.setLocation(this.template, (TemplateObject)begin, (TemplateObject)elem);
        return mixedContent;
    }

    public final TemplateElement FreeMarkerText() throws ParseException {
        TemplateElement elem;
        MixedContent nodes = new MixedContent();
        TemplateElement begin = null;
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: 
                case 73: 
                case 74: {
                    elem = this.PCData();
                    break;
                }
                case 75: {
                    elem = this.StringOutput();
                    break;
                }
                case 76: {
                    elem = this.NumericalOutput();
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = elem;
            }
            nodes.addElement(elem);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[88] = this.jj_gen;
        nodes.setLocation(this.template, (TemplateObject)begin, (TemplateObject)elem);
        return nodes;
    }

    public final TemplateElement OptionalBlock() throws ParseException {
        TemplateElement tp = TextBlock.EMPTY_BLOCK;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 67: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                tp = this.MixedContent();
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
        return tp;
    }

    /*
     * Unable to fully structure code
     */
    public final void HeaderElement() throws ParseException {
        exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[90] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                block20: while (true) lbl-1000:
                // 10 sources

                {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 133: {
                            break;
                        }
                        default: {
                            this.jj_la1[91] = this.jj_gen;
                            ** GOTO lbl98
                        }
                    }
                    key = this.jj_consume_token(133);
                    this.jj_consume_token(97);
                    exp = this.Expression();
                    this.token_source.checkNamingConvention(key);
                    ks = key.image;
                    value = null;
                    try {
                        value = exp.eval(null);
                    }
                    catch (Exception e) {
                        throw new ParseException("Could not evaluate expression: " + exp.getCanonicalForm() + " \nUnderlying cause: " + e.getMessage(), exp, e);
                    }
                    vs = null;
                    if (value instanceof TemplateScalarModel) {
                        try {
                            vs = ((TemplateScalarModel)exp).getAsString();
                        }
                        catch (TemplateModelException tme) {
                            // empty catch block
                        }
                    }
                    if (this.template == null) continue;
                    if (ks.equalsIgnoreCase("encoding")) {
                        if (vs == null) {
                            throw new ParseException("Expecting an encoding string.", exp);
                        }
                        encoding = this.template.getEncoding();
                        if (encoding == null || encoding.equalsIgnoreCase(vs)) continue;
                        throw new Template.WrongEncodingException(vs, encoding);
                    }
                    if (ks.equalsIgnoreCase("STRIP_WHITESPACE") || ks.equals("stripWhitespace")) {
                        this.stripWhitespace = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("STRIP_TEXT") || ks.equals("stripText")) {
                        this.stripText = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("STRICT_SYNTAX") || ks.equals("strictSyntax")) {
                        this.token_source.strictEscapeSyntax = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("ns_prefixes") || ks.equals("nsPrefixes")) {
                        if (!(value instanceof TemplateHashModelEx)) {
                            throw new ParseException("Expecting a hash of prefixes to namespace URI's.", exp);
                        }
                        prefixMap = (TemplateHashModelEx)value;
                        try {
                            keys = prefixMap.keys();
                            it = keys.iterator();
                            while (true) lbl-1000:
                            // 2 sources

                            {
                                if (!it.hasNext()) ** GOTO lbl-1000
                                prefix = ((TemplateScalarModel)it.next()).getAsString();
                                valueModel = prefixMap.get(prefix);
                                if (!(valueModel instanceof TemplateScalarModel)) {
                                    throw new ParseException("Non-string value in prefix to namespace hash.", exp);
                                }
                                nsURI = ((TemplateScalarModel)valueModel).getAsString();
                                try {
                                    this.template.addPrefixNSMapping(prefix, nsURI);
                                    continue;
                                }
                                catch (IllegalArgumentException iae) {
                                    throw new ParseException(iae.getMessage(), exp);
                                }
                                break;
                            }
                        }
                        catch (TemplateModelException tme) {}
                        {
                            ** while (true)
                        }
                        continue;
                    }
                    if (!ks.equalsIgnoreCase("attributes")) break;
                    if (!(value instanceof TemplateHashModelEx)) {
                        throw new ParseException("Expecting a hash of attribute names to values.", exp);
                    }
                    attributeMap = (TemplateHashModelEx)value;
                    try {
                        keys = attributeMap.keys();
                        it = keys.iterator();
                        while (true) {
                            if (!it.hasNext()) continue block20;
                            attName = ((TemplateScalarModel)it.next()).getAsString();
                            attValue = DeepUnwrap.unwrap(attributeMap.get(attName));
                            this.template.setCustomAttribute(attName, attValue);
                        }
                    }
                    catch (TemplateModelException tme) {
                        continue;
                    }
                    break;
                }
                correctName = ks.equals("charset") != false ? "encoding" : (ks.equals("xmlns") != false ? (this.token_source.namingConvention == 12 ? "nsPrefixes" : "ns_prefixes") : null);
                throw new ParseException("Unknown FTL header parameter: " + key.image + (correctName == null ? "" : ". Did you mean " + correctName + "?"), this.template, key);
lbl98:
                // 1 sources

                this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Map ParamList() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block6: while (true) {
            Identifier id = this.Identifier();
            this.jj_consume_token(97);
            Expression exp = this.Expression();
            result.put(id.toString(), exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 121: {
                    this.jj_consume_token(121);
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 133: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[94] = this.jj_gen;
        return result;
    }

    public final TemplateElement Root() throws ParseException {
        if (this.jj_2_16(Integer.MAX_VALUE)) {
            this.HeaderElement();
        }
        TemplateElement doc = this.OptionalBlock();
        this.jj_consume_token(0);
        doc.setFieldsForRootElement();
        doc = doc.postParseCleanup(this.stripWhitespace);
        doc.setFieldsForRootElement();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_1();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_2();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_3();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_4();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_5();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_6();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_7();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_8();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_9();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_10();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_11();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_12();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_13();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_14();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_15();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl2 = !this.jj_3_16();
            return bl2;
        }
        catch (LookaheadSuccess ls) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    private final boolean jj_3R_174() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_42() {
        return this.jj_scan_token(113);
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(113)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(116)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(117)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_105() {
        return this.jj_3R_146();
    }

    private final boolean jj_3R_173() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3_11() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_scan_token(97);
    }

    private final boolean jj_3R_104() {
        return this.jj_3R_145();
    }

    private final boolean jj_3R_103() {
        return this.jj_3R_144();
    }

    private final boolean jj_3R_102() {
        return this.jj_3R_143();
    }

    private final boolean jj_3R_143() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_174()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_175()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_101() {
        return this.jj_3R_142();
    }

    private final boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_44()) {
                    return true;
                }
            }
        }
        return this.jj_3R_32();
    }

    private final boolean jj_3R_100() {
        return this.jj_3R_141();
    }

    private final boolean jj_3R_99() {
        return this.jj_3R_140();
    }

    private final boolean jj_3R_141() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_171() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_3R_89()) {
            return true;
        }
        return this.jj_scan_token(127);
    }

    private final boolean jj_3R_26() {
        Token xsp;
        if (this.jj_3R_32()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_33());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_99()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_100()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_101()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_102()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_103()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_104()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_105()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_106()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_107()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_108()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_109()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_110()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_111()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_112()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_113()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_114()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_115()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_116()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_117()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_118()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_119()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_120()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_121()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_122()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_123()) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_3R_124()) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_3R_125()) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_3R_126()) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_3R_127()) {
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_183() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_182() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_148() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3R_181() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_180() {
        return this.jj_scan_token(53);
    }

    private final boolean jj_3R_161() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_180()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_181()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_182()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_183()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_35() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(70)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(69)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_34() {
        return this.jj_scan_token(111);
    }

    private final boolean jj_3R_156() {
        return this.jj_scan_token(28);
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(111)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(112)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_133() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_scan_token(133)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_171()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_147() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_160() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_35()) {
                return true;
            }
        }
        return this.jj_3R_26();
    }

    private final boolean jj_3R_168() {
        return this.jj_scan_token(6);
    }

    private final boolean jj_3R_23() {
        Token xsp;
        if (this.jj_3R_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_27());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_9() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_135() {
        return this.jj_scan_token(96);
    }

    private final boolean jj_3R_185() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_54() {
        return this.jj_scan_token(112);
    }

    private final boolean jj_3R_187() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(111)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                return true;
            }
        }
        return this.jj_3R_50();
    }

    private final boolean jj_3R_184() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_164() {
        return this.jj_scan_token(65);
    }

    private final boolean jj_3R_162() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_184()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_185()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_172() {
        if (this.jj_scan_token(120)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_187()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(144)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_172()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_55() {
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_179() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_140() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_49() {
        Token xsp;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_55());
        this.jj_scanpos = xsp;
        return this.jj_3R_50();
    }

    private final boolean jj_3R_95() {
        return this.jj_3R_135();
    }

    private final boolean jj_3R_159() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(51)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_179()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_94() {
        return this.jj_3R_134();
    }

    private final boolean jj_3R_93() {
        return this.jj_3R_133();
    }

    private final boolean jj_3R_92() {
        return this.jj_3R_132();
    }

    private final boolean jj_3R_91() {
        return this.jj_3R_131();
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_50();
    }

    private final boolean jj_3R_163() {
        return this.jj_scan_token(63);
    }

    private final boolean jj_3R_90() {
        return this.jj_3R_130();
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_92()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_93()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_94()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_95()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_41()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_30() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_178() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_177() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_30()) {
                return true;
            }
        }
        return this.jj_3R_31();
    }

    private final boolean jj_3R_158() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_177()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_178()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_scan_token(133);
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_scan_token(127);
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(91)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(124)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(126)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(95)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(120)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(144)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(96)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_176() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_64() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_146() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(22)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_176()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_77();
    }

    private final boolean jj_3_14() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_157() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_61() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_60() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_76() {
        return this.jj_scan_token(133);
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_155() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_58()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_59()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_60()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_61()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_62()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_63()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_64());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_167() {
        return this.jj_scan_token(62);
    }

    private final boolean jj_3R_83() {
        return this.jj_scan_token(76);
    }

    private final boolean jj_3R_145() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(89)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(90)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_24() {
        return this.jj_3R_28();
    }

    private final boolean jj_3R_186() {
        return this.jj_scan_token(61);
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        if (this.jj_3R_89()) {
            return true;
        }
        return this.jj_scan_token(125);
    }

    private final boolean jj_3R_82() {
        return this.jj_scan_token(75);
    }

    private final boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_166() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(60)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_186()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_154() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3_8() {
        return this.jj_scan_token(119);
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(119)) {
            return true;
        }
        return this.jj_3R_36();
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(121)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(121)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(123)) {
                return true;
            }
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_153() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_28() {
        Token xsp;
        if (this.jj_3R_36()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_165() {
        return this.jj_scan_token(24);
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3_7() {
        return this.jj_scan_token(118);
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_24()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(121)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(123)) {
                return true;
            }
        }
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_128());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(128)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(129);
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(118)) {
            return true;
        }
        return this.jj_3R_45();
    }

    private final boolean jj_3R_152() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_36() {
        Token xsp;
        if (this.jj_3R_45()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_46());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_169() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(121)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_88() {
        return this.jj_scan_token(88);
    }

    private final boolean jj_3R_70() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_87() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_69() {
        return this.jj_3R_83();
    }

    private final boolean jj_3R_150() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_6() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_129() {
        Token xsp;
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_169());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_68() {
        return this.jj_3R_82();
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_81();
    }

    private final boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_88()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_129()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_69()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_70()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_138() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_47() {
        Token xsp;
        if (this.jj_3R_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_53());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_137() {
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_136() {
        return this.jj_scan_token(93);
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_138()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_137()) {
                return true;
            }
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_86() {
        return this.jj_scan_token(86);
    }

    private final boolean jj_3R_80() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_97()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(85)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_86()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_12() {
        return this.jj_scan_token(126);
    }

    private final boolean jj_3R_65() {
        if (this.jj_3R_23()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_149() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3_13() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_scan_token(97);
    }

    private final boolean jj_3R_132() {
        if (this.jj_scan_token(126)) {
            return true;
        }
        if (this.jj_3R_89()) {
            return true;
        }
        return this.jj_scan_token(127);
    }

    private final boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(72)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(73)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(74)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_139() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_151() {
        return this.jj_scan_token(27);
    }

    private final boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(142)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(110)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(141)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(109)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(108)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(108)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(107)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(73)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(74)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(121)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(133)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(85)) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(97)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(100)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(101)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(102)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(103)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(104)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(105)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(106)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_81() {
        Token xsp;
        if (this.jj_3R_98()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_98());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(142)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(110)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(141)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(109)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(108)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(107)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_65();
    }

    private final boolean jj_3R_131() {
        if (this.jj_scan_token(124)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_scan_token(125);
    }

    private final boolean jj_3R_51() {
        if (this.jj_3R_65()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_127() {
        return this.jj_3R_168();
    }

    private final boolean jj_3R_126() {
        return this.jj_3R_167();
    }

    private final boolean jj_3R_125() {
        return this.jj_3R_166();
    }

    private final boolean jj_3R_124() {
        return this.jj_3R_165();
    }

    private final boolean jj_3R_123() {
        return this.jj_3R_164();
    }

    private final boolean jj_3R_122() {
        return this.jj_3R_163();
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(99)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(98)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_121() {
        return this.jj_3R_162();
    }

    private final boolean jj_3R_120() {
        return this.jj_3R_161();
    }

    private final boolean jj_3R_119() {
        return this.jj_3R_160();
    }

    private final boolean jj_3R_118() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_117() {
        return this.jj_3R_158();
    }

    private final boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(99)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(98)) {
                    return true;
                }
            }
        }
        return this.jj_3R_51();
    }

    private final boolean jj_3R_116() {
        return this.jj_3R_157();
    }

    private final boolean jj_3R_115() {
        return this.jj_3R_156();
    }

    private final boolean jj_3R_114() {
        return this.jj_3R_155();
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_51()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_170() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(107)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(108)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(109)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(110)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(87)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(88)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(130)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(131)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(132)) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_113() {
        return this.jj_3R_154();
    }

    private final boolean jj_3R_112() {
        return this.jj_3R_153();
    }

    private final boolean jj_3R_111() {
        return this.jj_3R_152();
    }

    private final boolean jj_3R_110() {
        return this.jj_3R_151();
    }

    private final boolean jj_3R_130() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(133)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(113)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(114)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_170()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_109() {
        return this.jj_3R_150();
    }

    private final boolean jj_3R_108() {
        return this.jj_3R_149();
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(117);
    }

    private final boolean jj_3R_107() {
        return this.jj_3R_148();
    }

    private final boolean jj_3R_175() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(116);
    }

    private final boolean jj_3R_106() {
        return this.jj_3R_147();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x2000000, 0, 0, 458752, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x600000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1073741824, 0, 0, 0, 0, 0, 32768, 0, -33472, 0, 0, 0, -33472, -33472, 0, 0, -33472, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 96, 0, 65536, 16, 0, 0, 0, 0x30000000, 262144, 524288, 0xC000000, 0x1E00000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1792, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, -33685503, 0, 0, 0, -33685503, -33685503, 0, 0, -33685503, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0xFE00000, 0xFE00000, 0, 0, 0, 0, 0, 0, 0x60000000, 0x70000000, 0x70000000, 0x6000000, 0x600000, -2013265920, 0, 0x1800000, 0x1800000, 0x600000, 0x1800000, 0, 0, 0, 0xFE00000, 0, 0, 0, 0, 0, 0, 0, 0, 0xFE00000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xFE00000, 0, 0xFE00000, 0, 0, 0, 0, 256, 256, 0, 0, 10, 1792, 0, 0, 7946, 7946, 7936, 7936, 7946, 256, 0, 96, 0, 0};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{0x50000000, 1359052800, 0x1000000, 98304, 98304, 0x320000, 14, 30720, 0, 0, 0, 0, 0, 0x51000001, 0x1000000, 30720, 423936, 0, 0, 0xA000000, 0x2000000, 0xA000000, 1359052800, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 1359052800, 0, 0, 0, 0, 0, 0, 0, 498, 1536, 2034, 0x2000000, 498, 1536, 2034, 0, 0, 0, 2034, 0x4000000, 0, 0, 0x40000000, 0, 524288, 2, 0x2000000, Integer.MIN_VALUE, 0, 0, 0, 0x2000000, 0, 0, 0, 0x4000000, 0, Integer.MIN_VALUE, 0, 1392607232, 0x2000000, 1359052800, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{33, 33, 0, 0, 0, 0, 0, 24576, 0, 0, 0, 0, 32, 65536, 65536, 28, 60, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 8, 0, 0, 16, 33, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 2052, 0, 32, 0, 0, 32, 0, 0, 0, 0, 0, 32768, 32768, 32768, 32768, 32768, 32800, 0, 6144, 0, 32, 33, 0, 33, 0, 0, 32, 6144, 0, 0, 0, 6144, 0, 0, 0x1E0000, 0x1E0000, 0, 0, 0, 0, 0, 0, 32, 0, 0, 32};
    }

    public FMParser(InputStream stream) {
        int i2;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 95; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i2;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 95; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public FMParser(Reader stream) {
        int i2;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 95; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i2;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 95; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public FMParser(FMParserTokenManager tm) {
        int i2;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 95; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public void ReInit(FMParserTokenManager tm) {
        int i2;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 95; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
                    JJCalls c2 = this.jj_2_rtns[i2];
                    while (c2 != null) {
                        if (c2.gen < this.jj_gen) {
                            c2.first = null;
                        }
                        c2 = c2.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i2 = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i2;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i2);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t2 = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i2 = 0; i2 < index; ++i2) {
            t2 = t2.next != null ? t2.next : (t2.next = this.token_source.getNextToken());
        }
        return t2;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i2 = 0; i2 < this.jj_endpos; ++i2) {
                this.jj_expentry[i2] = this.jj_lasttokens[i2];
            }
            boolean exists = false;
            Enumeration e2 = this.jj_expentries.elements();
            while (e2.hasMoreElements()) {
                int[] oldentry = (int[])e2.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i3 = 0; i3 < this.jj_expentry.length; ++i3) {
                    if (oldentry[i3] == this.jj_expentry[i3]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i2;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[149];
        for (i2 = 0; i2 < 149; ++i2) {
            la1tokens[i2] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i2 = 0; i2 < 95; ++i2) {
            if (this.jj_la1[i2] != this.jj_gen) continue;
            for (int j2 = 0; j2 < 32; ++j2) {
                if ((jj_la1_0[i2] & 1 << j2) != 0) {
                    la1tokens[j2] = true;
                }
                if ((jj_la1_1[i2] & 1 << j2) != 0) {
                    la1tokens[32 + j2] = true;
                }
                if ((jj_la1_2[i2] & 1 << j2) != 0) {
                    la1tokens[64 + j2] = true;
                }
                if ((jj_la1_3[i2] & 1 << j2) != 0) {
                    la1tokens[96 + j2] = true;
                }
                if ((jj_la1_4[i2] & 1 << j2) == 0) continue;
                la1tokens[128 + j2] = true;
            }
        }
        for (i2 = 0; i2 < 149; ++i2) {
            if (!la1tokens[i2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i3 = 0; i3 < this.jj_expentries.size(); ++i3) {
            exptokseq[i3] = (int[])this.jj_expentries.elementAt(i3);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i2 = 0; i2 < 16; ++i2) {
            JJCalls p2 = this.jj_2_rtns[i2];
            do {
                if (p2.gen <= this.jj_gen) continue;
                this.jj_la = p2.arg;
                this.jj_lastpos = this.jj_scanpos = p2.first;
                switch (i2) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                        break;
                    }
                    case 15: {
                        this.jj_3_16();
                    }
                }
            } while ((p2 = p2.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p2 = this.jj_2_rtns[index];
        while (p2.gen > this.jj_gen) {
            if (p2.next == null) {
                p2 = p2.next = new JJCalls();
                break;
            }
            p2 = p2.next;
        }
        p2.gen = this.jj_gen + xla - this.jj_la;
        p2.first = this.token;
        p2.arg = xla;
    }

    static {
        FMParser.jj_la1_0();
        FMParser.jj_la1_1();
        FMParser.jj_la1_2();
        FMParser.jj_la1_3();
        FMParser.jj_la1_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static class ParserIteratorBlockContext {
        private String loopVarName;
        private int kind;

        private ParserIteratorBlockContext() {
        }
    }
}

