/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.InvalidReferenceException;
import freemarker.core.NonBooleanException;
import freemarker.core.NonNumericalException;
import freemarker.core.ParseException;
import freemarker.core.TemplateObject;
import freemarker.ext.beans.BeanModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;

public abstract class Expression
extends TemplateObject {
    TemplateModel constantValue;

    abstract TemplateModel _eval(Environment var1) throws TemplateException;

    abstract boolean isLiteral();

    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        super.setLocation(template, beginColumn, beginLine, endColumn, endLine);
        if (this.isLiteral()) {
            try {
                this.constantValue = this._eval(null);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public final TemplateModel getAsTemplateModel(Environment env) throws TemplateException {
        return this.eval(env);
    }

    final TemplateModel eval(Environment env) throws TemplateException {
        return this.constantValue != null ? this.constantValue : this._eval(env);
    }

    String evalAndCoerceToString(Environment env) throws TemplateException {
        return EvalUtil.coerceModelToString(this.eval(env), this, null, env);
    }

    String evalAndCoerceToString(Environment env, String seqTip) throws TemplateException {
        return EvalUtil.coerceModelToString(this.eval(env), this, seqTip, env);
    }

    static String coerceModelToString(TemplateModel tm, Expression exp, Environment env) throws TemplateException {
        return EvalUtil.coerceModelToString(tm, exp, null, env);
    }

    Number evalToNumber(Environment env) throws TemplateException {
        TemplateModel model = this.eval(env);
        return this.modelToNumber(model, env);
    }

    Number modelToNumber(TemplateModel model, Environment env) throws TemplateException {
        if (model instanceof TemplateNumberModel) {
            return EvalUtil.modelToNumber((TemplateNumberModel)model, this);
        }
        throw new NonNumericalException(this, model, env);
    }

    boolean evalToBoolean(Environment env) throws TemplateException {
        return this.evalToBoolean(env, null);
    }

    boolean evalToBoolean(Configuration cfg) throws TemplateException {
        return this.evalToBoolean(null, cfg);
    }

    TemplateModel evalToNonMissing(Environment env) throws TemplateException {
        TemplateModel result = this.eval(env);
        this.assertNonNull(result, env);
        return result;
    }

    private boolean evalToBoolean(Environment env, Configuration cfg) throws TemplateException {
        TemplateModel model = this.eval(env);
        return this.modelToBoolean(model, env, cfg);
    }

    boolean modelToBoolean(TemplateModel model, Environment env) throws TemplateException {
        return this.modelToBoolean(model, env, null);
    }

    boolean modelToBoolean(TemplateModel model, Configuration cfg) throws TemplateException {
        return this.modelToBoolean(model, null, cfg);
    }

    private boolean modelToBoolean(TemplateModel model, Environment env, Configuration cfg) throws TemplateException {
        if (model instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model).getAsBoolean();
        }
        if (env != null ? env.isClassicCompatible() : cfg.isClassicCompatible()) {
            return model != null && !Expression.isEmpty(model);
        }
        throw new NonBooleanException(this, model, env);
    }

    final Expression deepCloneWithIdentifierReplaced(String replacedIdentifier, Expression replacement, ReplacemenetState replacementState) {
        Expression clone = this.deepCloneWithIdentifierReplaced_inner(replacedIdentifier, replacement, replacementState);
        if (clone.beginLine == 0) {
            clone.copyLocationFrom(this);
        }
        return clone;
    }

    protected abstract Expression deepCloneWithIdentifierReplaced_inner(String var1, Expression var2, ReplacemenetState var3);

    static boolean isEmpty(TemplateModel model) throws TemplateModelException {
        if (model instanceof BeanModel) {
            return ((BeanModel)model).isEmpty();
        }
        if (model instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)model).size() == 0;
        }
        if (model instanceof TemplateScalarModel) {
            String s2 = ((TemplateScalarModel)model).getAsString();
            return s2 == null || s2.length() == 0;
        }
        if (model == null) {
            return true;
        }
        if (model instanceof TemplateCollectionModel) {
            return !((TemplateCollectionModel)model).iterator().hasNext();
        }
        if (model instanceof TemplateHashModel) {
            return ((TemplateHashModel)model).isEmpty();
        }
        return !(model instanceof TemplateNumberModel) && !(model instanceof TemplateDateModel) && !(model instanceof TemplateBooleanModel);
    }

    void assertNonNull(TemplateModel model, Environment env) throws InvalidReferenceException {
        if (model == null) {
            throw InvalidReferenceException.getInstance(this, env);
        }
    }

    static class ReplacemenetState {
        boolean replacementAlreadyInUse;

        ReplacemenetState() {
        }
    }
}

