/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltInForString;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.NonNumericalException;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.core.TokenMgrError;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedGetMessageWithoutStackTop;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.Configuration;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.StringReader;

class BuiltInsForStringsMisc {
    private BuiltInsForStringsMisc() {
    }

    static class numberBI
    extends BuiltInForString {
        numberBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s2));
            }
            catch (NumberFormatException nfe) {
                throw NonNumericalException.newMalformedNumberException(this, s2, env);
            }
        }
    }

    static class evalBI
    extends BuiltInForString {
        evalBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            int namingConvention;
            SimpleCharStream scs = new SimpleCharStream(new StringReader("(" + s2 + ")"), -1000000000, 1, s2.length() + 2);
            FMParserTokenManager token_source = new FMParserTokenManager(scs);
            Configuration cfg = env.getConfiguration();
            token_source.incompatibleImprovements = cfg.getIncompatibleImprovements().intValue();
            token_source.SwitchTo(2);
            token_source.initialNamingConvention = namingConvention = cfg.getNamingConvention();
            token_source.namingConvention = namingConvention;
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            Expression exp = null;
            try {
                try {
                    exp = parser.Expression();
                }
                catch (TokenMgrError e2) {
                    throw e2.toParseException(this.getTemplate());
                }
            }
            catch (ParseException e3) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e3), "\n---end-message---", "\n\nThe failing expression:"});
            }
            try {
                return exp.eval(env);
            }
            catch (TemplateException e4) {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e4), "\n---end-message---", "\n\nThe failing expression:"});
            }
        }
    }

    static class booleanBI
    extends BuiltInForString {
        booleanBI() {
        }

        TemplateModel calculateResult(String s2, Environment env) throws TemplateException {
            boolean b2;
            if (s2.equals("true")) {
                b2 = true;
            } else if (s2.equals("false")) {
                b2 = false;
            } else if (s2.equals(env.getTrueStringValue())) {
                b2 = true;
            } else if (s2.equals(env.getFalseStringValue())) {
                b2 = false;
            } else {
                throw new _MiscTemplateException((Expression)this, env, new Object[]{"Can't convert this string to boolean: ", new _DelayedJQuote(s2)});
            }
            return b2 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }
}

