/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.BugException;
import freemarker.core.BuiltIn;
import freemarker.core.BuiltInForSequence;
import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.MessageUtil;
import freemarker.core.NonSequenceOrCollectionException;
import freemarker.core.RightUnboundedRangeModel;
import freemarker.core._DelayedFTLTypeDescription;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedGetMessageWithoutStackTop;
import freemarker.core._DelayedJQuote;
import freemarker.core._TemplateModelException;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateModelListSequence;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Constants;
import freemarker.template.utility.StringUtil;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

class BuiltInsForSequences {
    private static boolean isBuggySeqButGoodCollection(TemplateModel model) {
        return model instanceof CollectionModel ? !((CollectionModel)model).getSupportsIndexedAccess() : false;
    }

    private static boolean modelsEqual(int seqItemIndex, TemplateModel seqItem, TemplateModel searchedItem, Environment env) throws TemplateModelException {
        try {
            return EvalUtil.compare(seqItem, null, 1, null, searchedItem, null, null, false, true, true, true, env);
        }
        catch (TemplateException ex) {
            throw new _TemplateModelException((Throwable)ex, new Object[]{"This error has occurred when comparing sequence item at 0-based index ", new Integer(seqItemIndex), " to the searched item:\n", new _DelayedGetMessage(ex)});
        }
    }

    private BuiltInsForSequences() {
    }

    static class sortBI
    extends BuiltInForSequence {
        static final int KEY_TYPE_NOT_YET_DETECTED = 0;
        static final int KEY_TYPE_STRING = 1;
        static final int KEY_TYPE_NUMBER = 2;
        static final int KEY_TYPE_DATE = 3;
        static final int KEY_TYPE_BOOLEAN = 4;

        sortBI() {
        }

        static TemplateModelException newInconsistentSortKeyTypeException(int keyNamesLn, String firstType, String firstTypePlural, int index, TemplateModel key) {
            String valuesInMsg;
            String valueInMsg;
            if (keyNamesLn == 0) {
                valueInMsg = "value";
                valuesInMsg = "values";
            } else {
                valueInMsg = "key value";
                valuesInMsg = "key values";
            }
            return new _TemplateModelException(new Object[]{sortBI.startErrorMessage(keyNamesLn, index), "All ", valuesInMsg, " in the sequence must be ", firstTypePlural, ", because the first ", valueInMsg, " was that. However, the ", valueInMsg, " of the current item isn't a ", firstType, " but a ", new _DelayedFTLTypeDescription(key), "."});
        }

        static TemplateSequenceModel sort(TemplateSequenceModel seq, String[] keyNames) throws TemplateModelException {
            int i2;
            int ln = seq.size();
            if (ln == 0) {
                return seq;
            }
            ArrayList<Object> res = new ArrayList<Object>(ln);
            int keyNamesLn = keyNames == null ? 0 : keyNames.length;
            int keyType = 0;
            Comparator keyComparator = null;
            block18: for (i2 = 0; i2 < ln; ++i2) {
                TemplateModel item;
                TemplateModel key = item = seq.get(i2);
                for (int keyNameI = 0; keyNameI < keyNamesLn; ++keyNameI) {
                    try {
                        key = ((TemplateHashModel)key).get(keyNames[keyNameI]);
                    }
                    catch (ClassCastException e2) {
                        if (!(key instanceof TemplateHashModel)) {
                            throw new _TemplateModelException(new Object[]{sortBI.startErrorMessage(keyNamesLn, i2), keyNameI == 0 ? "Sequence items must be hashes when using ?sort_by. " : "The " + StringUtil.jQuote(keyNames[keyNameI - 1]), " subvariable is not a hash, so ?sort_by ", "can't proceed with getting the ", new _DelayedJQuote(keyNames[keyNameI]), " subvariable."});
                        }
                        throw e2;
                    }
                    if (key != null) continue;
                    throw new _TemplateModelException(new Object[]{sortBI.startErrorMessage(keyNamesLn, i2), "The " + StringUtil.jQuote(keyNames[keyNameI]), " subvariable was not found."});
                }
                if (keyType == 0) {
                    if (key instanceof TemplateScalarModel) {
                        keyType = 1;
                        keyComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
                    } else if (key instanceof TemplateNumberModel) {
                        keyType = 2;
                        keyComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
                    } else if (key instanceof TemplateDateModel) {
                        keyType = 3;
                        keyComparator = new DateKVPComparator();
                    } else if (key instanceof TemplateBooleanModel) {
                        keyType = 4;
                        keyComparator = new BooleanKVPComparator();
                    } else {
                        throw new _TemplateModelException(new Object[]{sortBI.startErrorMessage(keyNamesLn, i2), "Values used for sorting must be numbers, strings, date/times or booleans."});
                    }
                }
                switch (keyType) {
                    case 1: {
                        try {
                            res.add(new KVP(((TemplateScalarModel)key).getAsString(), item));
                            continue block18;
                        }
                        catch (ClassCastException e3) {
                            if (!(key instanceof TemplateScalarModel)) {
                                throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "string", "strings", i2, key);
                            }
                            throw e3;
                        }
                    }
                    case 2: {
                        try {
                            res.add(new KVP(((TemplateNumberModel)key).getAsNumber(), item));
                            continue block18;
                        }
                        catch (ClassCastException e4) {
                            if (key instanceof TemplateNumberModel) continue block18;
                            throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "number", "numbers", i2, key);
                        }
                    }
                    case 3: {
                        try {
                            res.add(new KVP(((TemplateDateModel)key).getAsDate(), item));
                            continue block18;
                        }
                        catch (ClassCastException e5) {
                            if (key instanceof TemplateDateModel) continue block18;
                            throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "date/time", "date/times", i2, key);
                        }
                    }
                    case 4: {
                        try {
                            res.add(new KVP(((TemplateBooleanModel)key).getAsBoolean(), item));
                            continue block18;
                        }
                        catch (ClassCastException e6) {
                            if (key instanceof TemplateBooleanModel) continue block18;
                            throw sortBI.newInconsistentSortKeyTypeException(keyNamesLn, "boolean", "booleans", i2, key);
                        }
                    }
                    default: {
                        throw new BugException("Unexpected key type");
                    }
                }
            }
            try {
                Collections.sort(res, keyComparator);
            }
            catch (Exception exc) {
                throw new _TemplateModelException((Throwable)exc, new Object[]{sortBI.startErrorMessage(keyNamesLn), "Unexpected error while sorting:" + exc});
            }
            for (i2 = 0; i2 < ln; ++i2) {
                res.set(i2, ((KVP)res.get(i2)).value);
            }
            return new TemplateModelListSequence(res);
        }

        static Object[] startErrorMessage(int keyNamesLn) {
            return new Object[]{keyNamesLn == 0 ? "?sort" : "?sort_by(...)", " failed: "};
        }

        static Object[] startErrorMessage(int keyNamesLn, int index) {
            return new Object[]{keyNamesLn == 0 ? "?sort" : "?sort_by(...)", " failed at sequence index ", new Integer(index), index == 0 ? ": " : " (0-based): "};
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) throws TemplateModelException {
            return sortBI.sort(seq, null);
        }

        private static class NumericalKVPComparator
        implements Comparator {
            private ArithmeticEngine ae;

            private NumericalKVPComparator(ArithmeticEngine ae2) {
                this.ae = ae2;
            }

            public int compare(Object arg0, Object arg1) {
                try {
                    return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
                }
                catch (TemplateException e2) {
                    throw new ClassCastException("Failed to compare numbers: " + e2);
                }
            }
        }

        private static class LexicalKVPComparator
        implements Comparator {
            private Collator collator;

            LexicalKVPComparator(Collator collator) {
                this.collator = collator;
            }

            public int compare(Object arg0, Object arg1) {
                return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
            }
        }

        private static class KVP {
            private Object key;
            private Object value;

            private KVP(Object key, Object value) {
                this.key = key;
                this.value = value;
            }
        }

        private static class DateKVPComparator
        implements Serializable,
        Comparator {
            private DateKVPComparator() {
            }

            public int compare(Object arg0, Object arg1) {
                return ((Date)((KVP)arg0).key).compareTo((Date)((KVP)arg1).key);
            }
        }

        private static class BooleanKVPComparator
        implements Serializable,
        Comparator {
            private BooleanKVPComparator() {
            }

            public int compare(Object arg0, Object arg1) {
                boolean b0 = (Boolean)((KVP)arg0).key;
                boolean b1 = (Boolean)((KVP)arg1).key;
                if (b0) {
                    return b1 ? 0 : 1;
                }
                return b1 ? -1 : 0;
            }
        }
    }

    static class sort_byBI
    extends sortBI {
        sort_byBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) {
            return new BIMethod(seq);
        }

        class BIMethod
        implements TemplateMethodModelEx {
            TemplateSequenceModel seq;

            BIMethod(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public Object exec(List args) throws TemplateModelException {
                String[] subvars;
                if (args.size() < 1) {
                    throw MessageUtil.newArgCntError("?" + sort_byBI.this.key, args.size(), 1);
                }
                Object obj = args.get(0);
                if (obj instanceof TemplateScalarModel) {
                    subvars = new String[]{((TemplateScalarModel)obj).getAsString()};
                } else if (obj instanceof TemplateSequenceModel) {
                    TemplateSequenceModel seq = (TemplateSequenceModel)obj;
                    int ln = seq.size();
                    subvars = new String[ln];
                    for (int i2 = 0; i2 < ln; ++i2) {
                        TemplateModel item = seq.get(i2);
                        try {
                            subvars[i2] = ((TemplateScalarModel)item).getAsString();
                            continue;
                        }
                        catch (ClassCastException e2) {
                            if (item instanceof TemplateScalarModel) continue;
                            throw new _TemplateModelException(new Object[]{"The argument to ?", sort_byBI.this.key, "(key), when it's a sequence, must be a sequence of strings, but the item at index ", new Integer(i2), " is not a string."});
                        }
                    }
                } else {
                    throw new _TemplateModelException(new Object[]{"The argument to ?", sort_byBI.this.key, "(key) must be a string (the name of the subvariable), or a sequence of strings (the \"path\" to the subvariable)."});
                }
                return sortBI.sort(this.seq, subvars);
            }
        }
    }

    static class seq_index_ofBI
    extends BuiltIn {
        private int m_dir;

        seq_index_ofBI(int dir) {
            this.m_dir = dir;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            return new BIMethod(env);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            protected final TemplateSequenceModel m_seq;
            protected final TemplateCollectionModel m_col;
            protected final Environment m_env;

            private BIMethod(Environment env) throws TemplateException {
                TemplateModel model = seq_index_ofBI.this.target.eval(env);
                this.m_seq = model instanceof TemplateSequenceModel && !BuiltInsForSequences.isBuggySeqButGoodCollection(model) ? (TemplateSequenceModel)model : null;
                TemplateCollectionModel templateCollectionModel = this.m_col = this.m_seq == null && model instanceof TemplateCollectionModel ? (TemplateCollectionModel)model : null;
                if (this.m_seq == null && this.m_col == null) {
                    throw new NonSequenceOrCollectionException(seq_index_ofBI.this.target, model, env);
                }
                this.m_env = env;
            }

            public final Object exec(List args) throws TemplateModelException {
                int foundAtIdx;
                int argCnt = args.size();
                seq_index_ofBI.this.checkMethodArgCount(argCnt, 1, 2);
                TemplateModel target = (TemplateModel)args.get(0);
                if (argCnt > 1) {
                    int startIndex = seq_index_ofBI.this.getNumberMethodArg(args, 1).intValue();
                    foundAtIdx = this.m_seq != null ? this.findInSeq(target, startIndex) : this.findInCol(target, startIndex);
                } else {
                    foundAtIdx = this.m_seq != null ? this.findInSeq(target) : this.findInCol(target);
                }
                return foundAtIdx == -1 ? Constants.MINUS_ONE : new SimpleNumber(foundAtIdx);
            }

            int findInCol(TemplateModel target) throws TemplateModelException {
                return this.findInCol(target, 0, Integer.MAX_VALUE);
            }

            protected int findInCol(TemplateModel target, int startIndex) throws TemplateModelException {
                if (seq_index_ofBI.this.m_dir == 1) {
                    return this.findInCol(target, startIndex, Integer.MAX_VALUE);
                }
                return this.findInCol(target, 0, startIndex);
            }

            protected int findInCol(TemplateModel target, int allowedRangeStart, int allowedRangeEnd) throws TemplateModelException {
                if (allowedRangeEnd < 0) {
                    return -1;
                }
                TemplateModelIterator it = this.m_col.iterator();
                int foundAtIdx = -1;
                for (int idx = 0; it.hasNext() && idx <= allowedRangeEnd; ++idx) {
                    TemplateModel current = it.next();
                    if (idx < allowedRangeStart || !BuiltInsForSequences.modelsEqual(idx, current, target, this.m_env)) continue;
                    foundAtIdx = idx;
                    if (seq_index_ofBI.this.m_dir == 1) break;
                }
                return foundAtIdx;
            }

            int findInSeq(TemplateModel target) throws TemplateModelException {
                int seqSize = this.m_seq.size();
                int actualStartIndex = seq_index_ofBI.this.m_dir == 1 ? 0 : seqSize - 1;
                return this.findInSeq(target, actualStartIndex, seqSize);
            }

            private int findInSeq(TemplateModel target, int startIndex) throws TemplateModelException {
                int seqSize = this.m_seq.size();
                if (seq_index_ofBI.this.m_dir == 1) {
                    if (startIndex >= seqSize) {
                        return -1;
                    }
                    if (startIndex < 0) {
                        startIndex = 0;
                    }
                } else {
                    if (startIndex >= seqSize) {
                        startIndex = seqSize - 1;
                    }
                    if (startIndex < 0) {
                        return -1;
                    }
                }
                return this.findInSeq(target, startIndex, seqSize);
            }

            private int findInSeq(TemplateModel target, int scanStartIndex, int seqSize) throws TemplateModelException {
                if (seq_index_ofBI.this.m_dir == 1) {
                    for (int i2 = scanStartIndex; i2 < seqSize; ++i2) {
                        if (!BuiltInsForSequences.modelsEqual(i2, this.m_seq.get(i2), target, this.m_env)) continue;
                        return i2;
                    }
                } else {
                    for (int i3 = scanStartIndex; i3 >= 0; --i3) {
                        if (!BuiltInsForSequences.modelsEqual(i3, this.m_seq.get(i3), target, this.m_env)) continue;
                        return i3;
                    }
                }
                return -1;
            }
        }
    }

    static class seq_containsBI
    extends BuiltIn {
        seq_containsBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateSequenceModel && !BuiltInsForSequences.isBuggySeqButGoodCollection(model)) {
                return new BIMethodForSequence((TemplateSequenceModel)model, env);
            }
            if (model instanceof TemplateCollectionModel) {
                return new BIMethodForCollection((TemplateCollectionModel)model, env);
            }
            throw new NonSequenceOrCollectionException(this.target, model, env);
        }

        private class BIMethodForSequence
        implements TemplateMethodModelEx {
            private TemplateSequenceModel m_seq;
            private Environment m_env;

            private BIMethodForSequence(TemplateSequenceModel seq, Environment env) {
                this.m_seq = seq;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                seq_containsBI.this.checkMethodArgCount(args, 1);
                TemplateModel arg = (TemplateModel)args.get(0);
                int size = this.m_seq.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!BuiltInsForSequences.modelsEqual(i2, this.m_seq.get(i2), arg, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }

        private class BIMethodForCollection
        implements TemplateMethodModelEx {
            private TemplateCollectionModel m_coll;
            private Environment m_env;

            private BIMethodForCollection(TemplateCollectionModel coll, Environment env) {
                this.m_coll = coll;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                seq_containsBI.this.checkMethodArgCount(args, 1);
                TemplateModel arg = (TemplateModel)args.get(0);
                TemplateModelIterator it = this.m_coll.iterator();
                int idx = 0;
                while (it.hasNext()) {
                    if (BuiltInsForSequences.modelsEqual(idx, it.next(), arg, this.m_env)) {
                        return TemplateBooleanModel.TRUE;
                    }
                    ++idx;
                }
                return TemplateBooleanModel.FALSE;
            }
        }
    }

    static class reverseBI
    extends BuiltInForSequence {
        reverseBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) {
            if (tsm instanceof ReverseSequence) {
                return ((ReverseSequence)tsm).seq;
            }
            return new ReverseSequence(tsm);
        }

        private static class ReverseSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel seq;

            ReverseSequence(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public TemplateModel get(int index) throws TemplateModelException {
                return this.seq.get(this.seq.size() - 1 - index);
            }

            public int size() throws TemplateModelException {
                return this.seq.size();
            }
        }
    }

    static class lastBI
    extends BuiltInForSequence {
        lastBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(tsm.size() - 1);
        }
    }

    static class joinBI
    extends BuiltIn {
        joinBI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateCollectionModel) {
                if (model instanceof RightUnboundedRangeModel) {
                    throw new _TemplateModelException("The sequence to join was right-unbounded numerical range, thus it's infinitely long.");
                }
                return new BIMethodForCollection(env, (TemplateCollectionModel)model);
            }
            if (model instanceof TemplateSequenceModel) {
                return new BIMethodForCollection(env, new CollectionAndSequence((TemplateSequenceModel)model));
            }
            throw new NonSequenceOrCollectionException(this.target, model, env);
        }

        private class BIMethodForCollection
        implements TemplateMethodModelEx {
            private final Environment env;
            private final TemplateCollectionModel coll;

            private BIMethodForCollection(Environment env, TemplateCollectionModel coll) {
                this.env = env;
                this.coll = coll;
            }

            public Object exec(List args) throws TemplateModelException {
                joinBI.this.checkMethodArgCount(args, 1, 3);
                String separator = joinBI.this.getStringMethodArg(args, 0);
                String whenEmpty = joinBI.this.getOptStringMethodArg(args, 1);
                String afterLast = joinBI.this.getOptStringMethodArg(args, 2);
                StringBuffer sb = new StringBuffer();
                TemplateModelIterator it = this.coll.iterator();
                int idx = 0;
                boolean hadItem = false;
                while (it.hasNext()) {
                    TemplateModel item = it.next();
                    if (item != null) {
                        if (hadItem) {
                            sb.append(separator);
                        } else {
                            hadItem = true;
                        }
                        try {
                            sb.append(EvalUtil.coerceModelToString(item, null, null, this.env));
                        }
                        catch (TemplateException e2) {
                            throw new _TemplateModelException((Throwable)e2, new Object[]{"\"?", joinBI.this.key, "\" failed at index ", new Integer(idx), " with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e2), "\n---end-message---"});
                        }
                    }
                    ++idx;
                }
                if (hadItem) {
                    if (afterLast != null) {
                        sb.append(afterLast);
                    }
                } else if (whenEmpty != null) {
                    sb.append(whenEmpty);
                }
                return new SimpleScalar(sb.toString());
            }
        }
    }

    static class firstBI
    extends BuiltInForSequence {
        firstBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(0);
        }
    }

    static class chunkBI
    extends BuiltInForSequence {
        chunkBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            return new BIMethod(tsm);
        }

        private static class ChunkedSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel wrappedTsm;
            private final int chunkSize;
            private final TemplateModel fillerItem;
            private final int numberOfChunks;

            private ChunkedSequence(TemplateSequenceModel wrappedTsm, int chunkSize, TemplateModel fillerItem) throws TemplateModelException {
                if (chunkSize < 1) {
                    throw new _TemplateModelException(new Object[]{"The 1st argument to ?', key, ' (...) must be at least 1."});
                }
                this.wrappedTsm = wrappedTsm;
                this.chunkSize = chunkSize;
                this.fillerItem = fillerItem;
                this.numberOfChunks = (wrappedTsm.size() + chunkSize - 1) / chunkSize;
            }

            public TemplateModel get(final int chunkIndex) throws TemplateModelException {
                if (chunkIndex >= this.numberOfChunks) {
                    return null;
                }
                return new TemplateSequenceModel(){
                    private final int baseIndex;
                    {
                        this.baseIndex = chunkIndex * ChunkedSequence.this.chunkSize;
                    }

                    public TemplateModel get(int relIndex) throws TemplateModelException {
                        int absIndex = this.baseIndex + relIndex;
                        if (absIndex < ChunkedSequence.this.wrappedTsm.size()) {
                            return ChunkedSequence.this.wrappedTsm.get(absIndex);
                        }
                        return absIndex < ChunkedSequence.this.numberOfChunks * ChunkedSequence.this.chunkSize ? ChunkedSequence.this.fillerItem : null;
                    }

                    public int size() throws TemplateModelException {
                        return ChunkedSequence.this.fillerItem != null || chunkIndex + 1 < ChunkedSequence.this.numberOfChunks ? ChunkedSequence.this.chunkSize : ChunkedSequence.this.wrappedTsm.size() - this.baseIndex;
                    }
                };
            }

            public int size() throws TemplateModelException {
                return this.numberOfChunks;
            }
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private final TemplateSequenceModel tsm;

            private BIMethod(TemplateSequenceModel tsm) {
                this.tsm = tsm;
            }

            public Object exec(List args) throws TemplateModelException {
                chunkBI.this.checkMethodArgCount(args, 1, 2);
                int chunkSize = chunkBI.this.getNumberMethodArg(args, 0).intValue();
                return new ChunkedSequence(this.tsm, chunkSize, args.size() > 1 ? (TemplateModel)args.get(1) : null);
            }
        }
    }
}

