/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.StatefulTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiTemplateLoader
implements StatefulTemplateLoader {
    private final TemplateLoader[] loaders;
    private final Map lastLoaderForName = Collections.synchronizedMap(new HashMap());

    public MultiTemplateLoader(TemplateLoader[] loaders) {
        this.loaders = (TemplateLoader[])loaders.clone();
    }

    public Object findTemplateSource(String name) throws IOException {
        Object source;
        TemplateLoader lastLoader = (TemplateLoader)this.lastLoaderForName.get(name);
        if (lastLoader != null && (source = lastLoader.findTemplateSource(name)) != null) {
            return new MultiSource(source, lastLoader);
        }
        for (int i2 = 0; i2 < this.loaders.length; ++i2) {
            TemplateLoader loader = this.loaders[i2];
            Object source2 = loader.findTemplateSource(name);
            if (source2 == null) continue;
            this.lastLoaderForName.put(name, loader);
            return new MultiSource(source2, loader);
        }
        this.lastLoaderForName.remove(name);
        return null;
    }

    private Object modifyForIcI(Object source) {
        return null;
    }

    public long getLastModified(Object templateSource) {
        return ((MultiSource)templateSource).getLastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return ((MultiSource)templateSource).getReader(encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((MultiSource)templateSource).close();
    }

    public void resetState() {
        this.lastLoaderForName.clear();
        for (int i2 = 0; i2 < this.loaders.length; ++i2) {
            TemplateLoader loader = this.loaders[i2];
            if (!(loader instanceof StatefulTemplateLoader)) continue;
            ((StatefulTemplateLoader)loader).resetState();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MultiTemplateLoader(");
        for (int i2 = 0; i2 < this.loaders.length; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append("loader").append(i2 + 1).append(" = ").append(this.loaders[i2]);
        }
        sb.append(")");
        return sb.toString();
    }

    public int getTemplateLoaderCount() {
        return this.loaders.length;
    }

    public TemplateLoader getTemplateLoader(int index) {
        return this.loaders[index];
    }

    static final class MultiSource {
        private final Object source;
        private final TemplateLoader loader;

        MultiSource(Object source, TemplateLoader loader) {
            this.source = source;
            this.loader = loader;
        }

        long getLastModified() {
            return this.loader.getLastModified(this.source);
        }

        Reader getReader(String encoding) throws IOException {
            return this.loader.getReader(this.source, encoding);
        }

        void close() throws IOException {
            this.loader.closeTemplateSource(this.source);
        }

        Object getWrappedSource() {
            return this.source;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof MultiSource) {
                MultiSource m2 = (MultiSource)o2;
                return m2.loader.equals(this.loader) && m2.source.equals(this.source);
            }
            return false;
        }

        public int hashCode() {
            return this.loader.hashCode() + 31 * this.source.hashCode();
        }

        public String toString() {
            return this.source.toString();
        }
    }
}

