/*
 * Decompiled with CFR 0.152.
 */
package f;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.nxp.nfclib.ndef.NdefMessageWrapper;
import com.nxp.nfclib.ndef.NdefRecord;
import com.nxp.nfclib.ndef.NdefRecordWrapper;
import com.nxp.tagxplorer.ndef.models.BTTypes;
import com.nxp.tagxplorer.ndef.models.BluetoothRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import f.g;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;

public class b {
    private static final byte[] b = new byte[]{72, 115};
    private static final byte[] c = new byte[]{117, 114, 110, 58, 110, 102, 99, 58, 101, 120, 116, 58, 110, 111, 107, 105, 97, 46, 99, 111, 109, 58, 98, 116};
    private static final byte[] d = new byte[]{110, 111, 107, 105, 97, 46, 99, 111, 109, 58, 98, 116};
    private static final byte[] e = new byte[]{97, 112, 112, 108, 105, 99, 97, 116, 105, 111, 110, 47, 118, 110, 100, 46, 98, 108, 117, 101, 116, 111, 111, 116, 104, 46, 101, 112, 46, 111, 111, 98};
    private static final byte[] f = new byte[]{0, 0, 0};
    private static final byte[] g = new byte[]{4, 6, -128};
    private static final byte[] h = new byte[]{-128, 6, 4};
    private static final byte[] i = new byte[]{4, 6, 32};
    private static final byte[] j = new byte[]{32, 6, 4};
    private static final byte[] k = new byte[]{64, 2, 12};
    private static final byte[] l = new byte[]{12, 2, 64};
    private static final byte[] m = new byte[]{32, 4, 4};
    private static final byte[] n = new byte[]{4, 4, 32};
    static EnumMap<BTTypes, String> a = null;
    private static HashMap<String, BTTypes> o = null;

    public static BTTypes a(NdefRecordWrapper r2) {
        BTTypes t2;
        String type = new String(r2.getType(), Charsets.US_ASCII);
        if (r2.getTnf() == 4 || r2.getTnf() == 2) {
            type = type.toLowerCase();
        }
        if ((t2 = o.get(type)) == null) {
            return BTTypes.NONE;
        }
        return t2;
    }

    public static BluetoothRecord b(NdefRecordWrapper record) {
        BTTypes btType = f.b.a(record);
        BluetoothRecord bluetoothRecord = null;
        switch (btType) {
            case Hs: {
                bluetoothRecord = f.b.c(record);
                break;
            }
            case nokia_com_bt: {
                bluetoothRecord = f.b.d(record);
                break;
            }
            case application_vnd_bluetooth_ep_oob: {
                bluetoothRecord = f.b.e(record);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (bluetoothRecord != null) {
            bluetoothRecord.setType(NDEFRecordType.BLUETOOTH_RECORD);
        }
        return bluetoothRecord;
    }

    public static String a(BluetoothRecord bluetoothRecord, short loopCount) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bluetoothRecord != null) {
            if (!bluetoothRecord.getDeviceName().equals("Handover Select Record")) {
                stringBuilder.append("\u25e9 Record #" + loopCount + ": ");
                stringBuilder.append("Bluetooth Record");
                stringBuilder.append("\n");
                stringBuilder.append("  \u25b6 Device Name : ");
                stringBuilder.append(bluetoothRecord.getDeviceName());
                stringBuilder.append("\n");
                stringBuilder.append("  \u25b6 MAC Address : ");
                stringBuilder.append(bluetoothRecord.getMacAddress());
                stringBuilder.append("\n");
                BTTypes version = bluetoothRecord.getBluetoothNdefVersion();
                if (version == BTTypes.nokia_com_bt) {
                    stringBuilder.append("  \u25b6 Password : ");
                    stringBuilder.append(bluetoothRecord.getPassword());
                    stringBuilder.append("\n");
                }
                stringBuilder.append("  \u25b6 Bluetooth NDEF Version : ");
                if (version == BTTypes.nokia_com_bt) {
                    stringBuilder.append("Bluetooth 2.0");
                } else if (version == BTTypes.application_vnd_bluetooth_ep_oob) {
                    stringBuilder.append("Bluetooth 2.1");
                }
                stringBuilder.append("\n");
                stringBuilder.append("  \u25b6 Device Class : ");
                int devClass = bluetoothRecord.getDeviceClass();
                if (devClass == 1) {
                    stringBuilder.append("Printer");
                } else if (devClass == 2) {
                    stringBuilder.append("Camera");
                } else if (devClass == 3) {
                    stringBuilder.append("Smartphone");
                } else if (devClass == 4) {
                    stringBuilder.append("Wearable Headset");
                }
                stringBuilder.append("\n");
                stringBuilder.append("  \u25b6 NDEF message size: ");
                stringBuilder.append(f.g.i());
                stringBuilder.append(" bytes");
                stringBuilder.append(f.g.a(loopCount - 1));
                stringBuilder.append("\n");
            } else {
                stringBuilder.append("\u25e9 Record #" + loopCount + ": ");
                stringBuilder.append(bluetoothRecord.getDeviceName());
                stringBuilder.append("\n");
                stringBuilder.append("  \u25b6 Version: 1.2");
                stringBuilder.append("\n");
                stringBuilder.append("  \u25b6 Payload length:10 bytes");
            }
        } else {
            stringBuilder.append("Unknown record");
        }
        return stringBuilder.toString();
    }

    private static BluetoothRecord c(NdefRecordWrapper record) {
        int deviceClass = 0;
        Preconditions.checkArgument(record.getTnf() == 1);
        Preconditions.checkArgument(Arrays.equals(record.getType(), b));
        return new BluetoothRecord("Handover Select Record", "N/A", "N/A", BTTypes.Hs, deviceClass, true);
    }

    private static BluetoothRecord d(NdefRecordWrapper record) {
        Preconditions.checkArgument(record.getTnf() == 2 || record.getTnf() == 4);
        Preconditions.checkArgument(Arrays.equals(record.getType(), c) || Arrays.equals(record.getType(), d));
        byte[] payload = record.getPayload();
        int configType = payload[0] & 0xFF;
        int authInfoLength = 16;
        if (configType == 36) {
            authInfoLength = 4;
        }
        if (payload == null || payload.length < 11 + authInfoLength) {
            throw new IllegalArgumentException("Record too short");
        }
        StringBuilder b2 = new StringBuilder();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i2 = 0; i2 < 6; ++i2) {
            b2.append(hexChars[payload[1 + i2] >> 4 & 0xF]);
            b2.append(hexChars[payload[1 + i2] & 0xF]);
            b2.append(":");
        }
        b2.deleteCharAt(b2.length() - 1);
        String macAddress = b2.toString();
        byte[] deviceClassBytes = new byte[3];
        System.arraycopy(payload, 7, deviceClassBytes, 0, 3);
        int deviceClass = 0;
        deviceClass = Arrays.equals(deviceClassBytes, g) ? 1 : (Arrays.equals(deviceClassBytes, i) ? 2 : (Arrays.equals(deviceClassBytes, k) ? 3 : (Arrays.equals(deviceClassBytes, m) ? 4 : 0)));
        byte[] passwordBytes = new byte[authInfoLength];
        System.arraycopy(payload, 10, passwordBytes, 0, authInfoLength);
        String password = new String(passwordBytes, Charset.forName("US-ASCII")).trim();
        int nameLen = payload[10 + authInfoLength] & 0xFF;
        if (nameLen != payload.length - 11 - authInfoLength) {
            throw new IllegalArgumentException("Record length incorrect");
        }
        byte[] deviceNameBytes = new byte[nameLen];
        System.arraycopy(payload, 11 + authInfoLength, deviceNameBytes, 0, nameLen);
        String deviceName = new String(deviceNameBytes, Charset.forName("US-ASCII"));
        return new BluetoothRecord(deviceName, macAddress, password, BTTypes.nokia_com_bt, deviceClass, false);
    }

    private static String a(byte b2) {
        int i2 = b2 & 0xFF;
        return Integer.toHexString(i2);
    }

    private static BluetoothRecord e(NdefRecordWrapper record) {
        int recLen;
        Preconditions.checkArgument(record.getTnf() == 2);
        Preconditions.checkArgument(Arrays.equals(record.getType(), e));
        String password = "0000";
        byte[] payload = record.getPayload();
        if (payload == null || payload.length < 2) {
            throw new IllegalArgumentException("Record too short");
        }
        int payloadLen = payload[0] & 0xFF | (payload[1] & 0xFF) << 8;
        if (payloadLen != payload.length && 8 + payloadLen != payload.length && 8 + payloadLen + 11 != payload.length) {
            throw new IllegalArgumentException("Length incorrect");
        }
        StringBuilder b2 = new StringBuilder();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i2 = 0; i2 < 6; ++i2) {
            StringBuilder sb = new StringBuilder();
            sb.append(hexChars[payload[2 + i2] >> 4 & 0xF]);
            sb.append(hexChars[payload[2 + i2] & 0xF]);
            b2.insert(0, sb.toString());
            b2.insert(0, ":");
        }
        b2.deleteCharAt(0);
        String macAddress = b2.toString();
        String deviceName = "";
        int deviceClass = 0;
        block7: for (int offset = 8; offset < payload.length; offset += recLen + 1) {
            recLen = 0;
            try {
                byte lenByte = payload[offset];
                recLen = Integer.parseInt(f.b.a(lenByte), 16);
            }
            catch (Exception e2) {
                recLen = payload[offset];
            }
            if (offset + recLen + 1 > payload.length) {
                throw new IllegalArgumentException("Invalid EIR record");
            }
            byte recType = payload[offset + 1];
            switch (recType) {
                case 8: 
                case 9: {
                    byte[] deviceNameBytes = new byte[recLen - 1];
                    System.arraycopy(payload, offset + 2, deviceNameBytes, 0, recLen - 1);
                    deviceName = new String(deviceNameBytes, Charset.forName("UTF-8"));
                    continue block7;
                }
                case 13: {
                    byte[] deviceClassBytes = new byte[recLen - 1];
                    System.arraycopy(payload, offset + 2, deviceClassBytes, 0, recLen - 1);
                    if (Arrays.equals(deviceClassBytes, h)) {
                        deviceClass = 1;
                        continue block7;
                    }
                    if (Arrays.equals(deviceClassBytes, j)) {
                        deviceClass = 2;
                        continue block7;
                    }
                    if (Arrays.equals(deviceClassBytes, l)) {
                        deviceClass = 3;
                        continue block7;
                    }
                    if (Arrays.equals(deviceClassBytes, n)) {
                        deviceClass = 4;
                        continue block7;
                    }
                    deviceClass = 0;
                    continue block7;
                }
            }
        }
        return new BluetoothRecord(deviceName, macAddress, "0000", BTTypes.application_vnd_bluetooth_ep_oob, deviceClass, false);
    }

    public static NdefRecordWrapper a(BTTypes btType, String macAddress, String password, String deviceName, int deviceClass) {
        switch (btType) {
            case nokia_com_bt: {
                return f.b.a(macAddress, password, deviceName, deviceClass);
            }
            case application_vnd_bluetooth_ep_oob: {
                return f.b.a(macAddress, deviceName, deviceClass);
            }
        }
        return null;
    }

    private static NdefRecordWrapper a(String macAddress, String password, String deviceName, int deviceClass) {
        if (macAddress.isEmpty() && password.isEmpty() && deviceName.isEmpty() && deviceClass == 0) {
            return new NdefRecordWrapper(0, new byte[0], new byte[0], new byte[0]);
        }
        byte[] macAddressBytes = f.b.a(macAddress);
        if (password.isEmpty()) {
            password = "0000";
        }
        byte[] passwordBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] tempPasswordBytes = password.getBytes(Charset.forName("US-ASCII"));
        System.arraycopy(tempPasswordBytes, 0, passwordBytes, 0, tempPasswordBytes.length);
        byte[] deviceTypeBytes = null;
        switch (deviceClass) {
            case 1: {
                deviceTypeBytes = g;
                break;
            }
            case 2: {
                deviceTypeBytes = i;
                break;
            }
            case 3: {
                deviceTypeBytes = k;
                break;
            }
            case 4: {
                deviceTypeBytes = m;
                break;
            }
            default: {
                deviceTypeBytes = f;
            }
        }
        byte[] localNameEir = null;
        byte[] deviceNameBytes = deviceName.getBytes(Charset.forName("UTF-8"));
        if (deviceName != null && deviceName.length() > 0) {
            byte len = (byte)deviceNameBytes.length;
            localNameEir = Bytes.concat({len}, deviceNameBytes);
        }
        byte[] optionalOobDataLengthBytes = new byte[]{0};
        byte[] payload = Bytes.concat(optionalOobDataLengthBytes, macAddressBytes);
        payload = Bytes.concat(payload, deviceTypeBytes);
        payload = Bytes.concat(payload, passwordBytes);
        if (localNameEir != null) {
            payload = Bytes.concat(payload, localNameEir);
        }
        return new NdefRecordWrapper(4, d, new byte[0], payload);
    }

    public static byte[] a(String macAddress) {
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < macAddress.length(); ++i2) {
            char c2 = macAddress.charAt(i2);
            if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f') && (c2 < 'A' || c2 > 'F')) continue;
            b2.append(c2);
        }
        String compactedAddr = b2.toString();
        if (compactedAddr.length() != 12) {
            return new byte[]{0, 0, 0, 0, 0, 0};
        }
        byte[] arb = new byte[6];
        for (int i3 = 0; i3 < 6; ++i3) {
            arb[i3] = (byte)(f.b.a(compactedAddr.charAt(i3 * 2)) << 4 | f.b.a(compactedAddr.charAt(i3 * 2 + 1)));
        }
        return arb;
    }

    private static NdefRecordWrapper a(String macAddress, String deviceName, int deviceClass) {
        if (macAddress.isEmpty() && deviceName.isEmpty() && deviceClass == 0) {
            return new NdefRecordWrapper(0, new byte[0], new byte[0], new byte[0]);
        }
        byte[] macAddressBytes = f.b.b(macAddress);
        byte[] localNameEir = null;
        byte[] deviceNameBytes = deviceName.getBytes(Charset.forName("UTF-8"));
        if (deviceName != null && deviceName.length() > 0) {
            byte len = (byte)(1 + deviceNameBytes.length);
            int type = 9;
            localNameEir = Bytes.concat({len, 9}, deviceNameBytes);
        }
        byte[] deviceTypeBytes = null;
        switch (deviceClass) {
            case 1: {
                deviceTypeBytes = h;
                break;
            }
            case 2: {
                deviceTypeBytes = j;
                break;
            }
            case 3: {
                deviceTypeBytes = l;
                break;
            }
            case 4: {
                deviceTypeBytes = n;
                break;
            }
            default: {
                deviceTypeBytes = f;
            }
        }
        byte[] optionalOobDataLengthBytes = new byte[]{deviceClass != 0 ? (byte)((localNameEir != null ? localNameEir.length : 0) + 2 + macAddressBytes.length + 2 + deviceTypeBytes.length + 6) : (byte)((localNameEir != null ? localNameEir.length : 0) + 2 + macAddressBytes.length), 0};
        byte[] payload = Bytes.concat(optionalOobDataLengthBytes, macAddressBytes);
        if (localNameEir != null) {
            payload = Bytes.concat(payload, localNameEir);
        }
        if (deviceClass != 0) {
            payload = Bytes.concat(payload, {4, 13});
            payload = Bytes.concat(payload, deviceTypeBytes);
            payload = Bytes.concat(payload, {5, 3, 30, 17, 11, 17});
        }
        byte[] id = "0".getBytes();
        return new NdefRecordWrapper(2, e, id, payload);
    }

    public static byte[] b(String macAddress) {
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < macAddress.length(); ++i2) {
            char c2 = macAddress.charAt(i2);
            if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f') && (c2 < 'A' || c2 > 'F')) continue;
            b2.append(c2);
        }
        String compactedAddr = b2.toString();
        if (compactedAddr.length() != 12) {
            return new byte[]{0, 0, 0, 0, 0, 0};
        }
        byte[] arb = new byte[6];
        for (int i3 = 0; i3 < 6; ++i3) {
            arb[arb.length - (i3 + 1)] = (byte)(f.b.a(compactedAddr.charAt(i3 * 2)) << 4 | f.b.a(compactedAddr.charAt(i3 * 2 + 1)));
        }
        return arb;
    }

    public static int a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return 0;
    }

    public static BTTypes a(NdefRecord r2) {
        BTTypes t2;
        String type = new String(r2.getType(), Charsets.US_ASCII);
        if (r2.getTnf() == 4 || r2.getTnf() == 2) {
            type = type.toLowerCase();
        }
        if ((t2 = o.get(type)) == null) {
            return BTTypes.NONE;
        }
        return t2;
    }

    private static boolean c(NdefMessageWrapper msg) {
        NdefRecordWrapper[] recs = msg.getRecords();
        NdefRecordWrapper record = recs[0];
        byte[] payload = record.getPayload();
        if (payload.length < 10) {
            return false;
        }
        int carrierDataRefLen = payload[7] & 0xFF;
        byte[] carrierDataRef = new byte[carrierDataRefLen];
        for (int i2 = 0; i2 < carrierDataRefLen; ++i2) {
            carrierDataRef[i2] = payload[8 + i2];
        }
        for (NdefRecordWrapper r2 : recs) {
            byte[] id = r2.getId();
            if (!Arrays.equals(id, carrierDataRef)) continue;
            NdefMessageWrapper btMsg = new NdefMessageWrapper(new NdefRecordWrapper[]{r2});
            return f.b.b(btMsg);
        }
        return false;
    }

    public static NdefRecord a(NdefMessageWrapper msg) {
        NdefRecordWrapper record = msg.getRecords()[0];
        BTTypes btType = f.b.a((NdefRecord)record);
        switch (btType) {
            case Hs: {
                return f.b.d(msg);
            }
            case nokia_com_bt: 
            case application_vnd_bluetooth_ep_oob: {
                return record;
            }
        }
        return null;
    }

    private static NdefRecord d(NdefMessageWrapper msg) {
        NdefRecordWrapper[] recs = msg.getRecords();
        NdefRecordWrapper record = recs[0];
        byte[] payload = record.getPayload();
        if (payload.length < 10) {
            NdefMessageWrapper btMsg = new NdefMessageWrapper(msg.getRecords()[1], new NdefRecordWrapper[0]);
            return f.b.a(btMsg);
        }
        int carrierDataRefLen = payload[7] & 0xFF;
        byte[] carrierDataRef = new byte[carrierDataRefLen];
        for (int i2 = 0; i2 < carrierDataRefLen; ++i2) {
            carrierDataRef[i2] = payload[8 + i2];
        }
        for (NdefRecordWrapper r2 : recs) {
            byte[] id = r2.getId();
            if (!Arrays.equals(id, carrierDataRef)) continue;
            NdefMessageWrapper btMsg = new NdefMessageWrapper(new NdefRecordWrapper[]{r2});
            return f.b.a(btMsg);
        }
        return null;
    }

    public static boolean b(NdefMessageWrapper msg) {
        NdefRecordWrapper[] records = msg.getRecords();
        int i2 = 0;
        for (NdefRecordWrapper rec : records) {
            BTTypes btType = f.b.a((NdefRecord)rec);
            switch (btType) {
                case Hs: {
                    return f.b.c(new NdefMessageWrapper(new NdefRecordWrapper[]{records[i2], records[i2 + 1]}));
                }
                case nokia_com_bt: 
                case application_vnd_bluetooth_ep_oob: {
                    return true;
                }
            }
            ++i2;
        }
        return false;
    }

    static {
        o = new HashMap();
        o.put("Hs", BTTypes.Hs);
        o.put("nokia.com:bt", BTTypes.nokia_com_bt);
        o.put("application/vnd.bluetooth.ep.oob", BTTypes.application_vnd_bluetooth_ep_oob);
        a = new EnumMap(BTTypes.class);
        a.put(BTTypes.Hs, "Handover Select");
        a.put(BTTypes.nokia_com_bt, "Nokia Bluetooth");
        a.put(BTTypes.application_vnd_bluetooth_ep_oob, "Bluetooth Secure Simple Pairing");
        a.put(BTTypes.NONE, "Unknown");
    }
}

