/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.util.BitSet;

public class CharacterBitSet {
    private final BitSet bitSet = new BitSet(128);
    private final String characters;

    public CharacterBitSet(String characters) {
        this.characters = characters;
        for (int i2 = 0; i2 < characters.length(); ++i2) {
            char next;
            char c2 = characters.charAt(i2);
            char c3 = next = i2 < characters.length() - 2 ? characters.charAt(i2 + 1) : (char)'\u0000';
            if (next == '-') {
                char start = c2;
                char end = characters.charAt(i2 + 2);
                if (start > end) {
                    char temp = start;
                    start = end;
                    end = temp;
                }
                this.bitSet.set((int)start, end + '\u0001');
                i2 += 2;
                continue;
            }
            this.bitSet.set(c2);
        }
    }

    public String characters() {
        return this.characters;
    }

    public BitSet bitSet() {
        return this.bitSet;
    }

    public boolean containsOnly(String string) {
        return this.containsOnly(string, 0);
    }

    public boolean containsOnly(String string, int startIndex) {
        for (int i2 = startIndex; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (this.bitSet.get(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(String string) {
        return this.containsAny(string, 0);
    }

    public boolean containsAny(String string, int startIndex) {
        for (int i2 = startIndex; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!this.bitSet.get(c2)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharacterBitSet other = (CharacterBitSet)obj;
        return this.bitSet.equals(other.bitSet);
    }

    public String toString() {
        return this.characters;
    }
}

