/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.validate.AllowedCharacters;
import com.github.mangstadt.vinnie.validate.VObjectValidator;
import ezvcard.Messages;
import ezvcard.SupportedVersions;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.Pid;
import ezvcard.parameter.VCardParameters;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VCardProperty
implements Comparable<VCardProperty> {
    protected String group;
    protected VCardParameters parameters;

    public VCardProperty() {
        this.parameters = new VCardParameters();
    }

    protected VCardProperty(VCardProperty original) {
        this.group = original.group;
        this.parameters = new VCardParameters(original.parameters);
    }

    public final VCardVersion[] getSupportedVersions() {
        SupportedVersions supportedVersionsAnnotation = this.getClass().getAnnotation(SupportedVersions.class);
        return supportedVersionsAnnotation == null ? VCardVersion.values() : supportedVersionsAnnotation.value();
    }

    public final boolean isSupportedBy(VCardVersion version) {
        VCardVersion[] supportedVersions;
        for (VCardVersion supportedVersion : supportedVersions = this.getSupportedVersions()) {
            if (supportedVersion != version) continue;
            return true;
        }
        return false;
    }

    public final List<ValidationWarning> validate(VCardVersion version, VCard vcard) {
        SyntaxStyle syntax;
        AllowedCharacters allowed;
        ArrayList<ValidationWarning> warnings = new ArrayList<ValidationWarning>(0);
        if (!this.isSupportedBy(version)) {
            warnings.add(new ValidationWarning(2, Arrays.toString((Object[])this.getSupportedVersions())));
        }
        warnings.addAll(this.parameters.validate(version));
        if (this.group != null && !(allowed = VObjectValidator.allowedCharactersGroup(syntax = version.getSyntaxStyle(), true)).check(this.group)) {
            if (syntax == SyntaxStyle.OLD) {
                AllowedCharacters notAllowed = allowed.flip();
                warnings.add(new ValidationWarning(32, this.group, notAllowed.toString(true)));
            } else {
                warnings.add(new ValidationWarning(23, this.group));
            }
        }
        this._validate(warnings, version, vcard);
        return warnings;
    }

    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
    }

    public VCardParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(VCardParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException(Messages.INSTANCE.getExceptionMessage(42, new Object[0]));
        }
        this.parameters = parameters;
    }

    public String getParameter(String name) {
        return (String)this.parameters.first(name);
    }

    public List<String> getParameters(String name) {
        return Collections.unmodifiableList(this.parameters.get(name));
    }

    public void setParameter(String name, String value) {
        this.parameters.replace(name, value);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void removeParameter(String name) {
        this.parameters.removeAll(name);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public int compareTo(VCardProperty that) {
        Integer pref0 = this.getParameters().getPref();
        Integer pref1 = that.getParameters().getPref();
        if (pref0 == null && pref1 == null) {
            return 0;
        }
        if (pref0 == null) {
            return 1;
        }
        if (pref1 == null) {
            return -1;
        }
        return pref1.compareTo(pref0);
    }

    protected Map<String, Object> toStringValues() {
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [ group=").append(this.group);
        sb.append(" | parameters=").append(this.parameters);
        for (Map.Entry<String, Object> field : this.toStringValues().entrySet()) {
            String fieldName = field.getKey();
            Object fieldValue = field.getValue();
            sb.append(" | ").append(fieldName).append('=').append(fieldValue);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public VCardProperty copy() {
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> copyConstructor = clazz.getConstructor(clazz);
            return (VCardProperty)copyConstructor.newInstance(this);
        }
        catch (Exception e2) {
            throw new UnsupportedOperationException(Messages.INSTANCE.getExceptionMessage(31, clazz.getName()), e2);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.toLowerCase().hashCode());
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCardProperty other = (VCardProperty)obj;
        if (this.group == null ? other.group != null : !this.group.equalsIgnoreCase(other.group)) {
            return false;
        }
        return this.parameters.equals(other.parameters);
    }

    List<Pid> getPids() {
        return this.parameters.getPids();
    }

    Integer getPref() {
        return this.parameters.getPref();
    }

    void setPref(Integer pref) {
        this.parameters.setPref(pref);
    }

    String getLanguage() {
        return this.parameters.getLanguage();
    }

    void setLanguage(String language) {
        this.parameters.setLanguage(language);
    }

    Integer getIndex() {
        return this.parameters.getIndex();
    }

    void setIndex(Integer index) {
        this.parameters.setIndex(index);
    }
}

