/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Xml;
import ezvcard.util.XmlUtils;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlScribe
extends VCardPropertyScribe<Xml> {
    public XmlScribe() {
        super(Xml.class, "XML");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Xml property, WriteContext context) {
        Document value = property.getValue();
        if (value == null) {
            return "";
        }
        String xml = this.valueToString(value);
        return XmlScribe.escape(xml, context);
    }

    @Override
    protected Xml _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape(value);
        try {
            return new Xml(value);
        }
        catch (SAXException e2) {
            throw new CannotParseException(21, new Object[0]);
        }
    }

    @Override
    protected void _writeXml(Xml property, XCardElement element) {
        super._writeXml(property, element);
    }

    @Override
    protected Xml _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        Xml xml = new Xml(element.element());
        Element root = xml.getValue().getDocumentElement();
        for (Element child : XmlUtils.toElementList(root.getChildNodes())) {
            if (!"parameters".equals(child.getLocalName()) || !VCardVersion.V4_0.getXmlNamespace().equals(child.getNamespaceURI())) continue;
            root.removeChild(child);
        }
        return xml;
    }

    @Override
    protected JCardValue _writeJson(Xml property) {
        String xml = null;
        Document value = property.getValue();
        if (value != null) {
            xml = this.valueToString(value);
        }
        return JCardValue.single(xml);
    }

    @Override
    protected Xml _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        try {
            String xml = value.asSingle();
            return xml.length() == 0 ? new Xml((Document)null) : new Xml(xml);
        }
        catch (SAXException e2) {
            throw new CannotParseException(22, new Object[0]);
        }
    }

    private String valueToString(Document document) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("omit-xml-declaration", "yes");
        return XmlUtils.toString(document, props);
    }
}

