/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.PlaceProperty;
import ezvcard.util.GeoUri;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlacePropertyScribe<T extends PlaceProperty>
extends VCardPropertyScribe<T> {
    public PlacePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        if (((PlaceProperty)property).getText() != null) {
            return VCardDataType.TEXT;
        }
        if (((PlaceProperty)property).getUri() != null || ((PlaceProperty)property).getGeoUri() != null) {
            return VCardDataType.URI;
        }
        return this._defaultDataType(version);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        String text = ((PlaceProperty)property).getText();
        if (text != null) {
            return VObjectPropertyValues.escape(text);
        }
        String uri = ((PlaceProperty)property).getUri();
        if (uri != null) {
            return uri;
        }
        GeoUri geoUri = ((PlaceProperty)property).getGeoUri();
        if (geoUri != null) {
            return geoUri.toString();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        T property = this.newInstance();
        value = VObjectPropertyValues.unescape(value);
        if (dataType == VCardDataType.TEXT) {
            ((PlaceProperty)property).setText(value);
            return property;
        }
        if (dataType == VCardDataType.URI) {
            try {
                ((PlaceProperty)property).setGeoUri(GeoUri.parse(value));
            }
            catch (IllegalArgumentException e2) {
                ((PlaceProperty)property).setUri(value);
            }
            return property;
        }
        ((PlaceProperty)property).setText(value);
        return property;
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        String text = ((PlaceProperty)property).getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        String uri = ((PlaceProperty)property).getUri();
        if (uri != null) {
            parent.append(VCardDataType.URI, uri);
            return;
        }
        GeoUri geoUri = ((PlaceProperty)property).getGeoUri();
        if (geoUri != null) {
            parent.append(VCardDataType.URI, geoUri.toString());
            return;
        }
        parent.append(VCardDataType.TEXT, "");
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        T property = this.newInstance();
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            ((PlaceProperty)property).setText(text);
            return property;
        }
        String uri = element.first(VCardDataType.URI);
        if (uri != null) {
            try {
                ((PlaceProperty)property).setGeoUri(GeoUri.parse(uri));
            }
            catch (IllegalArgumentException e2) {
                ((PlaceProperty)property).setUri(uri);
            }
            return property;
        }
        throw PlacePropertyScribe.missingXmlElements(VCardDataType.TEXT, VCardDataType.URI);
    }

    @Override
    protected JCardValue _writeJson(T property) {
        String text = ((PlaceProperty)property).getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        String uri = ((PlaceProperty)property).getUri();
        if (uri != null) {
            return JCardValue.single(uri);
        }
        GeoUri geoUri = ((PlaceProperty)property).getGeoUri();
        if (geoUri != null) {
            return JCardValue.single(geoUri.toString());
        }
        return JCardValue.single("");
    }

    @Override
    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        T property = this.newInstance();
        String valueStr = value.asSingle();
        if (dataType == VCardDataType.TEXT) {
            ((PlaceProperty)property).setText(valueStr);
            return property;
        }
        if (dataType == VCardDataType.URI) {
            try {
                ((PlaceProperty)property).setGeoUri(GeoUri.parse(valueStr));
            }
            catch (IllegalArgumentException e2) {
                ((PlaceProperty)property).setUri(valueStr);
            }
            return property;
        }
        ((PlaceProperty)property).setText(valueStr);
        return property;
    }

    protected abstract T newInstance();
}

