/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Organization;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationScribe
extends VCardPropertyScribe<Organization> {
    public OrganizationScribe() {
        super(Organization.class, "ORG");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Organization property, WriteContext context) {
        boolean escapeCommas = context.getVersion() != VCardVersion.V2_1;
        return VObjectPropertyValues.writeSemiStructured(property.getValues(), escapeCommas, context.isIncludeTrailingSemicolons());
    }

    @Override
    protected Organization _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        Organization property = new Organization();
        List<String> values = VObjectPropertyValues.parseSemiStructured(value);
        property.getValues().addAll(values);
        return property;
    }

    @Override
    protected void _writeXml(Organization property, XCardElement parent) {
        parent.append(VCardDataType.TEXT.getName().toLowerCase(), property.getValues());
    }

    @Override
    protected Organization _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        List<String> values = element.all(VCardDataType.TEXT);
        if (!values.isEmpty()) {
            Organization property = new Organization();
            property.getValues().addAll(values);
            return property;
        }
        throw OrganizationScribe.missingXmlElements(VCardDataType.TEXT);
    }

    @Override
    protected Organization _parseHtml(HCardElement element, ParseContext context) {
        String value;
        String orgUnit;
        Organization property = new Organization();
        String orgName = element.firstValue("organization-name");
        if (orgName != null) {
            property.getValues().add(orgName);
        }
        if ((orgUnit = element.firstValue("organization-unit")) != null) {
            property.getValues().add(orgUnit);
        }
        if (property.getValues().isEmpty() && (value = element.value()).length() > 0) {
            property.getValues().add(value);
        }
        return property;
    }

    @Override
    protected JCardValue _writeJson(Organization property) {
        List<Object> values = property.getValues();
        if (values.isEmpty()) {
            return JCardValue.single("");
        }
        if (values.size() == 1) {
            return JCardValue.single(values.get(0));
        }
        return JCardValue.structured(values.toArray(new Object[0]));
    }

    @Override
    protected Organization _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        Organization property = new Organization();
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        while (it.hasNext()) {
            String next = it.nextValue();
            if (next == null) continue;
            property.getValues().add(next);
        }
        return property;
    }
}

