/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.BinaryPropertyScribe;
import ezvcard.parameter.ImageType;
import ezvcard.property.ImageProperty;
import ezvcard.util.DataUri;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImagePropertyScribe<T extends ImageProperty>
extends BinaryPropertyScribe<T, ImageType> {
    public ImagePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected ImageType _mediaTypeFromTypeParameter(String type) {
        return ImageType.get(type, null, null);
    }

    @Override
    protected ImageType _mediaTypeFromMediaTypeParameter(String mediaType) {
        return ImageType.get(null, mediaType, null);
    }

    @Override
    protected ImageType _mediaTypeFromFileExtension(String extension) {
        return ImageType.find(null, null, extension);
    }

    @Override
    protected T _parseHtml(HCardElement element, ParseContext context) {
        String elementName = element.tagName();
        if (!"img".equals(elementName)) {
            return (T)((ImageProperty)super._parseHtml(element, context));
        }
        String src = element.absUrl("src");
        if (src.length() == 0) {
            throw new CannotParseException(13, new Object[0]);
        }
        try {
            DataUri uri = DataUri.parse(src);
            ImageType mediaType = this._mediaTypeFromMediaTypeParameter(uri.getContentType());
            return (T)((ImageProperty)this._newInstance(uri.getData(), mediaType));
        }
        catch (IllegalArgumentException e2) {
            String extension = ImagePropertyScribe.getFileExtension(src);
            ImageType mediaType = extension == null ? null : this._mediaTypeFromFileExtension(extension);
            return (T)((ImageProperty)this._newInstance(src, mediaType));
        }
    }
}

