/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Geo;
import ezvcard.util.GeoUri;
import ezvcard.util.VCardFloatFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoScribe
extends VCardPropertyScribe<Geo> {
    public GeoScribe() {
        super(Geo.class, "GEO");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.URI;
            }
        }
        return null;
    }

    @Override
    protected String _writeText(Geo property, WriteContext context) {
        return this.write(property, context.getVersion());
    }

    @Override
    protected Geo _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        if (value.length() == 0) {
            return new Geo((GeoUri)null);
        }
        switch (context.getVersion()) {
            case V2_1: 
            case V3_0: {
                Double longitude;
                Double latitude;
                int pos = value.indexOf(59);
                if (pos < 0) {
                    throw new CannotParseException(11, new Object[0]);
                }
                String latitudeStr = value.substring(0, pos);
                String longitudeStr = value.substring(pos + 1);
                try {
                    latitude = Double.valueOf(latitudeStr);
                }
                catch (NumberFormatException e2) {
                    throw new CannotParseException(8, latitudeStr);
                }
                try {
                    longitude = Double.valueOf(longitudeStr);
                }
                catch (NumberFormatException e3) {
                    throw new CannotParseException(10, longitudeStr);
                }
                return new Geo(latitude, longitude);
            }
            case V4_0: {
                value = VObjectPropertyValues.unescape(value);
                return this.parseGeoUri(value);
            }
        }
        return null;
    }

    @Override
    protected void _writeXml(Geo property, XCardElement parent) {
        parent.append(VCardDataType.URI, this.write(property, parent.version()));
    }

    @Override
    protected Geo _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String value = element.first(VCardDataType.URI);
        if (value != null) {
            if (value.length() == 0) {
                return new Geo((GeoUri)null);
            }
            return this.parseGeoUri(value);
        }
        throw GeoScribe.missingXmlElements(VCardDataType.URI);
    }

    @Override
    protected Geo _parseHtml(HCardElement element, ParseContext context) {
        Double longitude;
        Double latitude;
        String latitudeStr = element.firstValue("latitude");
        if (latitudeStr == null) {
            throw new CannotParseException(7, new Object[0]);
        }
        try {
            latitude = Double.parseDouble(latitudeStr);
        }
        catch (NumberFormatException e2) {
            throw new CannotParseException(8, latitudeStr);
        }
        String longitudeStr = element.firstValue("longitude");
        if (longitudeStr == null) {
            throw new CannotParseException(9, new Object[0]);
        }
        try {
            longitude = Double.parseDouble(longitudeStr);
        }
        catch (NumberFormatException e3) {
            throw new CannotParseException(10, longitudeStr);
        }
        return new Geo(latitude, longitude);
    }

    @Override
    protected JCardValue _writeJson(Geo property) {
        return JCardValue.single(this.write(property, VCardVersion.V4_0));
    }

    @Override
    protected Geo _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        if (valueStr.length() == 0) {
            return new Geo((GeoUri)null);
        }
        return this.parseGeoUri(valueStr);
    }

    private Geo parseGeoUri(String value) {
        try {
            return new Geo(GeoUri.parse(value));
        }
        catch (IllegalArgumentException e2) {
            throw new CannotParseException(12, new Object[0]);
        }
    }

    private String write(Geo property, VCardVersion version) {
        if (property.getGeoUri() == null) {
            return "";
        }
        switch (version) {
            case V2_1: 
            case V3_0: {
                VCardFloatFormatter formatter = new VCardFloatFormatter(6);
                String latitudeStr = formatter.format(property.getLatitude());
                String longitudeStr = formatter.format(property.getLongitude());
                return latitudeStr + ';' + longitudeStr;
            }
            case V4_0: {
                return property.getGeoUri().toString(6);
            }
        }
        return null;
    }
}

