/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import ezvcard.io.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCardValue {
    private final List<JsonValue> values;

    public JCardValue(List<JsonValue> values) {
        this.values = Collections.unmodifiableList(values);
    }

    public JCardValue(JsonValue ... values) {
        this.values = Arrays.asList(values);
    }

    public static JCardValue single(Object value) {
        return new JCardValue(new JsonValue(value));
    }

    public static JCardValue multi(Object ... values) {
        return JCardValue.multi(Arrays.asList(values));
    }

    public static JCardValue multi(List<?> values) {
        ArrayList<JsonValue> multiValues = new ArrayList<JsonValue>(values.size());
        for (Object value : values) {
            multiValues.add(new JsonValue(value));
        }
        return new JCardValue(multiValues);
    }

    public static JCardValue structured(Object ... values) {
        ArrayList valuesList = new ArrayList(values.length);
        for (Object value : values) {
            List<Object> list = value instanceof List ? (List<Object>)value : Arrays.asList(value);
            valuesList.add(list);
        }
        return JCardValue.structured(valuesList);
    }

    public static JCardValue structured(List<List<?>> values) {
        ArrayList<JsonValue> array = new ArrayList<JsonValue>(values.size());
        for (List<?> list : values) {
            if (list.isEmpty()) {
                array.add(new JsonValue(""));
                continue;
            }
            if (list.size() == 1) {
                Object value = list.get(0);
                if (value == null) {
                    value = "";
                }
                array.add(new JsonValue(value));
                continue;
            }
            ArrayList<JsonValue> subArray = new ArrayList<JsonValue>(list.size());
            for (Object value : list) {
                if (value == null) {
                    value = "";
                }
                subArray.add(new JsonValue(value));
            }
            array.add(new JsonValue(subArray));
        }
        return new JCardValue(new JsonValue(array));
    }

    public List<JsonValue> getValues() {
        return this.values;
    }

    public String asSingle() {
        if (this.values.isEmpty()) {
            return "";
        }
        JsonValue first = this.values.get(0);
        if (first.isNull()) {
            return "";
        }
        Object obj = first.getValue();
        if (obj != null) {
            return obj.toString();
        }
        List<JsonValue> array = first.getArray();
        if (array != null && !array.isEmpty() && (obj = array.get(0).getValue()) != null) {
            return obj.toString();
        }
        return "";
    }

    public List<List<String>> asStructured() {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        JsonValue first = this.values.get(0);
        List<JsonValue> array = first.getArray();
        if (array != null) {
            ArrayList<List<String>> components = new ArrayList<List<String>>(array.size());
            for (JsonValue value : array) {
                List<String> component;
                if (value.isNull()) {
                    components.add(Arrays.asList(new String[0]));
                    continue;
                }
                Object obj = value.getValue();
                if (obj != null) {
                    String s2 = obj.toString();
                    component = s2.length() == 0 ? Arrays.asList(new String[0]) : Arrays.asList(s2);
                    components.add(component);
                    continue;
                }
                List<JsonValue> subArray = value.getArray();
                if (subArray == null) continue;
                component = new ArrayList<String>(subArray.size());
                for (JsonValue subArrayValue : subArray) {
                    if (subArrayValue.isNull()) {
                        component.add("");
                        continue;
                    }
                    obj = subArrayValue.getValue();
                    if (obj == null) continue;
                    component.add(obj.toString());
                }
                if (component.size() == 1 && component.get(0).length() == 0) {
                    component.clear();
                }
                components.add(component);
            }
            return components;
        }
        Object obj = first.getValue();
        if (obj != null) {
            ArrayList<List<String>> components = new ArrayList<List<String>>(1);
            String s3 = obj.toString();
            List<String> component = s3.length() == 0 ? Arrays.asList(new String[0]) : Arrays.asList(s3);
            components.add(component);
            return components;
        }
        if (first.isNull()) {
            ArrayList<List<String>> components = new ArrayList<List<String>>(1);
            components.add(Arrays.asList(new String[0]));
            return components;
        }
        return Collections.emptyList();
    }

    public List<String> asMulti() {
        if (this.values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> multi = new ArrayList<String>(this.values.size());
        for (JsonValue value : this.values) {
            if (value.isNull()) {
                multi.add("");
                continue;
            }
            Object obj = value.getValue();
            if (obj == null) continue;
            multi.add(obj.toString());
        }
        return multi;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        JCardValue that = (JCardValue)o2;
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }
}

