/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.SupportedVersions;
import ezvcard.VCardVersion;
import ezvcard.util.CaseClasses;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardDataType {
    private static final CaseClasses<VCardDataType, String> enums = new CaseClasses<VCardDataType, String>(VCardDataType.class){

        @Override
        protected VCardDataType create(String value) {
            return new VCardDataType(value);
        }

        @Override
        protected boolean matches(VCardDataType dataType, String value) {
            return dataType.name.equalsIgnoreCase(value);
        }
    };
    @SupportedVersions(value={VCardVersion.V2_1})
    public static final VCardDataType URL = new VCardDataType("url");
    @SupportedVersions(value={VCardVersion.V2_1})
    public static final VCardDataType CONTENT_ID = new VCardDataType("content-id");
    @SupportedVersions(value={VCardVersion.V3_0})
    public static final VCardDataType BINARY = new VCardDataType("binary");
    @SupportedVersions(value={VCardVersion.V3_0, VCardVersion.V4_0})
    public static final VCardDataType URI = new VCardDataType("uri");
    public static final VCardDataType TEXT = new VCardDataType("text");
    @SupportedVersions(value={VCardVersion.V3_0, VCardVersion.V4_0})
    public static final VCardDataType DATE = new VCardDataType("date");
    @SupportedVersions(value={VCardVersion.V3_0, VCardVersion.V4_0})
    public static final VCardDataType TIME = new VCardDataType("time");
    @SupportedVersions(value={VCardVersion.V3_0, VCardVersion.V4_0})
    public static final VCardDataType DATE_TIME = new VCardDataType("date-time");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType DATE_AND_OR_TIME = new VCardDataType("date-and-or-time");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType TIMESTAMP = new VCardDataType("timestamp");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType BOOLEAN = new VCardDataType("boolean");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType INTEGER = new VCardDataType("integer");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType FLOAT = new VCardDataType("float");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType UTC_OFFSET = new VCardDataType("utc-offset");
    @SupportedVersions(value={VCardVersion.V4_0})
    public static final VCardDataType LANGUAGE_TAG = new VCardDataType("language-tag");
    private final String name;

    private VCardDataType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VCardVersion[] getSupportedVersions() {
        for (Field field : this.getClass().getFields()) {
            Object fieldValue;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                fieldValue = field.get(null);
            }
            catch (IllegalArgumentException e2) {
                continue;
            }
            catch (IllegalAccessException e3) {
                continue;
            }
            if (fieldValue != this) continue;
            SupportedVersions supportedVersionsAnnotation = field.getAnnotation(SupportedVersions.class);
            return supportedVersionsAnnotation == null ? VCardVersion.values() : supportedVersionsAnnotation.value();
        }
        return VCardVersion.values();
    }

    public boolean isSupportedBy(VCardVersion version) {
        for (VCardVersion supportedVersion : this.getSupportedVersions()) {
            if (supportedVersion != version) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public static VCardDataType find(String dataType) {
        return enums.find(dataType);
    }

    public static VCardDataType get(String dataType) {
        return enums.get(dataType);
    }

    public static Collection<VCardDataType> all() {
        return enums.all();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

