/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.utility.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nxp.nfclib.ndef.Uri;
import com.nxp.tagxplorer.ndef.models.ApplicationRecord;
import com.nxp.tagxplorer.ndef.models.BluetoothRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.ndef.models.TextRecord;
import com.nxp.tagxplorer.ndef.models.VCardRecord;
import com.nxp.tagxplorer.ndef.models.WifiRecord;
import com.nxp.tagxplorer.utility.gson.IJsonSerializable;
import com.nxp.tagxplorer.utility.gson.IRecord;
import com.nxp.tagxplorer.utility.gson.UriDeserializer;
import com.nxp.tagxplorer.utility.gson.UriSerializer;
import java.lang.reflect.Type;

public class GsonUtil {
    private static Gson gson;

    public static String toGson(IJsonSerializable object) {
        return gson.toJson(object);
    }

    public static <T extends IJsonSerializable> T fromJson(String jsonString, Class<T> classOfT) {
        return (T)((IJsonSerializable)gson.fromJson(jsonString, classOfT));
    }

    public static IRecord fromJson(String jsonString, NDEFRecordType recordType) {
        switch (recordType) {
            case LINK_RECORD: 
            case TELEPHONE_RECORD: 
            case SMS_RECORD: 
            case GEO_LOCATION: 
            case EMAIL_RECORD: {
                return GsonUtil.fromJson(jsonString, LinkRecord.class);
            }
            case TEXT_RECORD: {
                return GsonUtil.fromJson(jsonString, TextRecord.class);
            }
            case VCARD_RECORD: {
                return GsonUtil.fromJson(jsonString, VCardRecord.class);
            }
            case WIFI_RECORD: {
                return GsonUtil.fromJson(jsonString, WifiRecord.class);
            }
            case SMART_POSTER_RECORD: {
                return GsonUtil.fromJson(jsonString, SmartPosterRecord.class);
            }
            case AAR_RECORD: {
                return GsonUtil.fromJson(jsonString, ApplicationRecord.class);
            }
            case BLUETOOTH_RECORD: {
                return GsonUtil.fromJson(jsonString, BluetoothRecord.class);
            }
        }
        return null;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Uri.class), new UriDeserializer());
        builder.registerTypeAdapter((Type)((Object)Uri.class), new UriSerializer());
        gson = builder.create();
    }
}

