/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.utility;

import a.f;
import com.nxp.nfclib.CardType;
import com.nxp.nfclib.CustomModules;
import com.nxp.nfclib.KeyType;
import com.nxp.nfclib.defaultimpl.KeyData;
import com.nxp.nfclib.desfire.IDESFireEV1;
import com.nxp.nfclib.interfaces.IKeyData;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import d.a;
import d.g;
import d.h;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.FadeTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.crypto.spec.SecretKeySpec;
import javax.smartcardio.CardTerminal;
import r.c;
import r.k;
import r.l;
import t.d;

public class TagXplorerUtility {
    private static final t.c LOG = d.a(TagXplorerUtility.class.getSimpleName());
    private static byte[] KEY_AES128_DEFAULT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static void checkForT4TOrFormat(IDESFireEV1 desfireCard) {
        KeyData keyData = new KeyData();
        SecretKeySpec key = new SecretKeySpec(TagXplorerConstants.KEY_THREEDES_DEFAULT, "DESede");
        keyData.setKey(key);
        desfireCard.authenticate(0, IDESFireEV1.AuthType.Native, KeyType.THREEDES, keyData);
        int totalTagMemorySize = desfireCard.getTotalMemory();
        int maxNdefSize = 0;
        switch (totalTagMemorySize) {
            case 256: {
                maxNdefSize = 256;
                break;
            }
            case 1024: {
                maxNdefSize = 1022;
                break;
            }
            case 2048: {
                maxNdefSize = 2046;
                break;
            }
            case 4096: {
                maxNdefSize = 4094;
                break;
            }
            case 8192: {
                maxNdefSize = 7678;
            }
        }
        desfireCard.formatT4T(maxNdefSize);
    }

    public static void createErrorAlert(String message) {
        TagXplorerUtility.createAlert(message, Alert.AlertType.ERROR, "Error");
    }

    public static void createFailureAlert(String message) {
        TagXplorerUtility.createAlert(message, Alert.AlertType.ERROR, "Failure");
    }

    public static void createWarningAlert(String message) {
        TagXplorerUtility.createAlert(message, Alert.AlertType.WARNING, "Warning");
    }

    public static void createInfoAlert(String message, String title) {
        TagXplorerUtility.createAlert(message, Alert.AlertType.INFORMATION, title);
    }

    public static void createSuccessAlert(String message) {
        TagXplorerUtility.createAlert(message, Alert.AlertType.INFORMATION, "Success");
    }

    public static Alert createConfirmationAlert(String message) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Confirmation");
        alert.setHeaderText(null);
        alert.setContentText(message);
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getStylesheets().add((Object)RLoader.loadCSS(-479659884L).toExternalForm());
        dialogPane.getStyleClass().add((Object)"myDialog");
        Image conformImage = new Image(RLoader.loadImage(531447225L));
        ImageView imageView = new ImageView(conformImage);
        alert.setGraphic((Node)imageView);
        return alert;
    }

    public static void createAlert(String message, Alert.AlertType type, String title) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(null);
        message = null == message || message.isEmpty() ? "Operation failed with unknown error" : message;
        message = TagXplorerUtility.filterMessage(message);
        alert.setContentText(message);
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getStylesheets().add((Object)RLoader.loadCSS(-479659884L).toExternalForm());
        dialogPane.getStyleClass().add((Object)"myDialog");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        stage.getIcons().add((Object)new Image(RLoader.loadImage(1167501271L)));
        Image infoImage = new Image(RLoader.loadImage(3237038L));
        Image warnImage = new Image(RLoader.loadImage(1124446108L));
        Image errorImage = new Image(RLoader.loadImage(96784904L));
        if (type == Alert.AlertType.INFORMATION) {
            ImageView imageView = new ImageView(infoImage);
            alert.setGraphic((Node)imageView);
        } else if (type == Alert.AlertType.WARNING) {
            ImageView imageView = new ImageView(warnImage);
            alert.setGraphic((Node)imageView);
        } else if (type == Alert.AlertType.ERROR) {
            ImageView imageView = new ImageView(errorImage);
            alert.setGraphic((Node)imageView);
        }
        alert.showAndWait();
    }

    public static void setRippleBackground(Button button, boolean enable) {
        if (enable) {
            TagXplorerUtility.enableRippleBackground(button);
        } else {
            TagXplorerUtility.disableRippleBackground(button);
        }
    }

    public static void enableRippleBackground(Button button) {
        button.setDisable(true);
        button.getStyleClass().add((Object)"ripple_background");
    }

    public static void disableRippleBackground(Button button) {
        button.setDisable(false);
        button.getStyleClass().remove((Object)"ripple_background");
    }

    private static String filterMessage(String message) {
        if (message != null && (message.contains("No response bytes") || message.contains("Card has been removed") || message.contains("SCARD_W_REMOVED_CARD") || message.contains("SCARD_W_RESET_CARD") || message.contains("frame cannot be null"))) {
            message = "Tag has been removed, please reconnect and try again";
        } else if (message != null && message.contains("Writing the configuration is failed")) {
            message = "Writing lock bytes failed.\nSelected page/s may be blocked for locking.";
        } else if (message == null || message.isEmpty()) {
            message = "Operation failed with unknown error";
        } else if (message == null || message.contains("SCARD_E_NO_SMARTCARD") || message.contains("SCARD_E_NOT_TRANSACTED")) {
            message = "Tag is not available.";
        }
        return message;
    }

    public static boolean isCardPresent() {
        k smartCardManager = k.a;
        boolean isCardPresent = false;
        try {
            if (null != smartCardManager.e()) {
                boolean bl2 = isCardPresent = smartCardManager.isConnected() && smartCardManager.e().isCardPresent();
                if (!isCardPresent) {
                    TagXplorerUtility.createAlert("Tag is not available.", Alert.AlertType.WARNING, "Warning");
                }
            } else {
                TagXplorerUtility.createAlert("Please select reader first.", Alert.AlertType.WARNING, "Warning");
            }
        }
        catch (Exception e2) {
            isCardPresent = false;
            LOG.e("", e2);
        }
        return isCardPresent;
    }

    public static boolean checkIfTagPresentAndConnected() {
        boolean isTagPresent;
        block6: {
            k smartCardManager = k.a;
            isTagPresent = false;
            if (!TagXplorerUtility.isReaderConnected(smartCardManager)) {
                TagXplorerUtility.createAlert("No supported reader available.", Alert.AlertType.WARNING, "Warning");
                return false;
            }
            if (smartCardManager.e() == null) {
                TagXplorerUtility.createAlert("Please select supported reader and connect.", Alert.AlertType.WARNING, "Warning");
                return false;
            }
            try {
                if (null == smartCardManager.e()) break block6;
                if (!smartCardManager.e().isCardPresent()) {
                    TagXplorerUtility.createAlert("Tag is not available.", Alert.AlertType.WARNING, "Warning");
                    break block6;
                }
                if (!smartCardManager.isConnected()) {
                    TagXplorerUtility.createAlert("Please connect to tag and retry.", Alert.AlertType.WARNING, "Warning");
                    break block6;
                }
                return true;
            }
            catch (Exception e2) {
                isTagPresent = false;
                LOG.e("", e2);
            }
        }
        return isTagPresent;
    }

    private static boolean isReaderConnected(c smartCardManager) {
        try {
            List<CardTerminal> readerList = smartCardManager.a();
            return readerList.size() > 0 && l.a(readerList);
        }
        catch (d.c e2) {
            return false;
        }
    }

    public static void connectToSmartCard() {
        k smartCardManager = k.a;
        try {
            smartCardManager.close();
            smartCardManager.c();
            smartCardManager.d();
        }
        catch (g g2) {
        }
        catch (a a10) {
        }
        catch (h h2) {
        }
        catch (d.d d2) {
            // empty catch block
        }
    }

    public static IKeyData getAESDefaultKey() {
        SecretKeySpec key = new SecretKeySpec(KEY_AES128_DEFAULT, "AES");
        KeyData keyData = new KeyData();
        keyData.setKey(key);
        return keyData;
    }

    public static FadeTransition getFadeInTransitionInstance() {
        FadeTransition ft = new FadeTransition(Duration.millis((double)230.0));
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        return ft;
    }

    public static FadeTransition getFadeOutTransitionInstance() {
        FadeTransition ft = new FadeTransition(Duration.millis((double)250.0));
        ft.setFromValue(1.0);
        ft.setToValue(0.0);
        return ft;
    }

    public static boolean isDisconnectedFromTag() {
        k smartCardManager = k.a;
        try {
            if (null != smartCardManager.e()) {
                return !smartCardManager.isConnected();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static boolean isValidHexInput(String value) {
        Matcher m2 = Pattern.compile("[0-9a-fA-F]+", 2).matcher(value);
        return m2.matches();
    }

    public static Alert createConfirmationDilog(String message) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Confirmation");
        alert.setHeaderText(null);
        alert.setContentText(message);
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getStylesheets().add((Object)RLoader.loadCSS(-479659884L).toExternalForm());
        dialogPane.getStyleClass().add((Object)"myDialog");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        stage.getIcons().add((Object)new Image(RLoader.loadImage(1167501271L)));
        Image conformImage = new Image(RLoader.loadImage(531447225L));
        ImageView imageView = new ImageView(conformImage);
        alert.setGraphic((Node)imageView);
        return alert;
    }

    public static void addTextLimiter(final TextField tf, final int maxLength) {
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                if (tf.getText().length() > maxLength) {
                    String s2 = tf.getText().substring(0, maxLength);
                    tf.setText(s2);
                }
            }
        });
    }

    public static String captureInputHexFromTextField(TextField inputField) {
        String inputString = inputField.getText().replace("0x", "");
        if (TagXplorerUtility.isValidHexInput(inputString)) {
            return inputString;
        }
        return "";
    }

    public static boolean verifyIfTagPresentAndTypeAndhandleError(CardType cardType) {
        if (!TagXplorerUtility.checkIfTagPresentAndConnected()) {
            return false;
        }
        if (TagXplorerUtility.verifyTagType(cardType)) {
            return true;
        }
        try {
            k.a.d();
        }
        catch (Exception e2) {
            TagXplorerUtility.createWarningAlert(e2.getMessage());
            return false;
        }
        String tagName = TagXplorerConstants.brandNameOfIcType.get((Object)cardType);
        TagXplorerUtility.createErrorAlert("Tag is not of type " + tagName);
        return false;
    }

    public static boolean verifyIfTagPresentAndTypesAndhandleError(String errorMessage, CardType ... cardTypes) {
        if (cardTypes == null || cardTypes.length == 0) {
            return false;
        }
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            boolean isFound = TagXplorerUtility.verifyTagTypes(cardTypes);
            if (!isFound) {
                try {
                    k.a.d();
                }
                catch (Exception e2) {
                    TagXplorerUtility.createAlert(e2.getMessage(), Alert.AlertType.WARNING, "Warning");
                    return isFound;
                }
                TagXplorerUtility.createAlert(errorMessage == null || errorMessage.isEmpty() ? "Invalid Tag found." : errorMessage, Alert.AlertType.ERROR, "Error");
                return isFound;
            }
            return isFound;
        }
        return false;
    }

    public static boolean verifyTagType(CardType cardType) {
        return cardType == f.a.y();
    }

    public static boolean verifyTagTypes(CardType ... cardTypes) {
        boolean isFound = false;
        CardType currentType = f.a.y();
        for (int i2 = 0; i2 < cardTypes.length; ++i2) {
            if (currentType != cardTypes[i2]) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public static void fillWithZero(byte[] byteArray) {
        Arrays.fill(byteArray, (byte)0);
    }

    public static byte hexSingleByteStringToByte(String hexByte) {
        return CustomModules.getUtility().hexStringToByte(hexByte)[0];
    }

    public static String singleByteToHexString(byte hexByte) {
        return CustomModules.getUtility().byteToHexString(new byte[]{hexByte});
    }

    public static String appendZeros(String encFileData) {
        int encFileDataLength = encFileData.length();
        StringBuilder sb = new StringBuilder(encFileData);
        for (int i2 = 0; i2 < encFileDataLength; ++i2) {
            sb.append("0");
        }
        return sb.toString();
    }
}

