/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.utility;

import com.nxp.nfclib.ntag.INTag210;
import com.nxp.nfclib.ntag.INTag213215216;
import com.nxp.nfclib.ntag.INTag213TagTamper;
import com.nxp.nfclib.ntag.NTag210;
import com.nxp.tagxplorer.ndef.models.MirrorFlags;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class NTagSpecificFeaturesUtil {
    public static final byte[] NDEF_DF_NAME = new byte[]{-46, 118, 0, 0, -123, 1, 1};

    public static void handleMirroringForNTag210(INTag210 ntag210, MirrorFlags mirrorFlags) throws IOException {
        try {
            NTag210.MirrorType mirrorType = NTagSpecificFeaturesUtil.getMirrorTypeFor21xTags(mirrorFlags);
            if (mirrorType != NTag210.MirrorType.NO_ASCII_MIRROR) {
                byte[] response = new byte[4];
                int ndef_length = 0;
                int current_page = 4;
                int offset = 0;
                String str = "";
                while ((response = ntag210.read(current_page))[offset % 4] != 3) {
                    offset += 2 + response[offset % 4 + 1];
                    current_page = 4 + offset / 4;
                }
                if (response[offset % 4 + 1] == 0) {
                    throw new IOException();
                }
                ndef_length = response[offset % 4 + 1];
                offset = 0;
                for (int i2 = 4; i2 < ndef_length; i2 += 4) {
                    String temp = new String(response, "UTF-8");
                    offset = (str = str + temp).indexOf("?m=");
                    if (offset != -1) {
                        offset = offset + 3 + current_page * 4;
                        break;
                    }
                    response = ntag210.read(current_page + i2);
                }
                int position = offset;
                int uidPage = position / 4;
                byte uidByte = (byte)(position % 4);
                ntag210.enableMirroring(mirrorType, uidPage, uidByte);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw e3;
        }
    }

    public static void handleMirroringForNTag21x(INTag213215216 ntag21x, MirrorFlags mirrorFlags) throws IOException {
        try {
            NTag210.MirrorType mirrorType = NTagSpecificFeaturesUtil.getMirrorTypeFor21xTags(mirrorFlags);
            if (mirrorType != NTag210.MirrorType.NO_ASCII_MIRROR) {
                byte[] response = new byte[4];
                int ndef_length = 0;
                int current_page = 4;
                int offset = 0;
                String str = "";
                while ((response = ntag21x.read(current_page))[offset % 4] != 3) {
                    offset += 2 + response[offset % 4 + 1];
                    current_page = 4 + offset / 4;
                }
                if (response[offset % 4 + 1] == 0) {
                    throw new IOException();
                }
                ndef_length = response[offset % 4 + 1];
                offset = 0;
                for (int i2 = 4; i2 < ndef_length; i2 += 4) {
                    String temp = new String(response, "UTF-8");
                    offset = (str = str + temp).indexOf("?m=");
                    if (offset != -1) {
                        offset = offset + 3 + current_page * 4;
                        break;
                    }
                    offset = str.indexOf("?c=");
                    if (offset != -1) {
                        offset = offset + 3 + current_page * 4;
                        break;
                    }
                    response = ntag21x.read(current_page + i2);
                }
                int position = offset;
                int uidPage = position / 4;
                byte uidByte = (byte)(position % 4);
                ntag21x.enableMirroring(mirrorType, uidPage, uidByte);
            }
            ntag21x.enableCounter(mirrorFlags.isCounterMirrorEnabled());
        }
        catch (UnsupportedEncodingException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw e3;
        }
    }

    public static void handleMirroringForNTag213TT(INTag213TagTamper ntag213TT, MirrorFlags mirrorFlags) throws Exception {
        byte[] response;
        int current_page = 4;
        int offset = 0;
        String str = "";
        while ((response = ntag213TT.read(current_page))[offset % 4] != 3) {
            offset += 2 + response[offset % 4 + 1];
            current_page = 4 + offset / 4;
        }
        if (response[offset % 4 + 1] == 0) {
            throw new IOException();
        }
        int ndef_length = response[offset % 4 + 1];
        offset = 0;
        for (int i2 = 4; i2 < ndef_length; i2 += 4) {
            String temp = new String(response, "UTF-8");
            offset = (str = str + temp).indexOf("?m=");
            if (offset != -1) {
                offset = offset + 3 + current_page * 4;
                break;
            }
            offset = str.indexOf("?c=");
            if (offset != -1) {
                offset = offset + 3 + current_page * 4;
                break;
            }
            offset = str.indexOf("?t=");
            if (offset != -1) {
                offset = offset + 3 + current_page * 4;
                break;
            }
            response = ntag213TT.read(current_page + i2);
        }
        int position = offset;
        int uidPage = position / 4;
        byte uidByte = (byte)(position % 4);
        INTag213TagTamper.MirrorType mirrorType = NTagSpecificFeaturesUtil.getNTag213TTMirrorType(mirrorFlags);
        ntag213TT.enableMirroring(mirrorType, uidPage, uidByte);
        ntag213TT.enableCounter(mirrorFlags.isCounterMirrorEnabled());
    }

    private static NTag210.MirrorType getMirrorTypeFor21xTags(MirrorFlags mirrorFlags) {
        if (mirrorFlags.isCounterMirrorEnabled() && mirrorFlags.isUidMirrorEnabled()) {
            return NTag210.MirrorType.UID_NFC_CNT_ASCII_MIRROR;
        }
        if (mirrorFlags.isCounterMirrorEnabled()) {
            return NTag210.MirrorType.NFC_CNT_ASCII_MIRROR;
        }
        if (mirrorFlags.isUidMirrorEnabled()) {
            return NTag210.MirrorType.UID_ASCII_MIRROR;
        }
        return NTag210.MirrorType.NO_ASCII_MIRROR;
    }

    private static INTag213TagTamper.MirrorType getNTag213TTMirrorType(MirrorFlags mirrorFlags) {
        if (mirrorFlags.isUidMirrorEnabled() && mirrorFlags.isCounterMirrorEnabled() && mirrorFlags.isTtMessageMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.UID_NFC_CNT_TT_ASCII_MIRROR;
        }
        if (mirrorFlags.isUidMirrorEnabled() && mirrorFlags.isCounterMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.UID_NFC_CNT_ASCII_MIRROR;
        }
        if (mirrorFlags.isTtMessageMirrorEnabled() && mirrorFlags.isCounterMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.NFC_CNT_TT_ASCII_MIRROR;
        }
        if (mirrorFlags.isTtMessageMirrorEnabled() && mirrorFlags.isUidMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.UID_TT_ASCII_MIRROR;
        }
        if (mirrorFlags.isUidMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.UID_ASCII_MIRROR;
        }
        if (mirrorFlags.isCounterMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.NFC_CNT_ASCII_MIRROR;
        }
        if (mirrorFlags.isTtMessageMirrorEnabled()) {
            return INTag213TagTamper.MirrorType.TT_ASCII_MIRROR;
        }
        return INTag213TagTamper.MirrorType.NO_ASCII_MIRROR;
    }
}

