/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.utility;

import com.nxp.nfclib.ndef.NdefMessageWrapper;
import com.nxp.tagxplorer.utility.HEXUtils;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.j;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class NDEFFileUtils {
    private final File file;
    private final String dataToWrite;

    public NDEFFileUtils(File fileToWrite, String data) {
        this.file = fileToWrite;
        this.dataToWrite = data;
    }

    public void create() throws IOException {
        if (this.file == null) {
            throw new IOException("Input File is null");
        }
        if (this.dataToWrite == null) {
            throw new IOException("Input data is null");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<NdefMessage>");
        builder.append(this.dataToWrite);
        builder.append("</NdefMessage>");
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        fileOutputStream.write(builder.toString().getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public List<IRecord> readNDEFMessageAndConvertToIRecord() throws IOException {
        if (this.file == null) {
            throw new IOException("Input File is null");
        }
        FileInputStream fileIS = new FileInputStream(this.file);
        Throwable throwable = null;
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(fileIS));){
            String readString = new String();
            StringBuilder sb = new StringBuilder();
            while ((readString = buf.readLine()) != null) {
                sb.append(readString);
            }
            if (sb.toString().contains("<NdefMessage>")) {
                String dataRead = sb.substring("<NdefMessage>".length(), sb.indexOf("</NdefMessage>"));
                byte[] ndefData = HEXUtils.convertStringToByteArray(dataRead);
                List<IRecord> list = j.a(new NdefMessageWrapper(ndefData));
                return list;
            }
            try {
                throw new IOException("Invalid file.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

