/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.utility;

import com.nxp.tagxplorer.utility.ComboBoxItem;

public class ConfigurationUtils {
    public static final String NFC_COUNTER_ENABLED_FAILED = "Error while enabling NFC Counter.";
    public static final String CONFIG_LOCK_ENABLED_FAILED = "Error while enabling Configuration lock.";
    public static final String NFC_COUNTER_PWD_ENABLED_FAILED = "Error while enabling Password for NFC Counter.";
    public static final String NFC_COUNTER_DISABLE_FAILED = "Error while disabling NFC Counter.";
    public static final String CONFIG_LOCK_DISABLE_FAILED = "Error while disabling Configuration lock.";
    public static final String NFC_COUNTER_PWD_DISABLE_FAILED = "Error while disabling Password for NFC Counter.";
    public static final String PWD_PROTECTION_FOR_READ_WRITE_ENABLE = "Read and Write access is proteted by password.";
    public static final String PWD_PROTECTION_FOR_WRITE_ENABLE = "Write access is proteted by password.";
    public static final String PWD_PROTECTION_START_PAGE_ADDRESS_ENABLE = "Password verification enabled from page ";
    public static final String CONFIG_ALREADY_ENABLED = "Configuration lock is already enabled. This can't be changed.";
    public static final String CONFIG_LOCK_CONFIRMATION = "Are you sure you want to Lock Above Configuration?\nYou will not be allowed to edit User Configuration once locked.";
    public static final String WRITING_CONFIGURATION_FAILED = "Error while editing Configuration.";
    public static final ComboBoxItem[] SEGMENT_PROTECTION_TYPES = new ComboBoxItem[]{new ComboBoxItem<SEGMENT_PROTECTION>(SEGMENT_PROTECTION.Write), new ComboBoxItem<SEGMENT_PROTECTION>(SEGMENT_PROTECTION.ReadWrite)};
    public static final ComboBoxItem[] MIRROR_CONFIGURATIONS = new ComboBoxItem[]{new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.NO_MIRRORING), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UID), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.NFCCounter), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UIDAndCounter), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.TT), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UIDAndTT), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.CounterAndTT), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UIDCounterAndTT)};
    public static final ComboBoxItem[] NTAG_MIRROR_CONFIGURATIONS = new ComboBoxItem[]{new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.NO_MIRRORING), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UID), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.NFCCounter), new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UIDAndCounter)};
    public static final ComboBoxItem[] NTAG210_MIRROR_CONFIGURATIONS = new ComboBoxItem[]{new ComboBoxItem<MIRROR_CONFIG>(MIRROR_CONFIG.UID)};
    public static final ComboBoxItem[] MIRROR_BYTE = new ComboBoxItem[]{new ComboBoxItem<MIRROR_Byte>(MIRROR_Byte.First), new ComboBoxItem<MIRROR_Byte>(MIRROR_Byte.Second), new ComboBoxItem<MIRROR_Byte>(MIRROR_Byte.Third), new ComboBoxItem<MIRROR_Byte>(MIRROR_Byte.Four)};

    public static enum MIRROR_Byte {
        First("00", 0),
        Second("01", 1),
        Third("02", 2),
        Four("03", 3),
        Unknown("Unknown", -1);

        private String name;
        private int value;

        private MIRROR_Byte(String name, int value) {
            this.setName(name);
            this.setValue(value);
        }

        public static MIRROR_Byte parse(int mirrorPageVal) {
            if (mirrorPageVal == 0) {
                return First;
            }
            if (mirrorPageVal == 1) {
                return Second;
            }
            if (mirrorPageVal == 2) {
                return Third;
            }
            if (mirrorPageVal == 3) {
                return Four;
            }
            return Unknown;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        private void setValue(int value) {
            this.value = value;
        }
    }

    public static enum MIRROR_CONFIG {
        NO_MIRRORING("No Mirroring", 0),
        UID("UID", 1),
        NFCCounter("NFC Counter", 2),
        UIDAndCounter("UID & NFC Counter", 3),
        TT("TT", 4),
        UIDAndTT("UID & TT", 5),
        CounterAndTT("NFC Counter & TT", 6),
        UIDCounterAndTT("UID,NFC Counter & TT", 7),
        Unknown("Unknown", -1);

        private String name;
        private int value;

        private MIRROR_CONFIG(String name, int value) {
            this.setName(name);
            this.setValue(value);
        }

        public static MIRROR_CONFIG parse(int mirrorConfigVal) {
            if (mirrorConfigVal == 0) {
                return NO_MIRRORING;
            }
            if (mirrorConfigVal == 1) {
                return UID;
            }
            if (mirrorConfigVal == 2) {
                return NFCCounter;
            }
            if (mirrorConfigVal == 3) {
                return UIDAndCounter;
            }
            if (mirrorConfigVal == 4) {
                return TT;
            }
            if (mirrorConfigVal == 5) {
                return UIDAndTT;
            }
            if (mirrorConfigVal == 6) {
                return CounterAndTT;
            }
            if (mirrorConfigVal == 7) {
                return UIDCounterAndTT;
            }
            return Unknown;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        private void setValue(int value) {
            this.value = value;
        }
    }

    public static enum SEGMENT_PROTECTION {
        Write("WRITE", 0),
        ReadWrite("READ/WRITE", 1),
        Unknown("Unknown", -1);

        private String name;
        private int value;

        private SEGMENT_PROTECTION(String name, int value) {
            this.setName(name);
            this.setValue(value);
        }

        public static SEGMENT_PROTECTION parse(int mirrorPageVal) {
            if (mirrorPageVal == 0) {
                return Write;
            }
            if (mirrorPageVal == 1) {
                return ReadWrite;
            }
            return Unknown;
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        private void setValue(int value) {
            this.value = value;
        }
    }
}

