/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.res.utility;

import com.nxp.tagxplorer.res.utility.Directory;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class ResourceGenerator {
    public static void main(String[] args) {
        File[] listFiles;
        Path resourcesDirPath = ResourceGenerator.currentDirPath().resolve("src/main/resources");
        File resourcesDir = resourcesDirPath.toFile();
        if (resourcesDir != null && resourcesDir.exists() && (listFiles = resourcesDir.listFiles()) != null && listFiles.length != 0) {
            ArrayList<Directory> directories = new ArrayList<Directory>();
            for (File temp : listFiles) {
                Directory directory = new Directory();
                if (temp.isDirectory()) {
                    File[] listFiles2;
                    directory.setName(temp.getName());
                    for (File temp1 : listFiles2 = temp.listFiles()) {
                        if (!temp1.isFile()) continue;
                        String fileName = temp1.getName();
                        directory.add(fileName);
                    }
                }
                if (directory.isEmpty()) continue;
                directories.add(directory);
            }
            ResourceGenerator.generateRClass(directories);
            ResourceGenerator.generatePropertyMapping(directories);
            System.out.println("Success.");
        }
    }

    private static Path currentDirPath() {
        return Paths.get("", new String[0]).toAbsolutePath();
    }

    private static void generatePropertyMapping(ArrayList<Directory> directories) {
        Path resourcesDirPath = ResourceGenerator.currentDirPath().resolve("src/main/resources");
        StringBuilder builder = new StringBuilder();
        builder.append("# Do not edit this file. Auto-generated properties file.\n");
        for (Directory directory : directories) {
            ArrayList<String> gegtList = directory.getList();
            for (String fullFileName : gegtList) {
                String fileName = fullFileName.substring(0, fullFileName.lastIndexOf("."));
                builder.append(fileName.hashCode() + "=" + fullFileName + "\n");
            }
        }
        try {
            File resourcesFile = resourcesDirPath.resolve("com/nxp/tagxplorer/res/Resources.properties").toFile();
            if (resourcesFile.exists()) {
                resourcesFile.delete();
                resourcesFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(resourcesFile);
            fileOutputStream.write(builder.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void generateRClass(ArrayList<Directory> directories) {
        Path sourcesDir = ResourceGenerator.currentDirPath().resolve("src/main/java");
        StringBuilder builder = new StringBuilder();
        builder.append("package com.nxp.tagxplorer.res;\n\n");
        builder.append("\n");
        builder.append("/**\n");
        builder.append(" * Auto-generated class. Do not edit this class! \n");
        builder.append(" */\n");
        builder.append("public final class R {\n");
        for (Directory directory : directories) {
            builder.append("\n");
            builder.append("\tpublic static final class " + directory.getName() + " {\n");
            ArrayList<String> gegtList = directory.getList();
            for (String fileName : gegtList) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                builder.append("\t\tpublic static final long " + fileName + " = " + fileName.hashCode() + ";\n");
            }
            builder.append("\n");
            builder.append("\t}\n");
        }
        builder.append("\n");
        builder.append("}");
        builder.append("\n");
        try {
            File resourcesJavaFile = sourcesDir.resolve("com/nxp/tagxplorer/res/R.java").toFile();
            if (resourcesJavaFile.exists()) {
                resourcesJavaFile.delete();
                resourcesJavaFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(resourcesJavaFile);
            fileOutputStream.write(builder.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

