/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.ntagoperations.memorylayout;

import com.nxp.nfclib.CardType;
import com.nxp.nfclib.CustomModules;
import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.ntagoperations.memorylayout.CustomMemoryLayout;
import com.nxp.tagxplorer.ntagoperations.memorylayout.c;
import com.nxp.tagxplorer.ntagoperations.memorylayout.e;
import com.nxp.tagxplorer.ntagoperations.memorylayout.f;
import com.nxp.tagxplorer.ntagoperations.memorylayout.k;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import h.h;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import k.u;

public class d
extends AbstractController
implements CustomMemoryLayout.b,
c.b {
    @FXML
    private VBox ntagMemoryLayoutMainVbox;
    @FXML
    private CustomMemoryLayout memoryGridLayout;
    @FXML
    private Label startAddressLabel;
    @FXML
    private ComboBox<k> startAddressCombobox;
    @FXML
    private Label endAddressLabel;
    @FXML
    private ComboBox<k> endAddressCombobox;
    @FXML
    private TextArea dataTextArea;
    @FXML
    private Button readPageDataButton;
    @FXML
    private Button writePageDataButton;
    @FXML
    private CheckBox compositeWriteCheckBox;
    @FXML
    private Button fastReadPageDataButton;
    @FXML
    private Button fastWritePageDataButton;
    private c.a a;
    private CardType b = CardType.UnknownCard;

    @Override
    public void initializeViewDependencies() {
        this.a = new f();
        this.a.onSceneActive(this);
    }

    @Override
    public void initializeLayoutDimensions() {
        this.ntagMemoryLayoutMainVbox.setPrefWidth(550.0);
    }

    @Override
    public void initializeListeners() {
        e eventHandler = new e(this);
        this.readPageDataButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.writePageDataButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.fastReadPageDataButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.fastWritePageDataButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
    }

    @Override
    public void initializeDefaults() {
    }

    public void a(CardType cardType, int numberOfPages, String firstColumn, String secondColumn, String thirdColumn) {
        this.b = cardType;
        this.memoryGridLayout.a(numberOfPages, firstColumn, secondColumn, thirdColumn);
        this.memoryGridLayout.a(this);
        switch (cardType) {
            case NTag203X: {
                this.fastReadPageDataButton.setManaged(false);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(h.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(h.b(0, numberOfPages - 1));
                break;
            }
            case NTag213: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTag215: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTag216: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTag210u: {
                this.fastReadPageDataButton.setManaged(false);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTag210: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTag213TagTamper: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTagI2C1K: 
            case NTagI2C2K: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(false);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
            case NTagI2CPlus1K: 
            case NTagI2CPlus2K: {
                this.fastReadPageDataButton.setManaged(true);
                this.fastWritePageDataButton.setManaged(true);
                this.compositeWriteCheckBox.setManaged(false);
                this.startAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                this.endAddressCombobox.setItems(u.b(0, numberOfPages - 1));
                break;
            }
        }
    }

    @Override
    public void a() {
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            if (this.b == a.f.a.y()) {
                int endPage;
                if (this.startAddressCombobox.getValue() == null || this.endAddressCombobox.getValue() == null) {
                    TagXplorerUtility.createAlert("Please select start and end page address.", Alert.AlertType.ERROR, "Failure");
                    return;
                }
                int startPage = ((k)this.startAddressCombobox.getValue()).a();
                if (startPage <= (endPage = ((k)this.endAddressCombobox.getValue()).a())) {
                    this.b(5401);
                    this.a.a(this.b, startPage, endPage);
                    this.l();
                } else {
                    TagXplorerUtility.createAlert("Start page should be greater than or equal to end page.", Alert.AlertType.ERROR, "Error");
                }
            } else if (this.b == CardType.NTag213 || this.b == CardType.NTag215 || this.b == CardType.NTag216 || this.b == CardType.NTag210) {
                TagXplorerUtility.createAlert("Tag mismatch.\nPlace NTAG 21x tag on the reader and try again.", Alert.AlertType.ERROR, "Error");
            } else {
                TagXplorerUtility.createAlert("Tag mismatch.\nPlace " + TagXplorerConstants.brandNameOfIcType.get((Object)this.b) + " tag on the reader and try again.", Alert.AlertType.ERROR, "Error");
            }
        }
    }

    @Override
    public void a(byte[] response) {
        this.dataTextArea.clear();
        this.dataTextArea.setText(CustomModules.getUtility().byteToHexString(response));
        k value = (k)this.startAddressCombobox.getValue();
        int startPage = value.a();
        this.memoryGridLayout.b(startPage, response);
        this.startAddressCombobox.getSelectionModel().select((Object)value);
        this.l();
    }

    @Override
    public void e() {
        TagXplorerUtility.createAlert("Read operation failed.", Alert.AlertType.ERROR, "Failure");
        this.l();
    }

    @Override
    public void b() {
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            if (this.b == a.f.a.y()) {
                if (this.endAddressCombobox.getValue() == null || this.endAddressCombobox.getValue() == null) {
                    TagXplorerUtility.createAlert("Please select start and end page address.", Alert.AlertType.ERROR, "Error");
                    return;
                }
                int startPage = ((k)this.startAddressCombobox.getValue()).a();
                int endPage = ((k)this.endAddressCombobox.getValue()).a();
                int expectedDataLength = (endPage - startPage + 1) * 4;
                if (startPage <= endPage) {
                    if (TagXplorerUtility.isValidHexInput(this.dataTextArea.getText())) {
                        byte[] dataToWritten = CustomModules.getUtility().hexStringToByte(this.dataTextArea.getText());
                        if (dataToWritten.length == expectedDataLength) {
                            this.b(5402);
                            this.a.a(this.b, startPage, endPage, dataToWritten);
                        } else {
                            TagXplorerUtility.createAlert("Length of data to write must be " + expectedDataLength + " bytes", Alert.AlertType.ERROR, "Error");
                        }
                    } else {
                        TagXplorerUtility.createAlert("Data to be written to tag must be in hexadecimal format.", Alert.AlertType.WARNING, "Warning");
                    }
                } else {
                    TagXplorerUtility.createAlert("Start page should be greater than or equal to end page.", Alert.AlertType.ERROR, "Error");
                    this.l();
                }
            } else if (this.b == CardType.NTag213 || this.b == CardType.NTag215 || this.b == CardType.NTag216 || this.b == CardType.NTag210) {
                TagXplorerUtility.createAlert("Tag mismatch.\nPlace NTAG 21x tag on the reader and try again.", Alert.AlertType.ERROR, "Error");
            } else {
                TagXplorerUtility.createAlert("Tag mismatch.\nPlace " + TagXplorerConstants.brandNameOfIcType.get((Object)this.b) + " tag on the reader and try again.", Alert.AlertType.ERROR, "Error");
            }
        }
    }

    @Override
    public void f() {
        TagXplorerUtility.createAlert("Write operation successful.", Alert.AlertType.INFORMATION, "Success");
        this.l();
    }

    @Override
    public void g() {
        TagXplorerUtility.createAlert("Write operation failed.", Alert.AlertType.ERROR, "Failure");
        this.l();
    }

    @Override
    public void c() {
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            if (this.b == a.f.a.y()) {
                int endPage;
                if (this.endAddressCombobox.getValue() == null || this.endAddressCombobox.getValue() == null) {
                    TagXplorerUtility.createAlert("Please select start and end page address.", Alert.AlertType.ERROR, "Error");
                    return;
                }
                int startPage = ((k)this.startAddressCombobox.getValue()).a();
                if (startPage <= (endPage = ((k)this.endAddressCombobox.getValue()).a())) {
                    this.b(5403);
                    this.a.b(this.b, startPage, endPage);
                    this.l();
                } else {
                    TagXplorerUtility.createAlert("Start page should be greater than or equal to end page.", Alert.AlertType.ERROR, "Error");
                }
            } else if (this.b == CardType.NTag213 || this.b == CardType.NTag215 || this.b == CardType.NTag216 || this.b == CardType.NTag210) {
                TagXplorerUtility.createAlert("Tag mismatch.\nPlace NTAG 21x tag on the reader and try again.", Alert.AlertType.ERROR, "Error");
            } else {
                TagXplorerUtility.createAlert("Tag mismatch.\nPlace " + TagXplorerConstants.brandNameOfIcType.get((Object)this.b) + " tag on the reader and try again.", Alert.AlertType.ERROR, "Error");
            }
        }
    }

    @Override
    public void d() {
    }

    @Override
    public void h() {
        TagXplorerUtility.createAlert("Invalid param for write data", Alert.AlertType.ERROR, "Failure");
        this.l();
    }

    @Override
    public void i() {
        this.l();
    }

    @Override
    public void j() {
        this.l();
    }

    @Override
    public void b(byte[] response) {
        this.dataTextArea.clear();
        this.dataTextArea.setText(CustomModules.getUtility().byteToHexString(response));
        k value = (k)this.startAddressCombobox.getValue();
        int startPage = value.a();
        this.memoryGridLayout.b(startPage, response);
        this.startAddressCombobox.getSelectionModel().select((Object)value);
        this.l();
    }

    @Override
    public void k() {
        TagXplorerUtility.createAlert("Fast read operation failed.", Alert.AlertType.ERROR, "Failure");
        this.l();
    }

    @Override
    public void a(int operationType) {
        if (5401 == operationType) {
            TagXplorerUtility.createAlert("Read operation failed.", Alert.AlertType.ERROR, "Error");
        } else if (5402 == operationType) {
            TagXplorerUtility.createAlert("Write operation failed.", Alert.AlertType.ERROR, "Error");
        } else if (5403 == operationType) {
            TagXplorerUtility.createAlert("Fast read operation failed.", Alert.AlertType.ERROR, "Error");
        } else if (5404 == operationType) {
            TagXplorerUtility.createAlert("Fast write operation failed.", Alert.AlertType.ERROR, "Error");
        }
        this.l();
    }

    @Override
    public void a(Throwable e2) {
        TagXplorerUtility.createAlert(e2.getMessage(), Alert.AlertType.ERROR, "Error");
        this.l();
    }

    @Override
    public void b(int operationType) {
        switch (operationType) {
            case 5401: {
                this.readPageDataButton.setDisable(true);
                this.readPageDataButton.getStyleClass().add((Object)"ripple_background");
                break;
            }
            case 5402: {
                this.writePageDataButton.setDisable(true);
                this.writePageDataButton.getStyleClass().add((Object)"ripple_background");
                break;
            }
            case 5403: {
                this.fastReadPageDataButton.setDisable(true);
                this.fastReadPageDataButton.getStyleClass().add((Object)"ripple_background");
            }
        }
    }

    @Override
    public void l() {
        this.readPageDataButton.setDisable(false);
        this.readPageDataButton.getStyleClass().remove((Object)"ripple_background");
        this.writePageDataButton.setDisable(false);
        this.writePageDataButton.getStyleClass().remove((Object)"ripple_background");
        this.fastReadPageDataButton.setDisable(false);
        this.fastReadPageDataButton.getStyleClass().remove((Object)"ripple_background");
    }

    @Override
    public void a(ObservableList list) {
        if (list != null) {
            this.a(this.startAddressCombobox, (Integer)list.get(0));
            this.a(this.endAddressCombobox, (Integer)list.get(list.size() - 1));
        }
    }

    private void a(ComboBox<k> comboBox, int val) {
        ObservableList items = comboBox.getItems();
        for (k index : items) {
            if (index.a() != val) continue;
            comboBox.setValue((Object)index);
            break;
        }
    }
}

