/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.ndef.models;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.nxp.nfclib.ndef.NdefRecord;
import com.nxp.nfclib.ndef.NdefRecordWrapper;
import com.nxp.tagxplorer.ndef.models.ParsedNdefRecord;
import com.nxp.tagxplorer.utility.gson.IJsonSerializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;

public class PlainTextRecord
extends ParsedNdefRecord
implements IJsonSerializable {
    private String mLanguageCode;
    private String mText;
    private String recordType;

    public PlainTextRecord(String languageCode, String text) {
        super(null);
        this.mLanguageCode = Preconditions.checkNotNull(languageCode);
        this.mText = Preconditions.checkNotNull(text);
    }

    public PlainTextRecord(String languageCode, String text, NdefRecordWrapper record) {
        super(record);
        this.mLanguageCode = Preconditions.checkNotNull(languageCode);
        this.mText = Preconditions.checkNotNull(text);
        this.recordType = "Text";
    }

    public static NdefRecordWrapper createTextRecord(String payload, Locale locale, boolean encodeInUtf8) {
        byte[] langBytes = locale.getLanguage().getBytes(Charset.forName("US-ASCII"));
        Charset utfEncoding = encodeInUtf8 ? Charset.forName("UTF-8") : Charset.forName("UTF-16");
        byte[] textBytes = payload.getBytes(utfEncoding);
        int utfBit = encodeInUtf8 ? 0 : 128;
        char status = (char)(utfBit + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        data[0] = (byte)status;
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        NdefRecordWrapper record = new NdefRecordWrapper(1, NdefRecordWrapper.RTD_TEXT, new byte[0], data);
        return record;
    }

    public static PlainTextRecord valueOf(Locale locale, String val) {
        return new PlainTextRecord(locale.getLanguage(), val);
    }

    public static boolean isText(NdefRecordWrapper record) {
        try {
            PlainTextRecord.parse(record);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    public static PlainTextRecord parse(NdefRecordWrapper record) {
        Preconditions.checkArgument(record != null);
        Preconditions.checkArgument(record.getTnf() == 1);
        Preconditions.checkArgument(Arrays.equals(record.getType(), NdefRecord.RTD_TEXT));
        try {
            byte[] payload = record.getPayload();
            String textEncoding = (payload[0] & 0x80) == 0 ? "UTF-8" : "UTF-16";
            int languageCodeLength = payload[0] & 0x3F;
            String languageCode = new String(payload, 1, languageCodeLength, Charsets.US_ASCII);
            String text = new String(payload, languageCodeLength + 1, payload.length - languageCodeLength - 1, textEncoding);
            return new PlainTextRecord(languageCode, text, record);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (IndexOutOfBoundsException e3) {
            throw new IllegalArgumentException(e3);
        }
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String mText) {
        this.mText = mText;
    }

    @Override
    public NdefRecordWrapper toNdefRecord() {
        return this.newTextRecord(this.mText, new Locale(this.mLanguageCode), true);
    }

    private NdefRecordWrapper newTextRecord(String text, Locale locale, boolean encodeInUtf8) {
        if (text != null && text.isEmpty()) {
            return new NdefRecordWrapper(0, new byte[0], new byte[0], new byte[0]);
        }
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(locale);
        byte[] langBytes = locale.getLanguage().getBytes(Charsets.US_ASCII);
        Charset utfEncoding = encodeInUtf8 ? Charsets.UTF_8 : Charsets.UTF_16;
        byte[] textBytes = text.getBytes(utfEncoding);
        int utfBit = encodeInUtf8 ? 0 : 128;
        char status = (char)(utfBit + langBytes.length);
        byte[] data = Bytes.concat({(byte)status}, langBytes, textBytes);
        return new NdefRecordWrapper(1, NdefRecordWrapper.RTD_TEXT, new byte[0], data);
    }

    @Override
    public int getSize() {
        return PlainTextRecord.createTextRecord(this.mText, Locale.getDefault(), true).toByteArray().length;
    }

    @Override
    public String getTitle() {
        return this.recordType;
    }
}

