/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.database;

import com.nxp.tagxplorer.database.IDatabase;
import com.nxp.tagxplorer.database.UserRecord;
import com.nxp.tagxplorer.ndef.models.RecordsHistory;
import com.nxp.tagxplorer.utility.gson.GsonUtil;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DerbyDB
implements IDatabase {
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String INSERT_SQL_STATEMENT = "insert into TagXplorer_1_0(rec_type,rec_data,time) values ";
    public static final String UPDATE_SQL_STATEMENT = "update TagXplorer_1_0 set rec_type ='";
    public static final String DELETE_SQL_STATEMENT = "DELETE FROM TagXplorer_1_0 where id = ";
    public static final String READ_SQL_STATEMENT = "select * from TagXplorer_1_0";
    public static final String TRUNCATE_SQL_STATEMENT = "TRUNCATE TABLE TagXplorer_1_0";
    private static final String JDBC_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String JDBC_URL = "jdbc:derby:tagXplorer;create=true;user=tagXplorer;password=admin";
    private static final String TAG_XPLORER_TABLE_NAME = "tagxplorer_1_0";
    private static final String USER_TABLE_NAME = "user_tagxplorer_1_0";
    private static final String CREATE_TABLE_SQL_STATEMENT = "create table tagxplorer_1_0 (id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),rec_type  VARCHAR(24) NOT NULL,rec_data VARCHAR(2000),time BIGINT)";
    private static final String CREATE_USER_TABLE_SQL_STATEMENT = "create table user_tagxplorer_1_0 (id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),data  VARCHAR(24) NOT NULL,time BIGINT)";
    public static OutputStream DEV_NULL = new OutputStream(){

        @Override
        public void write(int b2) {
        }
    };
    private Connection dbConnection = null;

    static Timestamp convertStringToTimestamp(String str_date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_PATTERN);
            Date date = formatter.parse(str_date);
            Timestamp timeStampDate = new Timestamp(date.getTime());
            return timeStampDate;
        }
        catch (ParseException e2) {
            return null;
        }
    }

    @Override
    public void initializeDatabase() throws SQLException {
        if (!this.isDatabaseAlreadyCreated()) {
            this.connect();
            this.dbConnection.createStatement().execute(CREATE_TABLE_SQL_STATEMENT);
            this.dbConnection.createStatement().execute(CREATE_USER_TABLE_SQL_STATEMENT);
            this.disconnect();
        }
    }

    @Override
    public boolean isDatabaseAlreadyCreated() throws SQLException {
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        DatabaseMetaData dbmd = this.dbConnection.getMetaData();
        ResultSet rs = dbmd.getTables(null, null, TAG_XPLORER_TABLE_NAME.toUpperCase(), null);
        boolean result = rs.next();
        this.disconnect();
        return result;
    }

    @Override
    public List<RecordsHistory> readAllRecords() throws SQLException {
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        int counter = 1;
        ArrayList<RecordsHistory> recordList = new ArrayList<RecordsHistory>();
        Statement statement = this.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery(READ_SQL_STATEMENT);
        while (resultSet.next()) {
            String recordHistoryJSON = resultSet.getString(3);
            RecordsHistory rc = GsonUtil.fromJson(recordHistoryJSON, RecordsHistory.class);
            rc.setID(resultSet.getInt(1));
            rc.setSlNum(counter);
            recordList.add(rc);
            ++counter;
        }
        this.disconnect();
        return recordList;
    }

    @Override
    public void insertRecord(RecordsHistory record) throws SQLException {
        if (record == null) {
            return;
        }
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        if (record.getSize() == 0) {
            return;
        }
        try {
            String gson = GsonUtil.toGson(record);
            String insertQuery = "insert into TagXplorer_1_0(rec_type,rec_data,time) values (?,?,?)";
            PreparedStatement prepareStatement = this.dbConnection.prepareStatement("insert into TagXplorer_1_0(rec_type,rec_data,time) values (?,?,?)");
            prepareStatement.setString(1, record.getType().name());
            prepareStatement.setString(2, gson);
            prepareStatement.setLong(3, record.getTimeStamp());
            int execute = prepareStatement.executeUpdate();
            if (execute == 0) {
                throw new SQLException("Inser record failed for :" + String.valueOf(record));
            }
        }
        catch (Exception e2) {
            throw new SQLException(e2);
        }
        this.disconnect();
    }

    @Override
    public void updateRecord(RecordsHistory record) throws SQLException {
        if (record == null) {
            return;
        }
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        String gson = GsonUtil.toGson(record);
        boolean execute = this.dbConnection.createStatement().execute(UPDATE_SQL_STATEMENT + (Object)((Object)record.getType()) + "',rec_data='" + gson + "',time= '" + record.getTimeStamp() + "' where id= " + record.getID());
        if (!execute) {
            throw new SQLException("Update record failed for :" + String.valueOf(record));
        }
        this.disconnect();
    }

    @Override
    public void deleteRecord(int identifier) throws SQLException {
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        if (identifier != 0) {
            this.dbConnection.createStatement().execute(DELETE_SQL_STATEMENT + identifier);
            this.disconnect();
        }
    }

    @Override
    public void truncateRecords() throws SQLException {
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        this.dbConnection.createStatement().execute(TRUNCATE_SQL_STATEMENT);
        this.disconnect();
    }

    private boolean isConnectionAvailable() {
        return this.dbConnection != null;
    }

    private void connect() throws SQLException {
        if (!this.isConnectionAvailable()) {
            System.setProperty("derby.stream.error.field", "com.nxp.tagxplorer.database.DerbyDB.DEV_NULL");
            try {
                Class.forName(JDBC_DRIVER);
                this.dbConnection = DriverManager.getConnection(JDBC_URL);
            }
            catch (ClassNotFoundException e2) {
                new SQLException(e2);
            }
        }
    }

    private void disconnect() {
        if (this.isConnectionAvailable()) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dbConnection = null;
        }
    }

    @Override
    public void insertUserRecord(UserRecord record) throws SQLException {
        if (record == null) {
            return;
        }
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        try {
            String insertQuery = "insert into user_tagxplorer_1_0(data,time) values (?,?)";
            PreparedStatement prepareStatement = this.dbConnection.prepareStatement("insert into user_tagxplorer_1_0(data,time) values (?,?)");
            prepareStatement.setString(1, record.getName());
            prepareStatement.setLong(2, record.getTimestamp());
            int execute = prepareStatement.executeUpdate();
            if (execute == 0) {
                throw new SQLException("Inser record failed for :" + String.valueOf(record));
            }
        }
        catch (Exception e2) {
            throw new SQLException(e2);
        }
        this.disconnect();
    }

    @Override
    public boolean isUserRegistered() throws SQLException {
        if (!this.isConnectionAvailable()) {
            this.connect();
        }
        boolean result = false;
        String selectQuery = "select * from user_tagxplorer_1_0";
        Statement statement = this.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from user_tagxplorer_1_0");
        result = resultSet.next();
        this.disconnect();
        return result;
    }
}

